/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.security.processor;

import io.mosip.kernel.core.security.constants.MosipSecurityExceptionCodeConstants;
import io.mosip.kernel.core.security.exception.MosipInvalidDataException;
import io.mosip.kernel.core.security.exception.MosipInvalidKeyException;
import io.mosip.kernel.core.security.exception.MosipNullDataException;
import io.mosip.kernel.core.security.exception.MosipNullKeyException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class SymmetricProcessor {
    protected SymmetricProcessor() {
    }

    protected static byte[] process(BlockCipher blockCipher, byte[] key, byte[] data, boolean mode) throws MosipInvalidKeyException, MosipInvalidDataException {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher(blockCipher));
        try {
            cipher.init(mode, (CipherParameters)new KeyParameter(key));
        }
        catch (NullPointerException e) {
            throw new MosipNullKeyException(MosipSecurityExceptionCodeConstants.MOSIP_NULL_KEY_EXCEPTION);
        }
        catch (IllegalArgumentException e) {
            throw new MosipInvalidKeyException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_KEY_SIZE_EXCEPTION);
        }
        byte[] output = null;
        try {
            output = new byte[cipher.getOutputSize(data.length)];
        }
        catch (NullPointerException e) {
            throw new MosipNullDataException(MosipSecurityExceptionCodeConstants.MOSIP_NULL_DATA_EXCEPTION);
        }
        int processedBytes = cipher.processBytes(data, 0, data.length, output, 0);
        try {
            cipher.doFinal(output, processedBytes);
        }
        catch (InvalidCipherTextException e) {
            throw new MosipInvalidDataException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_ENCRYPTED_DATA_CORRUPT_EXCEPTION);
        }
        catch (DataLengthException e) {
            throw new MosipInvalidDataException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_DATA_SIZE_EXCEPTION);
        }
        return output;
    }
}

