/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.exception.DataFormatException;
import io.mosip.kernel.core.util.constant.ZipUtilConstants;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private ZipUtils() {
    }

    public static byte[] zipByteArray(byte[] input) throws io.mosip.kernel.core.exception.IOException {
        byte[] byReturn = null;
        Deflater oDeflate = new Deflater(8, false);
        oDeflate.setInput(input);
        oDeflate.finish();
        try (ByteArrayOutputStream oZipStream = new ByteArrayOutputStream();){
            while (!oDeflate.finished()) {
                byte[] byRead = new byte[1024];
                int iBytesRead = oDeflate.deflate(byRead);
                if (iBytesRead == byRead.length) {
                    oZipStream.write(byRead);
                    continue;
                }
                oZipStream.write(byRead, 0, iBytesRead);
            }
            oDeflate.end();
            byReturn = oZipStream.toByteArray();
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
        return byReturn;
    }

    public static byte[] unzipByteArray(byte[] input) throws io.mosip.kernel.core.exception.IOException {
        byte[] byReturn = null;
        Inflater oInflate = new Inflater(false);
        oInflate.setInput(input);
        try (ByteArrayOutputStream oZipStream = new ByteArrayOutputStream();){
            while (!oInflate.finished()) {
                byte[] byRead = new byte[1024];
                int iBytesRead = oInflate.inflate(byRead);
                if (iBytesRead == byRead.length) {
                    oZipStream.write(byRead);
                    continue;
                }
                oZipStream.write(byRead, 0, iBytesRead);
            }
            byReturn = oZipStream.toByteArray();
        }
        catch (java.util.zip.DataFormatException e) {
            throw new DataFormatException(ZipUtilConstants.DATA_FORMATE_ERROR_CODE.getErrorCode(), ZipUtilConstants.DATA_FORMATE_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
        return byReturn;
    }

    private static void readFile(ZipOutputStream zipOut, FileInputStream fis) throws IOException {
        int length;
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
    }

    private static boolean zipFileInDir(File fileToZip, String fileName, ZipOutputStream zipOut) throws io.mosip.kernel.core.exception.IOException {
        if (fileToZip.isHidden()) {
            return false;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            for (File childFile : children = fileToZip.listFiles()) {
                ZipUtils.zipFileInDir(childFile, fileName + File.separator + childFile.getName(), zipOut);
            }
            return false;
        }
        try (FileInputStream fis = new FileInputStream(fileToZip);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            ZipUtils.readFile(zipOut, fis);
        }
        catch (FileNotFoundException e) {
            throw new io.mosip.kernel.core.exception.FileNotFoundException(ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getErrorCode(), ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
        return true;
    }

    private static void createOutputFile(ZipInputStream zipInStream, File newFile) throws IOException, io.mosip.kernel.core.exception.FileNotFoundException {
        byte[] buffer = new byte[1024];
        try (FileOutputStream fos = new FileOutputStream(newFile);){
            int len;
            while ((len = zipInStream.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            throw new io.mosip.kernel.core.exception.FileNotFoundException(ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getErrorCode(), ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static boolean unZipDirectory(String zipFilePath, String destDirectory) throws Exception {
        boolean isCreated;
        File destDir = new File(destDirectory);
        String canonicalDestinationDirPath = destDir.getCanonicalPath();
        if (!destDir.exists() && !(isCreated = destDir.mkdir())) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage());
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                boolean isCreated2;
                String filePath = destDirectory + File.separator + entry.getName();
                File dir = new File(filePath);
                String canonicalDestinationFile = dir.getCanonicalPath();
                if (!canonicalDestinationFile.startsWith(canonicalDestinationDirPath + File.separator)) {
                    throw new ZipException(ZipUtilConstants.ARCHIVER_ERROR_CODE.getMessage());
                }
                if (!entry.isDirectory()) {
                    isCreated2 = new File(filePath).getParentFile().mkdirs();
                    if (!isCreated2) {
                        throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage());
                    }
                    ZipUtils.extractFile(zipIn, filePath);
                } else {
                    isCreated2 = dir.mkdirs();
                    if (!isCreated2) {
                        throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage());
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        catch (FileNotFoundException e) {
            throw new io.mosip.kernel.core.exception.FileNotFoundException(ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getErrorCode(), ZipUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(ZipUtilConstants.IO_ERROR_CODE.getErrorCode(), ZipUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
        return true;
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            byte[] bytesIn = new byte[10000];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }
}

