/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.exception.IllegalArgumentException;
import io.mosip.kernel.core.exception.NullPointerException;
import io.mosip.kernel.core.util.constant.FileUtilConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.Checksum;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.IOFileFilter;

public class FileUtils {
    private FileUtils() {
    }

    public static String byteCountToDisplaySize(long size) {
        return org.apache.commons.io.FileUtils.byteCountToDisplaySize((long)size);
    }

    public static Checksum checksum(File file, Checksum checksum) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.checksum((File)file, (Checksum)checksum);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static long checksumCRC32(File file) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.checksumCRC32((File)file);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void cleanDirectory(File directory) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.cleanDirectory((File)directory);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static boolean contentEquals(File file1, File file2) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.contentEquals((File)file1, (File)file2);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static boolean contentEqualsIgnoreEOL(File file1, File file2, String charsetName) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file2, (String)charsetName);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection<File> files) {
        return org.apache.commons.io.FileUtils.convertFileCollectionToFileArray(files);
    }

    public static void copyDirectory(File srcDir, File destDir) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void copyFile(File srcFile, File destFile) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static long copyFile(File input, OutputStream output) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.copyFile((File)input, (OutputStream)output);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)source, (File)destination);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void copyToFile(InputStream source, File destination) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.copyToFile((InputStream)source, (File)destination);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void deleteDirectory(File directory) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static boolean directoryContains(File directory, File child) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.directoryContains((File)directory, (File)child);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void forceDelete(File file) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.forceDelete((File)file);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (FileNotFoundException e) {
            throw new io.mosip.kernel.core.exception.FileNotFoundException(FileUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getErrorCode(), FileUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void forceDeleteOnExit(File file) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.forceDeleteOnExit((File)file);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static File getFile(File directory, String ... names) {
        return org.apache.commons.io.FileUtils.getFile((File)directory, (String[])names);
    }

    public static File getFile(String ... names) {
        return org.apache.commons.io.FileUtils.getFile((String[])names);
    }

    public static boolean isFileNewer(File file, Date date) {
        try {
            return org.apache.commons.io.FileUtils.isFileNewer((File)file, (java.util.Date)date);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static boolean isFileOlder(File file, Date date) {
        try {
            return org.apache.commons.io.FileUtils.isFileOlder((File)file, (java.util.Date)date);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static boolean isSymlink(File file) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.isSymlink((File)file);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static Iterator<File> iterateFiles(File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        return org.apache.commons.io.FileUtils.iterateFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }

    public static LineIterator lineIterator(File file) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.lineIterator((File)file);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static LineIterator lineIterator(File file, String encoding) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.lineIterator((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static Collection<File> listFiles(File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        return org.apache.commons.io.FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }

    public static Collection<File> listFilesAndDirs(File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        return org.apache.commons.io.FileUtils.listFilesAndDirs((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }

    public static void moveDirectory(File srcDir, File destDir) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.moveDirectory((File)srcDir, (File)destDir);
        }
        catch (FileExistsException e) {
            throw new io.mosip.kernel.core.exception.FileExistsException(FileUtilConstants.FILE_EXISTS_ERROR_CODE.getErrorCode(), FileUtilConstants.FILE_EXISTS_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void moveDirectoryToDirectory(File src, File destDir, boolean createDestDir) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.moveDirectoryToDirectory((File)src, (File)destDir, (boolean)createDestDir);
        }
        catch (FileExistsException e) {
            throw new io.mosip.kernel.core.exception.FileExistsException(FileUtilConstants.FILE_EXISTS_ERROR_CODE.getErrorCode(), FileUtilConstants.FILE_EXISTS_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void moveFile(File srcFile, File destFile) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.moveFile((File)srcFile, (File)destFile);
        }
        catch (FileExistsException e) {
            throw new io.mosip.kernel.core.exception.FileExistsException(FileUtilConstants.FILE_EXISTS_ERROR_CODE.getErrorCode(), FileUtilConstants.FILE_EXISTS_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void moveFileToDirectory(File srcFile, File destDir, boolean createDestDir) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.moveFileToDirectory((File)srcFile, (File)destDir, (boolean)createDestDir);
        }
        catch (FileExistsException e) {
            throw new io.mosip.kernel.core.exception.FileExistsException(FileUtilConstants.FILE_EXISTS_ERROR_CODE.getErrorCode(), FileUtilConstants.FILE_EXISTS_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void moveToDirectory(File src, File destDir, boolean createDestDir) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.moveToDirectory((File)src, (File)destDir, (boolean)createDestDir);
        }
        catch (FileExistsException e) {
            throw new io.mosip.kernel.core.exception.FileExistsException(FileUtilConstants.FILE_EXISTS_ERROR_CODE.getErrorCode(), FileUtilConstants.FILE_EXISTS_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static FileInputStream openInputStream(File file) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.openInputStream((File)file);
        }
        catch (FileNotFoundException e) {
            throw new io.mosip.kernel.core.exception.FileNotFoundException(FileUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getErrorCode(), FileUtilConstants.FILE_NOT_FOUND_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static FileOutputStream openOutputStream(File file) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.openOutputStream((File)file);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.openOutputStream((File)file, (boolean)append);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static byte[] readFileToByteArray(File file) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static String readFileToString(File file, Charset encoding) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)encoding);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static List<String> readLines(File file, Charset encoding) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.readLines((File)file, (Charset)encoding);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static List<String> readLines(File file, String encoding) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.readLines((File)file, (String)encoding);
        }
        catch (UnsupportedCharsetException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedCharsetException(FileUtilConstants.UNSUPPORTED_CHARSET_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_CHARSET_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static long sizeOf(File file) {
        try {
            return org.apache.commons.io.FileUtils.sizeOf((File)file);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static long sizeOfDirectory(File directory) {
        try {
            return org.apache.commons.io.FileUtils.sizeOfDirectory((File)directory);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static File toFile(URL url) {
        return org.apache.commons.io.FileUtils.toFile((URL)url);
    }

    public static File[] toFiles(URL[] urls) {
        try {
            return org.apache.commons.io.FileUtils.toFiles((URL[])urls);
        }
        catch (java.lang.IllegalArgumentException e) {
            throw new IllegalArgumentException(FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getErrorCode(), FileUtilConstants.ILLEGAL_ARGUMENT_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static URL[] toURLs(File[] files) throws io.mosip.kernel.core.exception.IOException {
        try {
            return org.apache.commons.io.FileUtils.toURLs((File[])files);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static boolean waitFor(File file, int seconds) {
        try {
            return org.apache.commons.io.FileUtils.waitFor((File)file, (int)seconds);
        }
        catch (java.lang.NullPointerException e) {
            throw new NullPointerException(FileUtilConstants.NULL_POINTER_ERROR_CODE.getErrorCode(), FileUtilConstants.NULL_POINTER_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void write(File file, CharSequence data, String encoding) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.write((File)file, (CharSequence)data, (String)encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedEncodingException(FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void write(File file, CharSequence data, Charset encoding) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.write((File)file, (CharSequence)data, (Charset)encoding);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void write(File file, CharSequence data, Charset encoding, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.write((File)file, (CharSequence)data, (Charset)encoding, (boolean)append);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void write(File file, CharSequence data, String encoding, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.write((File)file, (CharSequence)data, (String)encoding, (boolean)append);
        }
        catch (UnsupportedCharsetException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedCharsetException(FileUtilConstants.UNSUPPORTED_CHARSET_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_CHARSET_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeByteArrayToFile(File file, byte[] data) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeByteArrayToFile(File file, byte[] data, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])data, (boolean)append);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeByteArrayToFile(File file, byte[] data, int off, int len) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])data, (int)off, (int)len);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeByteArrayToFile(File file, byte[] data, int off, int len, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])data, (int)off, (int)len, (boolean)append);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeLines(File file, Collection<?> lines) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, lines);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeLines(File file, Collection<?> lines, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, lines, (boolean)append);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeLines(File file, String encoding, Collection<?> lines, String lineEnding, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, (String)encoding, lines, (String)lineEnding, (boolean)append);
        }
        catch (UnsupportedEncodingException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedEncodingException(FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeLines(File file, Collection<?> lines, String lineEnding) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, lines, (String)lineEnding);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeLines(File file, String encoding, Collection<?> lines, String lineEnding) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, (String)encoding, lines, (String)lineEnding);
        }
        catch (UnsupportedEncodingException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedEncodingException(FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeLines(File file, String encoding, Collection<?> lines) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, (String)encoding, lines);
        }
        catch (UnsupportedEncodingException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedEncodingException(FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeLines(File file, String encoding, Collection<?> lines, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, (String)encoding, lines, (boolean)append);
        }
        catch (UnsupportedEncodingException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedEncodingException(FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeLines(File file, Collection<?> lines, String lineEnding, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, lines, (String)lineEnding, (boolean)append);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeStringToFile(File file, String data, Charset encoding) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data, (Charset)encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedEncodingException(FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeStringToFile(File file, String data, String encoding, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data, (String)encoding, (boolean)append);
        }
        catch (UnsupportedCharsetException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedCharsetException(FileUtilConstants.UNSUPPORTED_CHARSET_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_CHARSET_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeStringToFile(File file, String data, String encoding) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data, (String)encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new io.mosip.kernel.core.exception.UnsupportedEncodingException(FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getErrorCode(), FileUtilConstants.UNSUPPORTED_ENCODING_ERROR_CODE.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }

    public static void writeStringToFile(File file, String data, Charset encoding, boolean append) throws io.mosip.kernel.core.exception.IOException {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data, (Charset)encoding, (boolean)append);
        }
        catch (IOException e) {
            throw new io.mosip.kernel.core.exception.IOException(FileUtilConstants.IO_ERROR_CODE.getErrorCode(), FileUtilConstants.IO_ERROR_CODE.getMessage(), e.getCause());
        }
    }
}

