/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.security.algorithms;

import io.mosip.kernel.core.security.exception.MosipInvalidDataException;
import io.mosip.kernel.core.security.exception.MosipInvalidKeyException;
import io.mosip.kernel.core.security.processor.AsymmetricProcessor;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

public class MosipRSA
extends AsymmetricProcessor {
    private MosipRSA() {
    }

    public static byte[] hybridRsaAesWithPKCS1Padding(AsymmetricKeyParameter key, byte[] data, boolean mode) throws MosipInvalidDataException, MosipInvalidKeyException {
        return MosipRSA.processHybrid((AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()), key, data, mode);
    }

    public static byte[] hybridRsaAesWithOAEPWithMD5AndMGF1Padding(AsymmetricKeyParameter key, byte[] data, boolean mode) throws MosipInvalidDataException, MosipInvalidKeyException {
        return MosipRSA.processHybrid((AsymmetricBlockCipher)new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)new MD5Digest()), key, data, mode);
    }

    public static byte[] hybridRsaAesWithOAEPWithSHA3512AndMGF1Padding(AsymmetricKeyParameter key, byte[] data, boolean mode) throws MosipInvalidDataException, MosipInvalidKeyException {
        return MosipRSA.processHybrid((AsymmetricBlockCipher)new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)new SHA3Digest(512)), key, data, mode);
    }

    public static byte[] rsaWithPKCS1Padding(AsymmetricKeyParameter key, byte[] data, boolean mode) throws MosipInvalidDataException, MosipInvalidKeyException {
        return MosipRSA.process((AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()), key, data, mode);
    }

    public static byte[] rsaWithOAEPWithMD5AndMGF1Padding(AsymmetricKeyParameter key, byte[] data, boolean mode) throws MosipInvalidDataException, MosipInvalidKeyException {
        return MosipRSA.process((AsymmetricBlockCipher)new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)new MD5Digest()), key, data, mode);
    }

    public static byte[] rsaWithOAEPWithSHA3512AndMGF1Padding(AsymmetricKeyParameter key, byte[] data, boolean mode) throws MosipInvalidDataException, MosipInvalidKeyException {
        return MosipRSA.process((AsymmetricBlockCipher)new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)new SHA3Digest(512)), key, data, mode);
    }
}

