/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.core.exception.ServiceError;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionUtils.class);

    private ExceptionUtils() {
    }

    public static String buildMessage(String message, Throwable cause) {
        if (cause != null) {
            StringBuilder sb = new StringBuilder();
            if (message != null) {
                sb.append(message).append("; ");
            }
            sb.append("\n");
            sb.append("nested exception is ").append(cause);
            return sb.toString();
        }
        return message;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static List<ServiceError> getServiceErrorList(String responseBody) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<ServiceError> validationErrorsList = new ArrayList<ServiceError>();
        try {
            JsonNode errorResponse = mapper.readTree(responseBody);
            if (errorResponse.has("errors")) {
                JsonNode errors = errorResponse.get("errors");
                for (JsonNode parameterNode : errors) {
                    ServiceError serviceError = new ServiceError(ExceptionUtils.getJsonValue(parameterNode, "errorCode"), ExceptionUtils.getJsonValue(parameterNode, "message"));
                    validationErrorsList.add(serviceError);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return validationErrorsList;
    }

    private static String getJsonValue(JsonNode node, String propName) {
        if (node.get(propName) != null) {
            return node.get(propName).asText();
        }
        return null;
    }

    public static void logRootCause(Throwable exception) {
        System.out.println("\n\n");
        exception.printStackTrace();
        System.out.println("\n");
    }
}

