/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.cbeffutil.entity;

import io.mosip.kernel.core.cbeffutil.entity.BDBInfo;
import io.mosip.kernel.core.cbeffutil.entity.BIRInfo;
import io.mosip.kernel.core.cbeffutil.entity.BIRVersion;
import io.mosip.kernel.core.cbeffutil.entity.SBInfo;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.BIRType;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class BIR {
    private BIRVersion version;
    private BIRVersion cbeffversion;
    private BIRInfo birInfo;
    private BDBInfo bdbInfo;
    private byte[] bdb;
    private byte[] sb;
    private SBInfo sbInfo;
    private List<JAXBElement<String>> element;

    public BIR(BIRBuilder birBuilder) {
        this.version = birBuilder.version;
        this.cbeffversion = birBuilder.cbeffversion;
        this.birInfo = birBuilder.birInfo;
        this.bdbInfo = birBuilder.bdbInfo;
        this.bdb = birBuilder.bdb;
        this.sb = birBuilder.sb;
        this.sbInfo = birBuilder.sbInfo;
        this.element = birBuilder.element;
    }

    public List<JAXBElement<String>> getElement() {
        return this.element;
    }

    public BIRVersion getVersion() {
        return this.version;
    }

    public BIRVersion getCbeffversion() {
        return this.cbeffversion;
    }

    public BIRInfo getBirInfo() {
        return this.birInfo;
    }

    public BDBInfo getBdbInfo() {
        return this.bdbInfo;
    }

    public byte[] getBdb() {
        return this.bdb;
    }

    public byte[] getSb() {
        return this.sb;
    }

    public SBInfo getSbInfo() {
        return this.sbInfo;
    }

    public BIRType toBIRType(BIR bir) {
        BIRType bIRType = new BIRType();
        if (bir.getVersion() != null) {
            bIRType.setVersion(bir.getVersion().toVersion());
        }
        if (bir.getCbeffversion() != null) {
            bIRType.setCBEFFVersion(bir.getCbeffversion().toVersion());
        }
        bIRType.setBDB(this.getBdb());
        bIRType.setSB(this.getSb());
        if (bir.getBirInfo() != null) {
            bIRType.setBIRInfo(bir.getBirInfo().toBIRInfo());
        }
        if (bir.getBdbInfo() != null) {
            bIRType.setBDBInfo(bir.getBdbInfo().toBDBInfo());
        }
        if (bir.getSbInfo() != null) {
            bIRType.setSBInfo(bir.getSbInfo().toSBInfoType());
        }
        if (bir.getElement() != null) {
            bIRType.setAny(this.getElement());
        }
        return bIRType;
    }

    public static class BIRBuilder {
        private BIRVersion version;
        private BIRVersion cbeffversion;
        private BIRInfo birInfo;
        private BDBInfo bdbInfo;
        private byte[] bdb;
        private byte[] sb;
        private SBInfo sbInfo;
        private List<JAXBElement<String>> element;

        public BIRBuilder withElement(List<JAXBElement<String>> list) {
            this.element = list;
            return this;
        }

        public BIRBuilder withVersion(BIRVersion version) {
            this.version = version;
            return this;
        }

        public BIRBuilder withCbeffversion(BIRVersion cbeffversion) {
            this.cbeffversion = cbeffversion;
            return this;
        }

        public BIRBuilder withBirInfo(BIRInfo birInfo) {
            this.birInfo = birInfo;
            return this;
        }

        public BIRBuilder withBdbInfo(BDBInfo bdbInfo) {
            this.bdbInfo = bdbInfo;
            return this;
        }

        public BIRBuilder withBdb(byte[] bdb) {
            this.bdb = bdb;
            return this;
        }

        public BIRBuilder withSb(byte[] sb) {
            this.sb = sb;
            return this;
        }

        public BIRBuilder withSbInfo(SBInfo sbInfo) {
            this.sbInfo = sbInfo;
            return this;
        }

        public BIR build() {
            return new BIR(this);
        }
    }
}

