/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.cbeffutil.common;

import io.mosip.kernel.core.cbeffutil.common.CbeffXSDValidator;
import io.mosip.kernel.core.cbeffutil.entity.BDBInfo;
import io.mosip.kernel.core.cbeffutil.entity.BIR;
import io.mosip.kernel.core.cbeffutil.entity.BIRInfo;
import io.mosip.kernel.core.cbeffutil.exception.CbeffException;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.BDBInfoType;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.BIRType;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.RegistryIDType;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.SingleAnySubtypeType;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.SingleType;
import io.mosip.kernel.core.util.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

public class CbeffValidator {
    public static boolean validateXML(BIRType bir) throws CbeffException {
        if (bir == null) {
            throw new CbeffException("BIR value is null");
        }
        List<BIRType> birList = bir.getBIR();
        for (BIRType birType : birList) {
            if (birType == null) continue;
            if (birType.getBDB().length < 1) {
                throw new CbeffException("BDB value can't be empty");
            }
            if (birType.getBDBInfo() != null) {
                BDBInfoType bdbInfo = birType.getBDBInfo();
                List<SingleType> singleTypeList = bdbInfo.getType();
                if (singleTypeList == null || singleTypeList.isEmpty()) {
                    throw new CbeffException("Type value needs to be provided");
                }
                if (CbeffValidator.validateFormatType(Long.valueOf(bdbInfo.getFormat().getType()), singleTypeList)) continue;
                throw new CbeffException("Patron Format type is invalid");
            }
            throw new CbeffException("BDB information can't be empty");
        }
        return false;
    }

    private static boolean validateFormatType(long formatType, List<SingleType> singleTypeList) {
        SingleType singleType = singleTypeList.get(0);
        switch (singleType.value()) {
            case "Finger": {
                return formatType == 7L || formatType == 2L;
            }
            case "Iris": {
                return formatType == 9L;
            }
            case "Face": {
                return formatType == 8L;
            }
            case "HandGeometry": {
                return formatType == 8L;
            }
        }
        return false;
    }

    private static long getFormatType(String type) {
        switch (type.toLowerCase()) {
            case "finger": {
                return 7L;
            }
            case "iris": {
                return 9L;
            }
            case "fmr": {
                return 2L;
            }
            case "face": {
                return 8L;
            }
            case "handgeometry": {
                return 8L;
            }
        }
        return 0L;
    }

    public static byte[] createXMLBytes(BIRType bir, byte[] xsd) throws Exception {
        CbeffValidator.validateXML(bir);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BIRType.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(baos);
        jaxbMarshaller.marshal((Object)bir, (Writer)writer);
        byte[] savedData = baos.toByteArray();
        writer.close();
        try {
            CbeffXSDValidator.validateXML(xsd, savedData);
        }
        catch (SAXException sax) {
            String message = sax.getMessage();
            message = message.substring(message.indexOf(":"));
            throw new CbeffException("XSD validation failed due to attribute " + message);
        }
        return savedData;
    }

    public static BIRType getBIRFromXML(byte[] fileBytes) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BIRType.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement jaxBir = unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(fileBytes)), BIRType.class);
        BIRType bir = (BIRType)jaxBir.getValue();
        return bir;
    }

    public static Map<String, String> getBDBBasedOnTypeAndSubType(BIRType bir, String type, String subType) throws Exception {
        if (type == null && subType == null) {
            return CbeffValidator.getAllLatestDatafromBIR(bir);
        }
        SingleType singleType = null;
        SingleAnySubtypeType singleAnySubType = null;
        Long formatType = null;
        if (type != null) {
            singleType = CbeffValidator.getSingleType(type);
        }
        if (subType != null) {
            singleAnySubType = CbeffValidator.getSingleAnySubtype(subType);
        }
        if (type != null) {
            formatType = CbeffValidator.getFormatType(type);
        }
        HashMap<String, String> bdbMap = new HashMap<String, String>();
        if (bir.getBIR() != null && bir.getBIR().size() > 0) {
            for (BIRType birType : bir.getBIR()) {
                BDBInfoType bdbInfo = birType.getBDBInfo();
                if (bdbInfo == null) continue;
                List<String> singleSubTypeList = bdbInfo.getSubtype();
                List<SingleType> singleTypeList = bdbInfo.getType();
                String bdbFormatType = bdbInfo.getFormat().getType();
                boolean formatMatch = Long.valueOf(bdbFormatType).equals(formatType);
                if (singleAnySubType == null && singleTypeList.contains((Object)singleType) && formatMatch) {
                    bdbMap.put(singleType.toString() + "_" + String.join((CharSequence)" ", singleSubTypeList) + "_" + String.valueOf(bdbFormatType) + "_" + bdbInfo.getCreationDate().toInstant(ZoneOffset.UTC).toEpochMilli(), CryptoUtil.encodeBase64String(birType.getBDB()));
                    continue;
                }
                if (singleType == null && singleSubTypeList.contains(singleAnySubType.value())) {
                    List<String> singleTypeStringList = CbeffValidator.convertToList(singleTypeList);
                    bdbMap.put(String.join((CharSequence)" ", singleTypeStringList) + "_" + String.join((CharSequence)" ", singleSubTypeList) + "_" + String.valueOf(bdbFormatType) + "_" + bdbInfo.getCreationDate().toInstant(ZoneOffset.UTC).toEpochMilli(), CryptoUtil.encodeBase64String(birType.getBDB()));
                    continue;
                }
                if (!singleTypeList.contains((Object)singleType) || !singleSubTypeList.contains(singleAnySubType != null ? singleAnySubType.value() : null) || !formatMatch) continue;
                bdbMap.put(singleType.toString() + "_" + singleAnySubType.value() + "_" + String.valueOf(bdbFormatType) + "_" + bdbInfo.getCreationDate().toInstant(ZoneOffset.UTC).toEpochMilli(), CryptoUtil.encodeBase64String(birType.getBDB()));
            }
        }
        TreeMap map = new TreeMap(bdbMap);
        HashMap<String, String> finalMap = new HashMap<String, String>();
        for (Map.Entry mapEntry : map.entrySet()) {
            String pattern = ((String)mapEntry.getKey()).substring(0, ((String)mapEntry.getKey()).lastIndexOf("_"));
            if (!((String)mapEntry.getKey()).contains(pattern)) continue;
            finalMap.put(((String)mapEntry.getKey()).substring(0, ((String)mapEntry.getKey()).lastIndexOf("_")), (String)mapEntry.getValue());
        }
        return finalMap;
    }

    private static Map<String, String> getAllLatestDatafromBIR(BIRType bir) throws Exception {
        HashMap<String, String> bdbMap = new HashMap<String, String>();
        if (bir.getBIR() != null && bir.getBIR().size() > 0) {
            for (BIRType birType : bir.getBIR()) {
                BDBInfoType bdbInfo = birType.getBDBInfo();
                if (bdbInfo == null) continue;
                List<String> singleSubTypeList = bdbInfo.getSubtype();
                List<SingleType> singleTypeList = bdbInfo.getType();
                if (singleSubTypeList.isEmpty()) {
                    singleSubTypeList = new ArrayList<String>();
                    singleSubTypeList.add("No Subtype");
                }
                String bdbFormatType = bdbInfo.getFormat().getType();
                bdbMap.put(String.join((CharSequence)" ", singleTypeList.get(0).toString()) + "_" + String.join((CharSequence)" ", singleSubTypeList) + "_" + String.valueOf(bdbFormatType) + "_" + bdbInfo.getCreationDate().toInstant(ZoneOffset.UTC).toEpochMilli(), CryptoUtil.encodeBase64String(birType.getBDB()));
            }
        }
        TreeMap map = new TreeMap(bdbMap);
        HashMap<String, String> finalMap = new HashMap<String, String>();
        for (Map.Entry mapEntry : map.entrySet()) {
            String pattern = ((String)mapEntry.getKey()).substring(0, ((String)mapEntry.getKey()).lastIndexOf("_"));
            if (!((String)mapEntry.getKey()).contains(pattern)) continue;
            finalMap.put(((String)mapEntry.getKey()).substring(0, ((String)mapEntry.getKey()).lastIndexOf("_")), (String)mapEntry.getValue());
        }
        return finalMap;
    }

    private static List<String> convertToList(List<SingleType> singleTypeList) {
        return singleTypeList.stream().map(Enum::name).collect(Collectors.toList());
    }

    private static SingleAnySubtypeType getSingleAnySubtype(String subType) {
        return subType != null ? SingleAnySubtypeType.fromValue(subType) : null;
    }

    private static SingleType getSingleType(String type) {
        if (CbeffValidator.isInEnum(type, SingleType.class)) {
            return SingleType.valueOf(type);
        }
        switch (type) {
            case "FMR": {
                return SingleType.FINGER;
            }
        }
        return SingleType.fromValue(type);
    }

    public static <E extends Enum<E>> boolean isInEnum(String value, Class<E> enumClass) {
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!e.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> getAllBDBData(BIRType bir, String type, String subType) throws Exception {
        SingleType singleType = null;
        SingleAnySubtypeType singleAnySubType = null;
        Long formatType = null;
        if (type != null) {
            singleType = CbeffValidator.getSingleType(type);
        }
        if (subType != null) {
            singleAnySubType = CbeffValidator.getSingleAnySubtype(subType);
        }
        if (type != null) {
            formatType = CbeffValidator.getFormatType(type);
        }
        HashMap<String, String> bdbMap = new HashMap<String, String>();
        if (bir.getBIR() != null && bir.getBIR().size() > 0) {
            for (BIRType birType : bir.getBIR()) {
                BDBInfoType bdbInfo = birType.getBDBInfo();
                if (bdbInfo == null) continue;
                List<String> singleSubTypeList = bdbInfo.getSubtype();
                List<SingleType> singleTypeList = bdbInfo.getType();
                String bdbFormatType = bdbInfo.getFormat().getType();
                boolean formatMatch = Long.valueOf(bdbFormatType).equals(formatType);
                if (singleAnySubType == null && singleTypeList.contains((Object)singleType) && formatMatch) {
                    bdbMap.put(singleType.toString() + "_" + String.join((CharSequence)" ", singleSubTypeList) + "_" + String.valueOf(bdbFormatType) + "_" + bdbInfo.getCreationDate().toInstant(ZoneOffset.UTC).toEpochMilli(), new String(birType.getBDB(), "UTF-8"));
                    continue;
                }
                if (singleType == null && singleSubTypeList.contains(singleAnySubType.value())) {
                    List<String> singleTypeStringList = CbeffValidator.convertToList(singleTypeList);
                    bdbMap.put(String.join((CharSequence)" ", singleSubTypeList) + "_" + String.join((CharSequence)" ", singleTypeStringList) + "_" + String.valueOf(bdbFormatType) + "_" + bdbInfo.getCreationDate().toInstant(ZoneOffset.UTC).toEpochMilli(), new String(birType.getBDB(), "UTF-8"));
                    continue;
                }
                if (!singleTypeList.contains((Object)singleType) || !singleSubTypeList.contains(singleAnySubType != null ? singleAnySubType.value() : null) || !formatMatch) continue;
                bdbMap.put(singleAnySubType.toString() + "_" + singleType.toString() + "_" + String.valueOf(bdbFormatType) + "_" + bdbInfo.getCreationDate().toInstant(ZoneOffset.UTC).toEpochMilli(), new String(birType.getBDB(), "UTF-8"));
            }
        }
        return bdbMap;
    }

    public static List<BIR> convertBIRTypeToBIR(List<BIRType> birType) {
        List<BIR> birTypeList = CbeffValidator.getBIRList(birType);
        return birTypeList;
    }

    private static List<BIR> getBIRList(List<BIRType> birTypeList) {
        ArrayList<BIR> birList = new ArrayList<BIR>();
        for (BIRType birType : birTypeList) {
            RegistryIDType format = new RegistryIDType();
            format.setOrganization(birType.getBDBInfo().getFormat().getOrganization());
            format.setType(birType.getBDBInfo().getFormat().getType());
            BIR bir = new BIR.BIRBuilder().withBdb(birType.getBDB()).withElement(birType.getAny()).withBirInfo(new BIRInfo.BIRInfoBuilder().withIntegrity(birType.getBIRInfo().isIntegrity()).build()).withBdbInfo(new BDBInfo.BDBInfoBuilder().withFormat(format).withQuality(birType.getBDBInfo().getQuality()).withType(birType.getBDBInfo().getType()).withSubtype(birType.getBDBInfo().getSubtype()).withPurpose(birType.getBDBInfo().getPurpose()).withLevel(birType.getBDBInfo().getLevel()).withCreationDate(birType.getBDBInfo().getCreationDate()).build()).build();
            birList.add(bir);
        }
        return birList;
    }

    public static List<BIRType> getBIRDataFromXMLType(byte[] xmlBytes, String type) throws Exception {
        SingleType singleType = null;
        ArrayList<BIRType> updatedBIRList = new ArrayList<BIRType>();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BIRType.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement jaxBir = unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(xmlBytes)), BIRType.class);
        BIRType bir = (BIRType)jaxBir.getValue();
        for (BIRType birType : bir.getBIR()) {
            List<SingleType> singleTypeList;
            if (type == null) continue;
            singleType = CbeffValidator.getSingleType(type);
            BDBInfoType bdbInfo = birType.getBDBInfo();
            if (bdbInfo == null || (singleTypeList = bdbInfo.getType()) == null || !singleTypeList.contains((Object)singleType)) continue;
            updatedBIRList.add(birType);
        }
        return updatedBIRList;
    }
}

