/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.authcodeflowproxy.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.authcodeflowproxy.api.validator.ValidateTokenUtil;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.openid.bridge.api.constants.AuthErrorCode;
import io.mosip.kernel.openid.bridge.api.constants.Constants;
import io.mosip.kernel.openid.bridge.api.constants.Errors;
import io.mosip.kernel.openid.bridge.api.exception.AuthRestException;
import io.mosip.kernel.openid.bridge.api.exception.ClientException;
import io.mosip.kernel.openid.bridge.api.exception.ServiceException;
import io.mosip.kernel.openid.bridge.api.service.LoginService;
import io.mosip.kernel.openid.bridge.api.utils.AuthCodeProxyFlowUtils;
import io.mosip.kernel.openid.bridge.dto.AccessTokenResponse;
import io.mosip.kernel.openid.bridge.dto.AccessTokenResponseDTO;
import io.mosip.kernel.openid.bridge.dto.IAMErrorResponseDto;
import io.mosip.kernel.openid.bridge.dto.JWSSignatureRequestDto;
import io.mosip.kernel.openid.bridge.dto.JWTSignatureResponseDto;
import io.mosip.kernel.openid.bridge.model.MosipUserDto;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.Cookie;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class LoginServiceImpl
implements LoginService {
    private static final String TOKEN_VALID = "TOKEN_VALID";
    @Value(value="${mosip.kernel.auth-code-url-splitter:#URISPLITTER#}")
    private String urlSplitter;
    @Value(value="${mosip.security.secure-cookie:false}")
    private boolean isSecureCookie;
    @Value(value="${auth.token.header:Authorization}")
    private String authTokenHeader;
    @Value(value="${auth.jwt.expiry:1800000}")
    private int authTokenExpiry;
    @Value(value="${mosip.iam.module.login_flow.name:authorization_code}")
    private String loginFlowName;
    @Value(value="${mosip.iam.module.clientid}")
    private String clientID;
    @Value(value="${mosip.iam.module.clientsecret}")
    private String clientSecret;
    @Value(value="${mosip.iam.module.redirecturi}")
    private String redirectURI;
    @Value(value="${mosip.iam.module.login_flow.scope:cls}")
    private String scope;
    @Value(value="${mosip.iam.module.login_flow.response_type:code}")
    private String responseType;
    @Value(value="${mosip.iam.authorization_endpoint}")
    private String authorizationEndpoint;
    @Value(value="${mosip.iam.module.admin_realm_id}")
    private String realmID;
    @Value(value="${mosip.iam.token_endpoint}")
    private String tokenEndpoint;
    @Value(value="${auth.server.admin.validate.url:}")
    private String validateUrl;
    @Value(value="${mosip.iam.post-logout-uri-param-key:post_logout_redirect_uri}")
    private String postLogoutRedirectURIParamKey;
    @Value(value="${mosip.iam.end-session-endpoint-path:/protocol/openid-connect/logout}")
    private String endSessionEndpointPath;
    @Value(value="${mosip.iam.module.token.endpoint.private-key-jwt.auth.enabled:false}")
    private boolean isJwtAuthEnabled;
    @Value(value="${mosip.iam.logout.offline:false}")
    private boolean offlineLogout;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired(required=false)
    @Qualifier(value="selfTokenRestTemplate")
    private RestTemplate selfTokenRestTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Environment environment;
    @Autowired
    private ValidateTokenUtil validateTokenUtil;

    public String login(String redirectURI, String state) {
        HashMap<String, String> pathParam = new HashMap<String, String>();
        pathParam.put("realmId", this.realmID);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)this.authorizationEndpoint);
        uriComponentsBuilder.queryParam("client_id", new Object[]{this.clientID});
        uriComponentsBuilder.queryParam("redirect_uri", new Object[]{this.redirectURI + redirectURI});
        uriComponentsBuilder.queryParam("state", new Object[]{state});
        uriComponentsBuilder.queryParam("response_type", new Object[]{this.responseType});
        uriComponentsBuilder.queryParam("scope", new Object[]{this.scope});
        String claim = this.environment.getProperty("mosip.iam.module.login_flow.claims");
        if (claim != null) {
            uriComponentsBuilder.queryParam("claims", new Object[]{LoginServiceImpl.urlEncode(claim)});
        }
        return uriComponentsBuilder.buildAndExpand(pathParam).toString();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException(Errors.UNSUPPORTED_ENCODING_EXCEPTION.getErrorCode(), Errors.UNSUPPORTED_ENCODING_EXCEPTION.getErrorMessage() + " " + e.getMessage(), (Throwable)e);
        }
    }

    public Cookie createCookie(String authCookie) {
        Cookie cookie = new Cookie(this.authTokenHeader, authCookie);
        cookie.setMaxAge(this.authTokenExpiry);
        cookie.setHttpOnly(true);
        cookie.setSecure(this.isSecureCookie);
        cookie.setPath("/");
        return cookie;
    }

    public Cookie createExpiringCookie() {
        Cookie cookie = new Cookie(this.authTokenHeader, null);
        cookie.setMaxAge(0);
        cookie.setHttpOnly(true);
        cookie.setSecure(this.isSecureCookie);
        cookie.setPath("/");
        return cookie;
    }

    public Object valdiateToken(String authToken) {
        MosipUserDto mosipUserDto;
        if (this.validateUrl == null || this.validateUrl.isEmpty()) {
            ImmutablePair<Boolean, AuthErrorCode> tokenValid = this.validateTokenUtil.isTokenValid(authToken);
            if (((Boolean)tokenValid.left).booleanValue()) {
                return TOKEN_VALID;
            }
            throw new AuthRestException(List.of(new ServiceError(((AuthErrorCode)tokenValid.right).getErrorCode(), ((AuthErrorCode)tokenValid.right).getErrorMessage())), HttpStatus.UNAUTHORIZED);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cookie", this.authTokenHeader + "=" + authToken);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(this.validateUrl, HttpMethod.GET, requestEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            String responseBody = e.getResponseBodyAsString();
            List validationErrorList = ExceptionUtils.getServiceErrorList((String)responseBody);
            if (!validationErrorList.isEmpty()) {
                throw new AuthRestException(validationErrorList, e.getStatusCode());
            }
            throw new ServiceException(Errors.REST_EXCEPTION.getErrorCode(), e.getResponseBodyAsString());
        }
        String responseBody = (String)response.getBody();
        List validationErrorList = ExceptionUtils.getServiceErrorList((String)responseBody);
        if (!validationErrorList.isEmpty()) {
            throw new AuthRestException(validationErrorList, response.getStatusCode());
        }
        try {
            ResponseWrapper responseObject = (ResponseWrapper)this.objectMapper.readValue((String)response.getBody(), ResponseWrapper.class);
            mosipUserDto = (MosipUserDto)this.objectMapper.readValue(this.objectMapper.writeValueAsString(responseObject.getResponse()), MosipUserDto.class);
        }
        catch (IOException e) {
            throw new ServiceException(Errors.IO_EXCEPTION.getErrorCode(), Errors.IO_EXCEPTION.getErrorMessage());
        }
        return mosipUserDto;
    }

    public AccessTokenResponseDTO loginRedirect(String state, String sessionState, String code, String stateCookie, String redirectURI) {
        if (!stateCookie.equals(state)) {
            throw new ClientException(Errors.STATE_EXCEPTION.getErrorCode(), Errors.STATE_EXCEPTION.getErrorMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)this.loginFlowName);
        map.add((Object)"client_id", (Object)this.clientID);
        if (this.isJwtAuthEnabled) {
            map.add((Object)"client_assertion", (Object)this.getClientAssertion());
            map.add((Object)"client_assertion_type", (Object)this.environment.getProperty("mosip.client.assertion.type"));
        } else {
            map.add((Object)"client_secret", (Object)this.clientSecret);
        }
        map.add((Object)"code", (Object)code);
        map.add((Object)"redirect_uri", (Object)(this.redirectURI + redirectURI));
        HashMap<String, String> pathParam = new HashMap<String, String>();
        pathParam.put("realmId", this.realmID);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.tokenEndpoint);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uriBuilder.buildAndExpand(pathParam).toUriString(), HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            IAMErrorResponseDto keycloakErrorResponseDto = this.parseKeyClockErrorResponse((HttpStatusCodeException)e);
            throw new ServiceException(Errors.ACESSTOKEN_EXCEPTION.getErrorCode(), Errors.ACESSTOKEN_EXCEPTION.getErrorMessage() + " " + keycloakErrorResponseDto.getError_description(), e);
        }
        AccessTokenResponse accessTokenResponse = null;
        try {
            accessTokenResponse = (AccessTokenResponse)this.objectMapper.readValue((String)responseEntity.getBody(), AccessTokenResponse.class);
        }
        catch (IOException exception) {
            throw new ServiceException(Errors.RESPONSE_PARSE_ERROR.getErrorCode(), Errors.RESPONSE_PARSE_ERROR.getErrorMessage() + " " + exception.getMessage(), (Throwable)exception);
        }
        AccessTokenResponseDTO accessTokenResponseDTO = new AccessTokenResponseDTO();
        accessTokenResponseDTO.setAccessToken(accessTokenResponse.getAccess_token());
        accessTokenResponseDTO.setExpiresIn(accessTokenResponse.getExpires_in());
        accessTokenResponseDTO.setIdToken(accessTokenResponse.getId_token());
        return accessTokenResponseDTO;
    }

    private String getClientAssertion() {
        JWSSignatureRequestDto jwsSignatureRequestDto = new JWSSignatureRequestDto();
        try {
            jwsSignatureRequestDto.setDataToSign(CryptoUtil.encodeToPlainBase64((byte[])this.getClientAssertionData()));
            jwsSignatureRequestDto.setReferenceId(this.environment.getProperty("mosip.client.assertion.reference.id"));
            jwsSignatureRequestDto.setApplicationId(this.environment.getProperty("APPLICATION_Id"));
            jwsSignatureRequestDto.setIncludePayload(Boolean.valueOf(this.environment.getProperty("mosip.include.payload")));
            jwsSignatureRequestDto.setIncludeCertificate(Boolean.valueOf(this.environment.getProperty("mosip.include.certificate")));
            jwsSignatureRequestDto.setIncludeCertHash(Boolean.valueOf(this.environment.getProperty("mosip.include.cert.hash")));
            RequestWrapper requestWrapper = new RequestWrapper();
            requestWrapper.setRequest((Object)jwsSignatureRequestDto);
            requestWrapper.setRequesttime(DateUtils.getUTCCurrentDateTime());
            HttpEntity requestWrapperHttpEntity = new HttpEntity((Object)requestWrapper);
            ResponseWrapper responseWrapper = (ResponseWrapper)this.selfTokenRestTemplate.exchange(URI.create(Objects.requireNonNull(this.environment.getProperty("mosip.keymanager.jwt.sign.end.point"))), HttpMethod.POST, requestWrapperHttpEntity, ResponseWrapper.class).getBody();
            Object responseObject = Objects.requireNonNull(responseWrapper).getResponse();
            JWTSignatureResponseDto responseDto = (JWTSignatureResponseDto)this.objectMapper.convertValue(responseObject, JWTSignatureResponseDto.class);
            return responseDto.getJwtSignedData();
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            throw new ServiceException(Errors.JWT_SIGN_EXCEPTION.getErrorCode(), Errors.JWT_SIGN_EXCEPTION.getErrorMessage());
        }
    }

    private byte[] getClientAssertionData() {
        LinkedHashMap<Object, Object> dataToSignMap = new LinkedHashMap<Object, Object>();
        dataToSignMap.put(Constants.SUB, this.clientID);
        dataToSignMap.put(Constants.ISS, this.clientID);
        dataToSignMap.put(Constants.AUD, this.tokenEndpoint);
        dataToSignMap.put(Constants.EXP, this.getExpiryTime());
        dataToSignMap.put(Constants.IAT, this.getEpochTime());
        String jsonObject = null;
        try {
            jsonObject = this.objectMapper.writeValueAsString(dataToSignMap);
        }
        catch (JsonProcessingException e) {
            throw new ServiceException(Errors.JSON_PROCESSING_EXCEPTION.getErrorCode(), Errors.JSON_PROCESSING_EXCEPTION.getErrorMessage());
        }
        return jsonObject.getBytes();
    }

    private Object getEpochTime() {
        Instant instant = Instant.now();
        return instant.getEpochSecond();
    }

    private Object getExpiryTime() {
        int expirySec = Integer.parseInt(Objects.requireNonNull(this.environment.getProperty("mosip.iam.module.token.endpoint.private-key-jwt.expiry.seconds")));
        Instant instant = Instant.now().plusSeconds(expirySec);
        return instant.getEpochSecond();
    }

    private IAMErrorResponseDto parseKeyClockErrorResponse(HttpStatusCodeException exception) {
        IAMErrorResponseDto keycloakErrorResponseDto = null;
        try {
            keycloakErrorResponseDto = (IAMErrorResponseDto)this.objectMapper.readValue(exception.getResponseBodyAsString(), IAMErrorResponseDto.class);
        }
        catch (IOException e) {
            throw new ServiceException(Errors.RESPONSE_PARSE_ERROR.getErrorCode(), Errors.RESPONSE_PARSE_ERROR.getErrorMessage() + " " + e.getMessage());
        }
        return keycloakErrorResponseDto;
    }

    public String logoutUser(String token, String redirectURI) {
        UriComponentsBuilder uriComponentsBuilder;
        if (EmptyCheckUtils.isNullEmpty((String)token)) {
            throw new AuthenticationServiceException(Errors.INVALID_TOKEN.getErrorMessage());
        }
        if (this.offlineLogout) {
            return new String(Base64.decodeBase64((byte[])redirectURI.getBytes()));
        }
        String issuer = AuthCodeProxyFlowUtils.getissuer((String)token);
        StringBuilder urlBuilder = new StringBuilder().append(issuer).append(this.endSessionEndpointPath);
        try {
            uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)urlBuilder.toString()).queryParam(this.postLogoutRedirectURIParamKey, new Object[]{URLEncoder.encode(redirectURI, StandardCharsets.UTF_8.toString())});
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException(Errors.UNSUPPORTED_ENCODING_EXCEPTION.getErrorCode(), Errors.UNSUPPORTED_ENCODING_EXCEPTION.getErrorMessage() + " " + e.getMessage(), (Throwable)e);
        }
        return uriComponentsBuilder.build().toString();
    }
}

