/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.authcodeflowproxy.api.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.openid.bridge.api.constants.Errors;
import io.mosip.kernel.openid.bridge.api.exception.AuthRestException;
import io.mosip.kernel.openid.bridge.api.exception.ClientException;
import io.mosip.kernel.openid.bridge.api.exception.ServiceException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
@Order(value=-2147483648)
public class AuthCodeProxyExceptionHandler {
    @Autowired
    private ObjectMapper objectMapper;

    @ExceptionHandler(value={ClientException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> clientException(HttpServletRequest httpServletRequest, ClientException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText()), HttpStatus.OK);
    }

    @ExceptionHandler(value={ServiceException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> servieException(HttpServletRequest httpServletRequest, ServiceException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        HttpStatus status = e.getErrorCode().equals(Errors.INVALID_TOKEN.getErrorCode()) ? HttpStatus.UNAUTHORIZED : HttpStatus.OK;
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText()), status);
    }

    @ExceptionHandler(value={AuthenticationServiceException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> servieException(HttpServletRequest httpServletRequest, AuthenticationServiceException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, Errors.INVALID_TOKEN.getErrorCode(), e.getMessage()), HttpStatus.OK);
    }

    @ExceptionHandler(value={AuthRestException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> authRestException(HttpServletRequest httpServletRequest, AuthRestException exception) throws IOException {
        ExceptionUtils.logRootCause((Throwable)exception);
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        errorResponse.getErrors().addAll(exception.getList());
        return new ResponseEntity(errorResponse, exception.getHttpStatus());
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponsetime(LocalDateTime.now(ZoneId.of("UTC")));
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }

    private ResponseWrapper<ServiceError> getErrorResponse(HttpServletRequest httpServletRequest, String errorCode, String errorMessage) throws IOException {
        ServiceError error = new ServiceError(errorCode, errorMessage);
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        errorResponse.getErrors().add(error);
        return errorResponse;
    }
}

