/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.service.impl;

import io.mosip.kernel.auth.defaultimpl.service.TokenGenerationService;
import io.mosip.kernel.core.authmanager.model.AuthNResponseDto;
import io.mosip.kernel.core.authmanager.model.ClientSecret;
import io.mosip.kernel.openid.bridge.api.service.AuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TokenGenerationServiceImpl
implements TokenGenerationService {
    @Lazy
    @Autowired
    AuthService authService;
    @Value(value="${mosip.kernel.auth.app.id}")
    private String authAppId;
    @Value(value="${mosip.kernel.auth.client.id}")
    private String clientId;
    @Value(value="${mosip.kernel.auth.secret.key}")
    private String secretKey;
    @Value(value="${mosip.kernel.ida.app.id}")
    private String idaAppId;
    @Value(value="${mosip.kernel.ida.client.id}")
    private String idaClientId;
    @Value(value="${mosip.kernel.ida.secret.key}")
    private String idaSecretKey;

    public String getInternalTokenGenerationService() throws Exception {
        ClientSecret clientSecret = new ClientSecret();
        clientSecret.setAppId(this.authAppId);
        clientSecret.setClientId(this.clientId);
        clientSecret.setSecretKey(this.secretKey);
        AuthNResponseDto authNResponseDto = this.authService.authenticateWithSecretKey(clientSecret);
        return authNResponseDto.getToken();
    }

    public String getUINBasedToken() throws Exception {
        ClientSecret clientSecret = new ClientSecret();
        clientSecret.setAppId(this.idaAppId);
        clientSecret.setClientId(this.idaClientId);
        clientSecret.setSecretKey(this.idaSecretKey);
        AuthNResponseDto authNResponseDto = this.authService.authenticateWithSecretKey(clientSecret);
        return authNResponseDto.getToken();
    }
}

