/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerServiceException;
import io.mosip.kernel.auth.defaultimpl.exception.LoginException;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
public class AuthManagerExceptionHandler {
    @Autowired
    private ObjectMapper objectMapper;

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> methodArgumentNotValidException(HttpServletRequest httpServletRequest, MethodArgumentNotValidException e) throws IOException {
        ResponseWrapper errorResponse = this.setErrors(httpServletRequest);
        List fieldErrors = e.getBindingResult().getFieldErrors();
        fieldErrors.forEach(x -> {
            ServiceError error = new ServiceError(AuthErrorCode.INVALID_REQUEST.getErrorCode(), x.getField() + " " + x.getDefaultMessage());
            errorResponse.getErrors().add(error);
        });
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onHttpMessageNotReadable(HttpServletRequest httpServletRequest, HttpMessageNotReadableException e) throws IOException {
        ResponseWrapper errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(AuthErrorCode.INVALID_REQUEST.getErrorCode(), e.getMessage());
        errorResponse.getErrors().add(error);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.OK);
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }

    @ExceptionHandler(value={AuthManagerException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> customErrorMessage(HttpServletRequest request, AuthManagerException exception) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(request);
        ServiceError error = new ServiceError(exception.getErrorCode(), exception.getMessage());
        responseWrapper.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)exception);
        return new ResponseEntity((Object)responseWrapper, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={AuthManagerServiceException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> customErrorMessageList(HttpServletRequest request, AuthManagerServiceException e) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(request);
        responseWrapper.getErrors().addAll(e.getList());
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity((Object)responseWrapper, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={LoginException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> loginException(HttpServletRequest request, LoginException exception) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(request);
        ServiceError error = new ServiceError(exception.getErrorCode(), exception.getMessage());
        responseWrapper.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)exception);
        return new ResponseEntity((Object)responseWrapper, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> defaultErrorHandler(HttpServletRequest request, Exception e) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(request);
        ServiceError error = new ServiceError("500", e.getMessage());
        responseWrapper.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity((Object)responseWrapper, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

