/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class MosipEnvironment
implements EnvironmentAware {
    @Autowired
    private Environment environment;
    private final String jwtSecret = "auth.jwt.secret";
    private final String tokenBase = "auth.jwt.base";
    private final String tokenExpiry = "auth.jwt.expiry";
    private final String refreshTokenExpiry = "auth.jwt.refresh.expiry";
    private final String authTokenHeader = "auth.token.header";
    private final String authRefreshTokenHeader = "auth.refreshtoken.header";
    private final String ldapSvcUrl = "ldap.svc.url";
    private final String ldapAuthenticate = "ldap.api.authenticate";
    private final String ldapVerifyOtpUser = "ldap.api.otp.user.verify";
    private final String generateOtpApi = "otp.manager.api.generate";
    private final String verifyOtpUserApi = "otp.manager.api.verify";
    private final String otpSenderEmailApi = "otp.sender.api.email.send";
    private final String otpSenderSmsApi = "otp.sender.api.sms.send";
    private final String masterDataTemplateApi = "masterdata.api.template";
    private final String masterDataOtpTemplate = "masterdata.api.template.otp";
    private final String propurl = ".datastore.ipaddress";
    private final String propport = ".datastore.port";
    private final String propusername = ".datastore.username";
    private final String proppassword = ".datastore.password";
    private final String propschema = ".datastore.schema";
    private final String propdriver = ".datastore.driverClassName";
    private final String datastores = "datastores";
    private String rolesSearchBase = "ldap.roles.base";
    private String rolesSearchPrefix = "ldap.roles.search.prefix";
    private String rolesSearchSuffix = "ldap.roles.search.suffix";
    private String ldapRolesClass = "ldap.roles.class";
    private String otpPrimaryLanguage = "auth.primary.language";
    private String otpSecondaryLanguage = "auth.secondary.language";
    private String uinGetDetailsUrl = "idrepo.api.getuindetails";
    private String authSlidingWindowExp = "auth.token.sliding.window.exp";
    private String authPrefix = "mosip.kernel.auth.";
    private String authAppId = ".app.id";
    private String authAppUserId = ".client.id";
    private String authSecretKey = ".secret.key";

    public String getUinGetDetailsUrl() {
        return this.environment.getProperty(this.uinGetDetailsUrl);
    }

    public String getAppUserId(String appId) {
        return this.environment.getProperty(this.authPrefix + appId + this.authAppUserId);
    }

    public String getAppId(String appId) {
        return this.environment.getProperty(this.authPrefix + appId + this.authAppId);
    }

    public String getSecretKey(String appId) {
        return this.environment.getProperty(this.authPrefix + appId + this.authSecretKey);
    }

    public Integer getAuthSlidingWindowExp() {
        return Integer.valueOf(this.environment.getProperty(this.authSlidingWindowExp));
    }

    public String getPrimaryLanguage() {
        return this.environment.getProperty(this.otpPrimaryLanguage);
    }

    public String getSecondaryLanguage() {
        return this.environment.getProperty(this.otpSecondaryLanguage);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String getAuthTokenHeader() {
        return this.environment.getProperty("auth.token.header");
    }

    public String getRefreshTokenHeader() {
        return this.environment.getProperty("auth.refreshtoken.header");
    }

    public String getDriverName(String datasource) {
        return this.environment.getProperty(datasource + ".datastore.driverClassName");
    }

    public String getUrl(String dataStore) {
        return this.environment.getProperty(dataStore + ".datastore.ipaddress");
    }

    public String getPort(String dataStore) {
        return this.environment.getProperty(dataStore + ".datastore.port");
    }

    public String getDataStore(String app) {
        return this.environment.getProperty(app);
    }

    public String getUserName(String dataStore) {
        return this.environment.getProperty(dataStore + ".datastore.username");
    }

    public String getPassword(String dataStore) {
        return this.environment.getProperty(dataStore + ".datastore.password");
    }

    public String getSchemas(String schema) {
        return this.environment.getProperty(schema + ".datastore.schema");
    }

    public String getJwtSecret() {
        return this.environment.getProperty("auth.jwt.secret");
    }

    public String getTokenBase() {
        return this.environment.getProperty("auth.jwt.base");
    }

    public Integer getTokenExpiry() {
        return Integer.parseInt(this.environment.getProperty("auth.jwt.expiry"));
    }

    public Long getRefreshTokenExpiry() {
        return Long.valueOf(this.environment.getProperty("auth.jwt.refresh.expiry"));
    }

    public String getLdapSvcUrl() {
        return this.environment.getProperty("ldap.svc.url");
    }

    public String getLdapAuthenticate() {
        return this.environment.getProperty("ldap.api.authenticate");
    }

    public String getLdapVerifyOtpUser() {
        return this.environment.getProperty("ldap.api.otp.user.verify");
    }

    public String getGenerateOtpApi() {
        return this.environment.getProperty("otp.manager.api.generate");
    }

    public String getVerifyOtpUserApi() {
        return this.environment.getProperty("otp.manager.api.verify");
    }

    public String getOtpSenderEmailApi() {
        return this.environment.getProperty("otp.sender.api.email.send");
    }

    public String getOtpSenderSmsApi() {
        return this.environment.getProperty("otp.sender.api.sms.send");
    }

    public String getMasterDataTemplateApi() {
        return this.environment.getProperty("masterdata.api.template");
    }

    public String getMasterDataOtpTemplate() {
        return this.environment.getProperty("masterdata.api.template.otp");
    }

    public String getDataStores() {
        return this.environment.getProperty("datastores");
    }

    public String getLdapRolesClass() {
        return this.environment.getProperty(this.ldapRolesClass);
    }

    public String getRolesSearchBase() {
        return this.environment.getProperty(this.rolesSearchBase);
    }

    public String getRolesSearchPrefix() {
        return this.environment.getProperty(this.rolesSearchPrefix);
    }

    public String getRolesSearchSuffix() {
        return this.environment.getProperty(this.rolesSearchSuffix);
    }
}

