/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.mosip.kernel.auth.config.CorsFilter;
import io.mosip.kernel.auth.config.ReqResFilter;
import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@Configuration
public class Config {
    @Bean(name={"CorsFilter"})
    public FilterRegistrationBean<Filter> registerCORSFilterBean() {
        FilterRegistrationBean corsBean = new FilterRegistrationBean();
        corsBean.setFilter(this.registerCORSFilter());
        corsBean.setOrder(0);
        return corsBean;
    }

    @Bean(name={"ReqResponseFilter"})
    public FilterRegistrationBean<Filter> registerReqResFilterBean() {
        FilterRegistrationBean reqResFilter = new FilterRegistrationBean();
        reqResFilter.setFilter(this.getReqResFilter());
        reqResFilter.setOrder(1);
        return reqResFilter;
    }

    @Bean
    public Filter registerCORSFilter() {
        return new CorsFilter();
    }

    @Bean
    public Filter getReqResFilter() {
        return new ReqResFilter();
    }

    @Bean
    public CommonsRequestLoggingFilter logFilter() {
        CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
        filter.setIncludeQueryString(true);
        filter.setIncludePayload(true);
        filter.setMaxPayloadLength(100000);
        filter.setIncludeHeaders(true);
        filter.setAfterMessagePrefix("REQUEST DATA : ");
        return filter;
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new AfterburnerModule())).build();
        objectMapper.registerModule((Module)new JavaTimeModule());
        return objectMapper;
    }
}

