/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureException;
import io.mosip.kernel.auth.defaultimpl.config.MosipEnvironment;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.dto.MosipUser;
import io.mosip.kernel.auth.defaultimpl.dto.MosipUserToken;
import io.mosip.kernel.auth.defaultimpl.dto.RealmAccessDto;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.service.TokenService;
import io.mosip.kernel.core.authmanager.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.model.MosipUserTokenDto;
import io.mosip.kernel.core.util.DateUtils;
import java.time.ZoneOffset;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.stereotype.Component;

@Component
public class TokenValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenValidator.class);
    @Autowired
    MosipEnvironment mosipEnvironment;
    @Autowired
    TokenService customTokenServices;

    private Boolean validateOtpDetails(Claims claims) {
        if (claims.get((Object)"isOtpRequired") == null) {
            return true;
        }
        Boolean isOtpVerified = (Boolean)claims.get((Object)"isOtpVerified");
        Boolean isOtpRequired = (Boolean)claims.get((Object)"isOtpRequired");
        if (isOtpRequired.booleanValue() && !isOtpVerified.booleanValue()) {
            return false;
        }
        return true;
    }

    private MosipUser buildMosipUser(Claims claims) {
        return new MosipUser(claims.getSubject(), (String)claims.get((Object)"mobile"), (String)claims.get((Object)"mail"), (String)claims.get((Object)"role"));
    }

    public MosipUserDto getAdminClaims(String token) {
        DecodedJWT decodedJWT = JWT.decode((String)token);
        Claim realmAccess = decodedJWT.getClaim("realm_access");
        RealmAccessDto access = (RealmAccessDto)realmAccess.as(RealmAccessDto.class);
        String[] roles = access.getRoles();
        StringBuilder builder = new StringBuilder();
        LOGGER.debug("invoked getAdminClaims");
        for (String r : roles) {
            builder.append(r);
            builder.append(";");
            LOGGER.debug("Roles " + r);
        }
        MosipUserDto dto = new MosipUserDto();
        dto.setUserId(decodedJWT.getClaim("preferred_username").asString());
        dto.setMail(decodedJWT.getClaim("email").asString());
        dto.setMobile(decodedJWT.getClaim("contactno").asString());
        dto.setName(decodedJWT.getClaim("preferred_username").asString());
        dto.setRId(decodedJWT.getClaim("rid").asString());
        dto.setRole(builder.toString());
        return dto;
    }

    public boolean isExpired(String token) {
        DecodedJWT decodedJWT = JWT.decode((String)token);
        long expiryEpochTime = decodedJWT.getClaim("exp").asLong();
        long currentEpoch = DateUtils.getUTCCurrentDateTime().toEpochSecond(ZoneOffset.UTC);
        LOGGER.debug("invoked isExpired token " + expiryEpochTime + " currentEpoch " + currentEpoch);
        return currentEpoch > expiryEpochTime;
    }

    public String getKeycloakRealm(String token) {
        String issuer = this.getissuer(token);
        return issuer.substring(issuer.lastIndexOf("/") + 1);
    }

    public String getissuer(String token) {
        DecodedJWT decodedJWT = JWT.decode((String)token);
        return decodedJWT.getClaim("iss").asString();
    }

    private Claims getClaims(String token) throws Exception {
        String token_base = this.mosipEnvironment.getTokenBase();
        String secret = this.mosipEnvironment.getJwtSecret();
        Claims claims = null;
        if (token == null || !token.startsWith(token_base)) {
            throw new NonceExpiredException("Invalid Token");
        }
        try {
            claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token.substring(token_base.length())).getBody();
        }
        catch (SignatureException e) {
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage());
        }
        catch (JwtException e) {
            if (e instanceof ExpiredJwtException) {
                LOGGER.error("invoked validate token expired message " + e.getMessage() + " Token " + token);
                throw new AuthManagerException(AuthErrorCode.TOKEN_EXPIRED.getErrorCode(), AuthErrorCode.TOKEN_EXPIRED.getErrorMessage());
            }
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage());
        }
        return claims;
    }

    public MosipUserToken validateForOtpVerification(String token) throws Exception {
        Claims claims = this.getClaims(token);
        Boolean isOtpRequired = (Boolean)claims.get((Object)"isOtpRequired");
        if (isOtpRequired.booleanValue()) {
            MosipUser mosipUser = this.buildMosipUser(claims);
            LOGGER.info("Otp required " + mosipUser.getUserName());
            return new MosipUserToken(mosipUser, token);
        }
        throw new AuthManagerException(AuthErrorCode.INVALID_TOKEN.getErrorCode(), AuthErrorCode.INVALID_TOKEN.getErrorMessage());
    }

    public MosipUserToken basicValidate(String token) throws Exception {
        Claims claims = this.getClaims(token);
        Boolean isOtpValid = this.validateOtpDetails(claims);
        if (isOtpValid.booleanValue()) {
            MosipUser mosipUser = this.buildMosipUser(claims);
            return new MosipUserToken(mosipUser, token);
        }
        throw new AuthManagerException(AuthErrorCode.INVALID_TOKEN.getErrorCode(), AuthErrorCode.INVALID_TOKEN.getErrorMessage());
    }

    public MosipUserTokenDto validateToken(String token) throws Exception {
        Claims claims = this.getClaims(token);
        MosipUserDto mosipUserDto = this.buildDto(claims);
        return new MosipUserTokenDto(mosipUserDto, token, null, 0L, null, null, 0L);
    }

    private MosipUserDto buildDto(Claims claims) {
        MosipUserDto mosipUserDto = new MosipUserDto();
        mosipUserDto.setUserId(claims.getSubject());
        mosipUserDto.setName((String)claims.get((Object)"name"));
        mosipUserDto.setRole((String)claims.get((Object)"role"));
        mosipUserDto.setMail((String)claims.get((Object)"mail"));
        mosipUserDto.setMobile((String)claims.get((Object)"mobile"));
        mosipUserDto.setRId((String)claims.get((Object)"rId"));
        return mosipUserDto;
    }

    public MosipUserTokenDto validateOTP(String otp) throws Exception {
        Claims claims = this.getClaims(otp);
        Boolean isOtpRequired = (Boolean)claims.get((Object)"isOtpRequired");
        if (isOtpRequired.booleanValue()) {
            MosipUserDto mosipUserDto = this.buildDto(claims);
            return new MosipUserTokenDto(mosipUserDto, otp, null, 0L, null, null, 0L);
        }
        throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), AuthErrorCode.UNAUTHORIZED.getErrorMessage());
    }

    public boolean validateExpiry(String token) throws Exception {
        Claims claims = this.getClaims(token);
        if (claims != null) {
            Integer expTime = (Integer)claims.get((Object)"exp");
            long currentTime = new Date().getTime();
            long exp = expTime.longValue() * 1000L;
            if (expTime != 0 && currentTime < exp) {
                LOGGER.debug("Token Valid " + claims.getId());
                return true;
            }
            LOGGER.debug("Token Invalid " + claims.getId());
        }
        return false;
    }
}

