/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.auth.defaultimpl.config.MosipEnvironment;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.dto.AccessTokenResponse;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpEmailSendResponseDto;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpGenerateRequest;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpGenerateResponseDto;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpSmsSendRequestDto;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpTemplateDto;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpTemplateResponseDto;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpValidatorResponseDto;
import io.mosip.kernel.auth.defaultimpl.dto.otp.SmsResponseDto;
import io.mosip.kernel.auth.defaultimpl.dto.otp.email.OTPEmailTemplate;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerServiceException;
import io.mosip.kernel.auth.defaultimpl.service.OTPGenerateService;
import io.mosip.kernel.auth.defaultimpl.service.OTPService;
import io.mosip.kernel.auth.defaultimpl.service.TokenGenerationService;
import io.mosip.kernel.auth.defaultimpl.util.OtpValidator;
import io.mosip.kernel.auth.defaultimpl.util.ProxyTokenGenerator;
import io.mosip.kernel.auth.defaultimpl.util.TemplateUtil;
import io.mosip.kernel.core.authmanager.exception.AuthNException;
import io.mosip.kernel.core.authmanager.exception.AuthZException;
import io.mosip.kernel.core.authmanager.model.AuthNResponseDto;
import io.mosip.kernel.core.authmanager.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.model.MosipUserTokenDto;
import io.mosip.kernel.core.authmanager.model.OtpUser;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Profile(value={"local"})
@Service
public class ProxyOTPServiceImpl
implements OTPService {
    @Qualifier(value="authRestTemplate")
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MosipEnvironment mosipEnvironment;
    @Autowired
    OTPGenerateService oTPGenerateService;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private TokenGenerationService tokenService;
    @Autowired
    private TemplateUtil templateUtil;
    @Autowired
    private OtpValidator authOtpValidator;
    @Value(value="${mosip.iam.open-id-url}")
    private String keycloakOpenIdUrl;
    @Value(value="${mosip.iam.default.realm-id}")
    private String realmId;
    @Value(value="${mosip.kernel.auth.client.id}")
    private String authClientID;
    @Value(value="${mosip.kernel.prereg.client.id}")
    private String preregClientId;
    @Value(value="${mosip.kernel.prereg.secret.key}")
    private String preregSecretKey;
    @Value(value="${mosip.kernel.auth.secret.key}")
    private String authSecret;
    @Value(value="${mosip.kernel.ida.client.id}")
    private String idaClientID;
    @Value(value="${mosip.kernel.ida.secret.key}")
    private String idaSecret;
    @Value(value="${mosip.admin.clientid}")
    private String mosipAdminClientID;
    @Value(value="${mosip.admin.clientsecret}")
    private String mosipAdminSecret;
    @Value(value="${mosip.iam.pre-reg_user_password}")
    private String preRegUserPassword;
    @Value(value="${mosip.kernel.prereg.realm-id}")
    private String preregRealmId;
    @Value(value="${spring.profiles.active}")
    String activeProfile;
    @Value(value="${auth.local.exp:1000000}")
    long localExp;
    @Value(value="${mosip.kernel.auth.proxy-otp}")
    private boolean proxyOtp;
    @Autowired
    private ProxyTokenGenerator proxyTokenGenerator;

    @Deprecated
    public AuthNResponseDto sendOTP(MosipUserDto mosipUserDto, List<String> otpChannel, String appId) {
        AuthNResponseDto authNResponseDto = null;
        OtpEmailSendResponseDto otpEmailSendResponseDto = null;
        SmsResponseDto otpSmsSendResponseDto = null;
        String emailMessage = null;
        String mobileMessage = null;
        String token = null;
        try {
            AccessTokenResponse accessTokenResponse = this.getAuthAccessToken(this.authClientID, this.authSecret, this.realmId);
            if (accessTokenResponse == null) {
                throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), "response is null");
            }
            token = accessTokenResponse.getAccess_token();
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
            if (ex.getRawStatusCode() == 401) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthNException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage(), ex);
            }
            if (ex.getRawStatusCode() == 403) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthZException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage(), ex);
            }
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
        }
        catch (Exception e) {
            throw new AuthManagerException(AuthErrorCode.SERVER_ERROR.getErrorCode(), e.getMessage(), (Throwable)e);
        }
        OtpGenerateResponseDto otpGenerateResponseDto = this.oTPGenerateService.generateOTP(mosipUserDto, token);
        if (otpGenerateResponseDto != null && otpGenerateResponseDto.getStatus().equals("USER_BLOCKED")) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus("failure");
            authNResponseDto.setMessage(otpGenerateResponseDto.getStatus());
            return authNResponseDto;
        }
        if (otpGenerateResponseDto != null) {
            Iterator<String> iterator = otpChannel.iterator();
            while (iterator.hasNext()) {
                String channel;
                switch (channel = iterator.next()) {
                    case "email": {
                        emailMessage = this.getOtpEmailMessage(otpGenerateResponseDto, appId, token);
                        otpEmailSendResponseDto = this.sendOtpByEmail(emailMessage, mosipUserDto.getMail(), token);
                        break;
                    }
                    case "phone": {
                        mobileMessage = this.getOtpSmsMessage(otpGenerateResponseDto, appId, token);
                        otpSmsSendResponseDto = this.sendOtpBySms(mobileMessage, mosipUserDto.getMobile(), token);
                    }
                }
            }
        }
        if (otpEmailSendResponseDto != null) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus(otpEmailSendResponseDto.getStatus());
            authNResponseDto.setMessage(otpEmailSendResponseDto.getMessage());
        }
        if (otpSmsSendResponseDto != null) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus(otpSmsSendResponseDto.getStatus());
            authNResponseDto.setMessage(otpSmsSendResponseDto.getMessage());
        }
        return authNResponseDto;
    }

    private String getOtpEmailMessage(OtpGenerateResponseDto otpGenerateResponseDto, String appId, String token) {
        String template = null;
        OtpTemplateResponseDto otpTemplateResponseDto = null;
        String url = this.mosipEnvironment.getMasterDataTemplateApi() + "/" + this.mosipEnvironment.getPrimaryLanguage() + this.mosipEnvironment.getMasterDataOtpTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cookie", "Authorization=" + token);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
            String responseBody = (String)response.getBody();
            Object validationErrorsList = null;
            validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException((List)validationErrorsList);
            }
            try {
                ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                otpTemplateResponseDto = (OtpTemplateResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), OtpTemplateResponseDto.class);
            }
            catch (Exception e) {
                throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
            }
        }
        ArrayList otpTemplateList = null;
        if (otpTemplateResponseDto == null) {
            throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), "response is null");
        }
        otpTemplateList = otpTemplateResponseDto.getTemplates();
        for (OtpTemplateDto otpTemplateDto : otpTemplateList) {
            if (!otpTemplateDto.getId().toLowerCase().equals(appId.toLowerCase())) continue;
            template = otpTemplateDto.getFileText();
        }
        String otp = otpGenerateResponseDto.getOtp();
        if (template != null) {
            template = template.replace("$otp", otp);
        }
        return template;
    }

    private String getOtpSmsMessage(OtpGenerateResponseDto otpGenerateResponseDto, String appId, String token) {
        try {
            String url = this.mosipEnvironment.getMasterDataTemplateApi() + "/" + this.mosipEnvironment.getPrimaryLanguage() + this.mosipEnvironment.getMasterDataOtpTemplate();
            OtpTemplateResponseDto otpTemplateResponseDto = null;
            HttpHeaders headers = new HttpHeaders();
            headers.set("Cookie", "Authorization=" + token);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                String responseBody = (String)response.getBody();
                List validationErrorsList = null;
                validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthManagerServiceException(validationErrorsList);
                }
                try {
                    ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                    otpTemplateResponseDto = (OtpTemplateResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), OtpTemplateResponseDto.class);
                }
                catch (Exception e) {
                    throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
                }
            }
            String template = null;
            ArrayList otpTemplateList = null;
            if (otpTemplateResponseDto == null) {
                throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), "response is null");
            }
            otpTemplateList = otpTemplateResponseDto.getTemplates();
            for (OtpTemplateDto otpTemplateDto : otpTemplateList) {
                if (!otpTemplateDto.getId().toLowerCase().equals(appId.toLowerCase())) continue;
                template = otpTemplateDto.getFileText();
            }
            String otp = otpGenerateResponseDto.getOtp();
            if (template != null) {
                template = template.replace("$otp", otp);
            }
            return template;
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            String message = e.getResponseBodyAsString();
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), message);
        }
    }

    private OtpEmailSendResponseDto sendOtpByEmail(String message, String email, String token) {
        ResponseEntity response = null;
        String url = this.mosipEnvironment.getOtpSenderEmailApi();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON_UTF8));
        OtpEmailSendResponseDto otpEmailSendResponseDto = null;
        headers.set("Cookie", "Authorization=" + token);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"mailTo", (Object)email);
        map.add((Object)"mailSubject", (Object)"MOSIP Notification");
        map.add((Object)"mailContent", (Object)message);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            try {
                response = this.restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
            }
            catch (HttpClientErrorException | HttpServerErrorException e) {
                throw new AuthManagerException(AuthErrorCode.REST_EXCEPTION.getErrorCode(), e.getResponseBodyAsString());
            }
            catch (RestClientException e) {
                throw new AuthManagerException(AuthErrorCode.REST_EXCEPTION.getErrorCode(), e.getMessage());
            }
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            String string = e.getResponseBodyAsString();
        }
        if (response != null && response.getStatusCode().equals((Object)HttpStatus.OK)) {
            String responseBody = (String)response.getBody();
            List validationErrorsList = null;
            validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            try {
                ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                otpEmailSendResponseDto = (OtpEmailSendResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), OtpEmailSendResponseDto.class);
            }
            catch (Exception e) {
                throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
            }
        }
        return otpEmailSendResponseDto;
    }

    private SmsResponseDto sendOtpBySms(String message, String mobile, String token) {
        try {
            List validationErrorsList = null;
            OtpSmsSendRequestDto otpSmsSendRequestDto = new OtpSmsSendRequestDto(mobile, message);
            SmsResponseDto otpSmsSendResponseDto = null;
            String url = this.mosipEnvironment.getOtpSenderSmsApi();
            RequestWrapper reqWrapper = new RequestWrapper();
            reqWrapper.setRequesttime(LocalDateTime.now());
            reqWrapper.setRequest((Object)otpSmsSendRequestDto);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Cookie", "Authorization=" + token);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)reqWrapper, (MultiValueMap)headers), String.class, new Object[0]);
            validationErrorsList = ExceptionUtils.getServiceErrorList((String)((String)response.getBody()));
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            try {
                ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                otpSmsSendResponseDto = (SmsResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), SmsResponseDto.class);
            }
            catch (Exception e) {
                throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage());
            }
            return otpSmsSendResponseDto;
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            String errmessage = e.getResponseBodyAsString();
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), errmessage);
        }
    }

    public MosipUserTokenDto validateOTP(MosipUserDto mosipUser, String otp, String appId) {
        String key = new OtpGenerateRequest(mosipUser).getKey();
        MosipUserTokenDto mosipUserDtoToken = null;
        ResponseEntity response = null;
        String url = this.mosipEnvironment.getVerifyOtpUserApi();
        String token = null;
        AccessTokenResponse accessTokenResponse = null;
        AccessTokenResponse responseAccessTokenResponse = null;
        String realm = appId.equalsIgnoreCase("preregistration") ? appId : this.realmId;
        try {
            accessTokenResponse = new AccessTokenResponse();
            long exp = System.currentTimeMillis() + this.localExp;
            token = this.proxyTokenGenerator.getProxyToken("AUTH", exp);
            accessTokenResponse.setAccess_token(token);
            accessTokenResponse.setExpires_in("" + exp);
        }
        catch (Exception e) {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("key", new Object[]{key}).queryParam("otp", new Object[]{otp});
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cookie", "Authorization=" + token);
        response = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
            String responseBody = (String)response.getBody();
            List validationErrorsList = null;
            validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            responseAccessTokenResponse = new AccessTokenResponse();
            long exp = System.currentTimeMillis() + this.localExp;
            responseAccessTokenResponse = new AccessTokenResponse();
            responseAccessTokenResponse.setAccess_token(this.proxyTokenGenerator.getProxyToken(mosipUser.getUserId(), exp));
            responseAccessTokenResponse.setRefresh_token(this.proxyTokenGenerator.getProxyToken(mosipUser.getUserId(), exp));
            responseAccessTokenResponse.setExpires_in("" + exp);
            OtpValidatorResponseDto otpResponse = null;
            try {
                ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                otpResponse = (OtpValidatorResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), OtpValidatorResponseDto.class);
            }
            catch (Exception e) {
                throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
            }
            if (otpResponse.getStatus() != null && otpResponse.getStatus().equals("success")) {
                String expTime = accessTokenResponse.getExpires_in();
                mosipUserDtoToken = new MosipUserTokenDto(mosipUser, responseAccessTokenResponse.getAccess_token(), responseAccessTokenResponse.getRefresh_token(), Long.parseLong(expTime), null, null, Long.parseLong(expTime));
                mosipUserDtoToken.setMessage(otpResponse.getMessage());
                mosipUserDtoToken.setStatus(otpResponse.getStatus());
            } else {
                mosipUserDtoToken = new MosipUserTokenDto();
                mosipUserDtoToken.setMessage(otpResponse.getMessage());
                mosipUserDtoToken.setStatus(otpResponse.getStatus());
            }
        }
        return mosipUserDtoToken;
    }

    public AuthNResponseDto sendOTPForUin(MosipUserDto mosipUser, OtpUser otpUser, String appId) {
        AuthNResponseDto authNResponseDto = null;
        OtpEmailSendResponseDto otpEmailSendResponseDto = null;
        SmsResponseDto otpSmsSendResponseDto = null;
        String mobileMessage = null;
        OTPEmailTemplate emailTemplate = null;
        AccessTokenResponse accessTokenResponse = null;
        this.authOtpValidator.validateOTPUser(otpUser);
        try {
            accessTokenResponse = this.getAuthAccessToken(this.idaClientID, this.idaSecret, this.realmId);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
            if (ex.getRawStatusCode() == 401) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthNException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), AuthErrorCode.CLIENT_ERROR.getErrorMessage(), ex);
            }
            if (ex.getRawStatusCode() == 403) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthZException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
            }
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
        }
        OtpGenerateResponseDto otpGenerateResponseDto = null;
        if (accessTokenResponse != null) {
            if (!this.proxyOtp) {
                otpGenerateResponseDto = this.oTPGenerateService.generateOTP(mosipUser, accessTokenResponse.getAccess_token());
            } else {
                otpGenerateResponseDto = new OtpGenerateResponseDto();
                otpGenerateResponseDto.setOtp("123445");
                otpGenerateResponseDto.setStatus("success");
            }
            if (otpGenerateResponseDto != null && otpGenerateResponseDto.getStatus().equals("USER_BLOCKED")) {
                authNResponseDto = new AuthNResponseDto();
                authNResponseDto.setStatus("failure");
                authNResponseDto.setMessage(otpGenerateResponseDto.getStatus());
                return authNResponseDto;
            }
            if (otpGenerateResponseDto != null) {
                for (String channel : otpUser.getOtpChannel()) {
                    switch (channel.toLowerCase()) {
                        case "email": {
                            if (!this.proxyOtp) {
                                emailTemplate = this.templateUtil.getEmailTemplate(otpGenerateResponseDto.getOtp(), otpUser, accessTokenResponse.getAccess_token());
                                otpEmailSendResponseDto = this.sendOtpByEmail(emailTemplate, mosipUser.getUserId(), accessTokenResponse.getAccess_token());
                                break;
                            }
                            otpEmailSendResponseDto = new OtpEmailSendResponseDto();
                            otpEmailSendResponseDto.setMessage("Email Request submitted");
                            otpEmailSendResponseDto.setStatus("success");
                            break;
                        }
                        case "phone": {
                            if (!this.proxyOtp) {
                                mobileMessage = this.templateUtil.getOtpSmsMessage(otpGenerateResponseDto.getOtp(), otpUser, accessTokenResponse.getAccess_token());
                                otpSmsSendResponseDto = this.sendOtpBySms(mobileMessage, mosipUser.getUserId(), accessTokenResponse.getAccess_token());
                                break;
                            }
                            otpEmailSendResponseDto = new OtpEmailSendResponseDto();
                            otpEmailSendResponseDto.setMessage("Sms Request Sent");
                            otpEmailSendResponseDto.setStatus("success");
                        }
                    }
                }
            }
        } else {
            throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), "response is null");
        }
        if (otpEmailSendResponseDto != null && otpSmsSendResponseDto != null) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus("success");
            authNResponseDto.setMessage("OTP message sent across all the channels");
        } else if (otpEmailSendResponseDto != null) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus(otpEmailSendResponseDto.getStatus());
            authNResponseDto.setMessage(otpEmailSendResponseDto.getMessage());
        } else if (otpSmsSendResponseDto != null) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus(otpSmsSendResponseDto.getStatus());
            authNResponseDto.setMessage(otpSmsSendResponseDto.getMessage());
        }
        return authNResponseDto;
    }

    public AuthNResponseDto sendOTP(MosipUserDto mosipUser, OtpUser otpUser, String appId) throws Exception {
        AuthNResponseDto authNResponseDto = null;
        OtpEmailSendResponseDto otpEmailSendResponseDto = null;
        SmsResponseDto otpSmsSendResponseDto = null;
        String mobileMessage = null;
        OTPEmailTemplate emailTemplate = null;
        AccessTokenResponse accessTokenResponse = null;
        this.authOtpValidator.validateOTPUser(otpUser);
        try {
            accessTokenResponse = new AccessTokenResponse();
            long exp = System.currentTimeMillis() + this.localExp;
            accessTokenResponse.setAccess_token(this.proxyTokenGenerator.getProxyToken("AUTH", exp));
            accessTokenResponse.setExpires_in("" + exp);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
            if (ex.getRawStatusCode() == 401) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthNException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), AuthErrorCode.CLIENT_ERROR.getErrorMessage(), ex);
            }
            if (ex.getRawStatusCode() == 403) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthZException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
            }
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
        }
        OtpGenerateResponseDto otpGenerateResponseDto = null;
        if (!this.proxyOtp) {
            otpGenerateResponseDto = this.oTPGenerateService.generateOTP(mosipUser, accessTokenResponse.getAccess_token());
        } else {
            otpGenerateResponseDto = new OtpGenerateResponseDto();
            otpGenerateResponseDto.setOtp("123445");
            otpGenerateResponseDto.setStatus("success");
        }
        if (otpGenerateResponseDto != null && otpGenerateResponseDto.getStatus().equals("USER_BLOCKED")) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus("failure");
            authNResponseDto.setMessage(otpGenerateResponseDto.getStatus());
            return authNResponseDto;
        }
        if (otpGenerateResponseDto != null) {
            for (String channel : otpUser.getOtpChannel()) {
                switch (channel.toLowerCase()) {
                    case "email": {
                        if (!this.proxyOtp) {
                            emailTemplate = this.templateUtil.getEmailTemplate(otpGenerateResponseDto.getOtp(), otpUser, accessTokenResponse.getAccess_token());
                            otpEmailSendResponseDto = this.sendOtpByEmail(emailTemplate, mosipUser.getUserId(), accessTokenResponse.getAccess_token());
                            break;
                        }
                        otpEmailSendResponseDto = new OtpEmailSendResponseDto();
                        otpEmailSendResponseDto.setMessage("Email Request submitted");
                        otpEmailSendResponseDto.setStatus("success");
                        break;
                    }
                    case "phone": {
                        if (!this.proxyOtp) {
                            mobileMessage = this.templateUtil.getOtpSmsMessage(otpGenerateResponseDto.getOtp(), otpUser, accessTokenResponse.getAccess_token());
                            otpSmsSendResponseDto = this.sendOtpBySms(mobileMessage, mosipUser.getUserId(), accessTokenResponse.getAccess_token());
                            break;
                        }
                        otpEmailSendResponseDto = new OtpEmailSendResponseDto();
                        otpEmailSendResponseDto.setMessage("Sms Request Sent");
                        otpEmailSendResponseDto.setStatus("success");
                    }
                }
            }
        }
        if (otpEmailSendResponseDto != null && otpSmsSendResponseDto != null) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus("success");
            authNResponseDto.setMessage("OTP message sent across all the channels");
        } else if (otpEmailSendResponseDto != null) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus(otpEmailSendResponseDto.getStatus());
            authNResponseDto.setMessage(otpEmailSendResponseDto.getMessage());
        } else if (otpSmsSendResponseDto != null) {
            authNResponseDto = new AuthNResponseDto();
            authNResponseDto.setStatus(otpSmsSendResponseDto.getStatus());
            authNResponseDto.setMessage(otpSmsSendResponseDto.getMessage());
        }
        return authNResponseDto;
    }

    private OtpEmailSendResponseDto sendOtpByEmail(OTPEmailTemplate emailTemplate, String email, String token) {
        OtpEmailSendResponseDto otpEmailSendResponseDto;
        block10: {
            ResponseEntity response = null;
            String url = this.mosipEnvironment.getOtpSenderEmailApi();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON_UTF8));
            otpEmailSendResponseDto = null;
            headers.set("Cookie", "Authorization=" + token);
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"mailTo", (Object)email);
            map.add((Object)"mailSubject", (Object)emailTemplate.getEmailSubject());
            map.add((Object)"mailContent", (Object)emailTemplate.getEmailContent());
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            try {
                response = this.restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
                if (!response.getStatusCode().equals((Object)HttpStatus.OK)) break block10;
                String responseBody = (String)response.getBody();
                List validationErrorsList = null;
                validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthManagerServiceException(validationErrorsList);
                }
                try {
                    ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                    otpEmailSendResponseDto = (OtpEmailSendResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), OtpEmailSendResponseDto.class);
                }
                catch (Exception e) {
                    throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
                }
            }
            catch (HttpClientErrorException | HttpServerErrorException ex) {
                List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
                if (ex.getRawStatusCode() == 401) {
                    if (!validationErrorsList.isEmpty()) {
                        throw new AuthNException(validationErrorsList);
                    }
                    throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), AuthErrorCode.CLIENT_ERROR.getErrorMessage(), ex);
                }
                if (ex.getRawStatusCode() == 403) {
                    if (!validationErrorsList.isEmpty()) {
                        throw new AuthZException(validationErrorsList);
                    }
                    throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
                }
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthManagerServiceException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
            }
        }
        return otpEmailSendResponseDto;
    }

    private AccessTokenResponse getUserAccessToken(String username, String realm) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap tokenRequestBody = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realm);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        tokenRequestBody = this.getAdminValueMap(username, realm);
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        return (AccessTokenResponse)response.getBody();
    }

    private AccessTokenResponse getAuthAccessToken(String clientID, String clientSecret, String realmId) {
        HttpHeaders headers = new HttpHeaders();
        if (realmId.equalsIgnoreCase(this.preregRealmId)) {
            clientID = this.preregClientId;
            clientSecret = this.preregSecretKey;
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap tokenRequestBody = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        tokenRequestBody = this.getClientValueMap(clientID, clientSecret);
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        return (AccessTokenResponse)response.getBody();
    }

    private MultiValueMap<String, String> getAdminValueMap(String username, String realm) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        if (realm.equalsIgnoreCase(this.preregRealmId)) {
            map.add((Object)"client_id", (Object)this.preregClientId);
            map.add((Object)"client_secret", (Object)this.preregSecretKey);
        } else {
            map.add((Object)"client_id", (Object)this.mosipAdminClientID);
            map.add((Object)"client_secret", (Object)this.mosipAdminSecret);
        }
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"username", (Object)username);
        map.add((Object)"password", (Object)this.preRegUserPassword);
        return map;
    }

    private MultiValueMap<String, String> getClientValueMap(String clientID, String clientSecret) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"client_credentials");
        map.add((Object)"client_id", (Object)clientID);
        map.add((Object)"client_secret", (Object)clientSecret);
        return map;
    }
}

