/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.auth.defaultimpl.config.MosipEnvironment;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpGenerateRequest;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpGenerateRequestDto;
import io.mosip.kernel.auth.defaultimpl.dto.otp.OtpGenerateResponseDto;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerServiceException;
import io.mosip.kernel.auth.defaultimpl.service.OTPGenerateService;
import io.mosip.kernel.core.authmanager.exception.AuthNException;
import io.mosip.kernel.core.authmanager.exception.AuthZException;
import io.mosip.kernel.core.authmanager.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.model.OtpUser;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseWrapper;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class OTPGenerateServiceImpl
implements OTPGenerateService {
    @Qualifier(value="authRestTemplate")
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MosipEnvironment mosipEnvironment;
    @Autowired
    private ObjectMapper mapper;

    public OtpGenerateResponseDto generateOTP(MosipUserDto mosipUserDto, String token) {
        try {
            OtpGenerateResponseDto otpGenerateResponseDto;
            List validationErrorsList = null;
            OtpGenerateRequestDto otpGenerateRequestDto = new OtpGenerateRequestDto(mosipUserDto);
            String url = this.mosipEnvironment.getGenerateOtpApi();
            RequestWrapper reqWrapper = new RequestWrapper();
            reqWrapper.setRequesttime(LocalDateTime.now());
            reqWrapper.setRequest((Object)otpGenerateRequestDto);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Cookie", "Authorization=" + token);
            HttpEntity request = new HttpEntity((Object)reqWrapper, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            validationErrorsList = ExceptionUtils.getServiceErrorList((String)((String)response.getBody()));
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            try {
                ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                otpGenerateResponseDto = (OtpGenerateResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), OtpGenerateResponseDto.class);
            }
            catch (Exception e) {
                throw new AuthManagerException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage(), (Throwable)e);
            }
            return otpGenerateResponseDto;
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
            if (ex.getRawStatusCode() == 401) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthNException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage(), ex);
            }
            if (ex.getRawStatusCode() == 403) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthZException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage(), ex);
            }
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
        }
    }

    public OtpGenerateResponseDto generateOTPMultipleChannels(MosipUserDto mosipUserDto, OtpUser otpUser, String token) {
        try {
            OtpGenerateResponseDto otpGenerateResponseDto;
            List validationErrorsList = null;
            OtpGenerateRequest otpGenerateRequestDto = new OtpGenerateRequest(mosipUserDto);
            String url = this.mosipEnvironment.getGenerateOtpApi();
            RequestWrapper reqWrapper = new RequestWrapper();
            reqWrapper.setRequesttime(LocalDateTime.now());
            reqWrapper.setRequest((Object)otpGenerateRequestDto);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Cookie", "Authorization=" + token);
            HttpEntity request = new HttpEntity((Object)reqWrapper, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            validationErrorsList = ExceptionUtils.getServiceErrorList((String)((String)response.getBody()));
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            try {
                ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                otpGenerateResponseDto = (OtpGenerateResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), OtpGenerateResponseDto.class);
            }
            catch (Exception e) {
                throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
            }
            return otpGenerateResponseDto;
        }
        catch (HttpClientErrorException | HttpServerErrorException exp) {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), exp.getMessage(), exp);
        }
    }
}

