/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.service.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.auth.defaultimpl.config.MosipEnvironment;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.repository.UserStoreFactory;
import io.mosip.kernel.auth.defaultimpl.repository.impl.KeycloakImpl;
import io.mosip.kernel.auth.defaultimpl.service.OTPService;
import io.mosip.kernel.auth.defaultimpl.service.TokenService;
import io.mosip.kernel.auth.defaultimpl.service.UinService;
import io.mosip.kernel.auth.defaultimpl.util.ProxyTokenGenerator;
import io.mosip.kernel.auth.defaultimpl.util.TokenGenerator;
import io.mosip.kernel.auth.defaultimpl.util.TokenValidator;
import io.mosip.kernel.core.authmanager.model.AccessTokenResponseDTO;
import io.mosip.kernel.core.authmanager.model.AuthNResponse;
import io.mosip.kernel.core.authmanager.model.AuthNResponseDto;
import io.mosip.kernel.core.authmanager.model.AuthResponseDto;
import io.mosip.kernel.core.authmanager.model.AuthZResponseDto;
import io.mosip.kernel.core.authmanager.model.ClientSecret;
import io.mosip.kernel.core.authmanager.model.IndividualIdDto;
import io.mosip.kernel.core.authmanager.model.LoginUser;
import io.mosip.kernel.core.authmanager.model.LoginUserWithClientId;
import io.mosip.kernel.core.authmanager.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.model.MosipUserListDto;
import io.mosip.kernel.core.authmanager.model.MosipUserSaltListDto;
import io.mosip.kernel.core.authmanager.model.MosipUserTokenDto;
import io.mosip.kernel.core.authmanager.model.OtpUser;
import io.mosip.kernel.core.authmanager.model.PasswordDto;
import io.mosip.kernel.core.authmanager.model.RIdDto;
import io.mosip.kernel.core.authmanager.model.RefreshTokenRequest;
import io.mosip.kernel.core.authmanager.model.RefreshTokenResponse;
import io.mosip.kernel.core.authmanager.model.RolesListDto;
import io.mosip.kernel.core.authmanager.model.UserDetailsResponseDto;
import io.mosip.kernel.core.authmanager.model.UserNameDto;
import io.mosip.kernel.core.authmanager.model.UserOtp;
import io.mosip.kernel.core.authmanager.model.UserPasswordRequestDto;
import io.mosip.kernel.core.authmanager.model.UserPasswordResponseDto;
import io.mosip.kernel.core.authmanager.model.UserRegistrationRequestDto;
import io.mosip.kernel.core.authmanager.model.UserRoleDto;
import io.mosip.kernel.core.authmanager.model.ValidationResponseDto;
import io.mosip.kernel.core.authmanager.spi.AuthService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Profile(value={"local"})
@Service
public class ProxyAuthServiceImpl
implements AuthService {
    private static final Logger logger = LoggerFactory.getLogger(ProxyAuthServiceImpl.class);
    private static final String CLIENTID_AND_TOKEN_COMBINATION_HAD_BEEN_VALIDATED_SUCCESSFULLY = "Clientid and Token combination had been validated successfully";
    private static final String LOG_OUT_FAILED = "log out failed";
    private static final String FAILED = "Failed";
    private static final String SUCCESS = "Success";
    private static final String SUCCESSFULLY_LOGGED_OUT = "successfully loggedout";
    @Autowired
    private ProxyTokenGenerator proxyTokenGenarator;
    @Value(value="${mosip.iam.open-id-url}")
    private String keycloakOpenIdUrl;
    @Value(value="${mosip.admin_realm_id}")
    private String realmId;
    @Autowired
    UserStoreFactory userStoreFactory;
    @Autowired
    KeycloakImpl keycloakImpl;
    @Autowired
    TokenGenerator tokenGenerator;
    @Autowired
    TokenValidator tokenValidator;
    @Autowired
    TokenService customTokenServices;
    @Autowired
    OTPService oTPService;
    @Autowired
    UinService uinService;
    @Autowired
    MosipEnvironment mosipEnvironment;
    @Autowired
    ObjectMapper objectmapper;
    @Value(value="${mosip.iam.open-id-url}")
    private String openIdUrl;
    @Value(value="${mosip.admin.login_flow.name}")
    private String loginFlowName;
    @Value(value="${mosip.admin.clientid}")
    private String clientID;
    @Value(value="${mosip.admin.clientsecret}")
    private String clientSecret;
    @Value(value="${mosip.admin.redirecturi}")
    private String redirectURI;
    @Value(value="${mosip.admin.login_flow.scope}")
    private String scope;
    @Value(value="${mosip.admin.login_flow.response_type}")
    private String responseType;
    @Value(value="${mosip.iam.authorization_endpoint}")
    private String authorizationEndpoint;
    @Value(value="${mosip.iam.token_endpoint}")
    private String tokenEndpoint;
    @Value(value="${mosip.admin_realm_id}")
    private String realmID;
    @Value(value="${spring.profiles.active}")
    String activeProfile;
    @Value(value="${auth.local.exp:1000000}")
    long localExp;
    @Value(value="${auth.local.secret:secret}")
    String localSecret;
    @Qualifier(value="authRestTemplate")
    @Autowired
    private RestTemplate authRestTemplate;
    @Value(value="${mosip.kernel.auth.proxy-otp}")
    private boolean proxyOtp;

    @Deprecated
    public MosipUserTokenDto validateToken(String token) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported");
    }

    public AuthNResponseDto authenticateUser(LoginUser loginUser) throws Exception {
        return this.proxyTokenForLocalEnv(loginUser.getUserName(), "success", "Username and password combination had been validated successfully");
    }

    public AuthNResponseDto authenticateWithOtp(OtpUser otpUser) throws Exception {
        AuthNResponseDto authNResponseDto = null;
        MosipUserDto mosipUser = null;
        otpUser.getOtpChannel().replaceAll(String::toLowerCase);
        otpUser.setAppId(otpUser.getAppId().toLowerCase());
        otpUser.setOtpChannel(otpUser.getOtpChannel());
        if ("UIN".equals(otpUser.getUseridtype())) {
            if (!this.proxyOtp) {
                mosipUser = this.uinService.getDetailsFromUin(otpUser);
            } else {
                mosipUser = new MosipUserDto();
                mosipUser.setMail("mosip@mosip.io");
                mosipUser.setMobile("91818181223");
                mosipUser.setRId("10012100240015720200428110601");
                mosipUser.setRole("IDA");
            }
            authNResponseDto = this.oTPService.sendOTPForUin(mosipUser, otpUser, "ida");
            authNResponseDto.setStatus(authNResponseDto.getStatus());
            authNResponseDto.setMessage(authNResponseDto.getMessage());
        } else if ("USERID".equals(otpUser.getUseridtype())) {
            UserRegistrationRequestDto userCreationRequestDto = new UserRegistrationRequestDto();
            userCreationRequestDto.setUserName(otpUser.getUserId());
            userCreationRequestDto.setAppId(otpUser.getAppId());
            mosipUser = new MosipUserDto();
            mosipUser.setUserId(otpUser.getUserId());
            authNResponseDto = this.oTPService.sendOTP(mosipUser, otpUser, "mosip");
            authNResponseDto.setStatus(authNResponseDto.getStatus());
            authNResponseDto.setMessage(authNResponseDto.getMessage());
        } else {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), "Invalid User Id type");
        }
        return authNResponseDto;
    }

    public AuthNResponseDto authenticateUserWithOtp(UserOtp userOtp) throws Exception {
        AuthNResponseDto authNResponseDto = new AuthNResponseDto();
        MosipUserTokenDto mosipToken = null;
        MosipUserDto mosipUser = null;
        String realm = this.realmId;
        if (userOtp.getAppId().equalsIgnoreCase("preregistration")) {
            realm = userOtp.getAppId();
        }
        mosipUser = new MosipUserDto();
        mosipUser.setUserId(userOtp.getUserId());
        if (mosipUser == null && "ida".toLowerCase().equals(userOtp.getAppId().toLowerCase())) {
            mosipUser = this.uinService.getDetailsForValidateOtp(userOtp.getUserId());
        }
        if (mosipUser == null) {
            throw new AuthManagerException(AuthErrorCode.USER_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.USER_VALIDATION_ERROR.getErrorMessage());
        }
        mosipToken = this.oTPService.validateOTP(mosipUser, userOtp.getOtp(), userOtp.getAppId());
        if (mosipToken != null && mosipToken.getMosipUserDto() != null) {
            authNResponseDto.setMessage(mosipToken.getMessage());
            authNResponseDto.setStatus(mosipToken.getStatus());
            authNResponseDto.setToken(mosipToken.getToken());
            authNResponseDto.setExpiryTime(mosipToken.getExpTime());
            authNResponseDto.setRefreshToken(mosipToken.getRefreshToken());
            authNResponseDto.setUserId(mosipToken.getMosipUserDto().getUserId());
            authNResponseDto.setRefreshExpiryTime(mosipToken.getExpTime());
        } else {
            authNResponseDto.setMessage(mosipToken.getMessage());
            authNResponseDto.setStatus(mosipToken.getStatus());
        }
        return authNResponseDto;
    }

    public AuthNResponseDto authenticateWithSecretKey(ClientSecret clientSecret) throws Exception {
        return this.proxyTokenForLocalEnv(clientSecret.getClientId(), SUCCESS, CLIENTID_AND_TOKEN_COMBINATION_HAD_BEEN_VALIDATED_SUCCESSFULLY);
    }

    private AuthNResponseDto proxyTokenForLocalEnv(String subject, String status, String message) {
        long exp = System.currentTimeMillis() + this.localExp;
        String token = this.proxyTokenGenarator.getProxyToken(subject, exp);
        logger.debug("token craeted for subject {} to expire at {}", (Object)subject, (Object)exp);
        AuthNResponseDto authNResponseDto = new AuthNResponseDto();
        authNResponseDto.setToken(token);
        authNResponseDto.setRefreshToken(token);
        authNResponseDto.setExpiryTime(exp);
        authNResponseDto.setRefreshExpiryTime(exp);
        authNResponseDto.setStatus(status);
        authNResponseDto.setMessage(message);
        return authNResponseDto;
    }

    public RefreshTokenResponse refreshToken(String appID, String refereshToken, RefreshTokenRequest refreshTokenRequest) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public AuthNResponse invalidateToken(String token) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public RolesListDto getAllRoles(String appId) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public MosipUserListDto getListOfUsersDetails(List<String> userDetails, String appId) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public MosipUserSaltListDto getAllUserDetailsWithSalt(List<String> userDetails, String appId) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public RIdDto getRidBasedOnUid(String userId, String appId) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public AuthZResponseDto unBlockUser(String userId, String appId) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public AuthZResponseDto changePassword(String appId, PasswordDto passwordDto) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public AuthZResponseDto resetPassword(String appId, PasswordDto passwordDto) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public UserNameDto getUserNameBasedOnMobileNumber(String appId, String mobileNumber) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public MosipUserDto registerUser(UserRegistrationRequestDto userCreationRequestDto) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public UserPasswordResponseDto addUserPassword(UserPasswordRequestDto userPasswordRequestDto) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public UserRoleDto getUserRole(String appId, String userId) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public MosipUserDto getUserDetailBasedonMobileNumber(String appId, String mobileNumber) throws Exception {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public ValidationResponseDto validateUserName(String appId, String userName) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public UserDetailsResponseDto getUserDetailBasedOnUserId(String appId, List<String> userIds) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public MosipUserDto valdiateToken(String token) {
        DecodedJWT decodedJWT = JWT.require((Algorithm)Algorithm.none()).build().verify(token);
        MosipUserDto mosipUserDto = new MosipUserDto();
        String user = decodedJWT.getSubject();
        mosipUserDto.setToken(token);
        mosipUserDto.setMail(decodedJWT.getClaim("email").asString());
        mosipUserDto.setMobile(decodedJWT.getClaim("mobile").asString());
        mosipUserDto.setRole(decodedJWT.getClaim("roles").asString());
        mosipUserDto.setName(user);
        mosipUserDto.setUserId(user);
        return mosipUserDto;
    }

    public AuthResponseDto logoutUser(String token) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public AccessTokenResponseDTO loginRedirect(String state, String sessionState, String code, String stateCookie, String redirectURI) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public String getKeycloakURI(String redirectURI, String state) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public AuthNResponseDto authenticateUser(LoginUserWithClientId loginUser) throws Exception {
        return this.proxyTokenForLocalEnv(loginUser.getUserName(), "success", "Username and password combination had been validated successfully");
    }

    public IndividualIdDto getIndividualIdBasedOnUserID(String userId, String appId) {
        throw new UnsupportedOperationException("This openeration is not supported in local profile for now");
    }

    public MosipUserListDto getListOfUsersDetails(String realmId, String roleName, int pageStart, int pageFetch, String email, String firstName, String lastName, String username) {
        throw new UnsupportedOperationException("This openeration is not supported");
    }
}

