/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.service.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.auth.defaultimpl.config.MosipEnvironment;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.dto.AccessTokenResponse;
import io.mosip.kernel.auth.defaultimpl.dto.AuthToken;
import io.mosip.kernel.auth.defaultimpl.dto.KeycloakErrorResponseDto;
import io.mosip.kernel.auth.defaultimpl.dto.RealmAccessDto;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.exception.LoginException;
import io.mosip.kernel.auth.defaultimpl.repository.UserStoreFactory;
import io.mosip.kernel.auth.defaultimpl.repository.impl.KeycloakImpl;
import io.mosip.kernel.auth.defaultimpl.service.OTPService;
import io.mosip.kernel.auth.defaultimpl.service.TokenService;
import io.mosip.kernel.auth.defaultimpl.service.UinService;
import io.mosip.kernel.auth.defaultimpl.util.AuthUtil;
import io.mosip.kernel.auth.defaultimpl.util.TokenGenerator;
import io.mosip.kernel.auth.defaultimpl.util.TokenValidator;
import io.mosip.kernel.core.authmanager.model.AccessTokenResponseDTO;
import io.mosip.kernel.core.authmanager.model.AuthNResponse;
import io.mosip.kernel.core.authmanager.model.AuthNResponseDto;
import io.mosip.kernel.core.authmanager.model.AuthResponseDto;
import io.mosip.kernel.core.authmanager.model.AuthZResponseDto;
import io.mosip.kernel.core.authmanager.model.ClientSecret;
import io.mosip.kernel.core.authmanager.model.IndividualIdDto;
import io.mosip.kernel.core.authmanager.model.LoginUser;
import io.mosip.kernel.core.authmanager.model.LoginUserWithClientId;
import io.mosip.kernel.core.authmanager.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.model.MosipUserListDto;
import io.mosip.kernel.core.authmanager.model.MosipUserSaltListDto;
import io.mosip.kernel.core.authmanager.model.MosipUserTokenDto;
import io.mosip.kernel.core.authmanager.model.OtpUser;
import io.mosip.kernel.core.authmanager.model.PasswordDto;
import io.mosip.kernel.core.authmanager.model.RIdDto;
import io.mosip.kernel.core.authmanager.model.RefreshTokenRequest;
import io.mosip.kernel.core.authmanager.model.RefreshTokenResponse;
import io.mosip.kernel.core.authmanager.model.RolesListDto;
import io.mosip.kernel.core.authmanager.model.UserDetailsResponseDto;
import io.mosip.kernel.core.authmanager.model.UserNameDto;
import io.mosip.kernel.core.authmanager.model.UserOtp;
import io.mosip.kernel.core.authmanager.model.UserPasswordRequestDto;
import io.mosip.kernel.core.authmanager.model.UserPasswordResponseDto;
import io.mosip.kernel.core.authmanager.model.UserRegistrationRequestDto;
import io.mosip.kernel.core.authmanager.model.UserRoleDto;
import io.mosip.kernel.core.authmanager.model.ValidationResponseDto;
import io.mosip.kernel.core.authmanager.spi.AuthService;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Profile(value={"!local"})
@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthServiceImpl.class);
    private static final String CLIENTID_AND_TOKEN_COMBINATION_HAD_BEEN_VALIDATED_SUCCESSFULLY = "Clientid and Token combination had been validated successfully";
    private static final String LOG_OUT_FAILED = "log out failed";
    private static final String FAILED = "Failed";
    private static final String SUCCESS = "Success";
    private static final String SUCCESSFULLY_LOGGED_OUT = "successfully loggedout";
    @Value(value="${mosip.iam.open-id-url}")
    private String keycloakOpenIdUrl;
    @Autowired
    UserStoreFactory userStoreFactory;
    @Autowired
    KeycloakImpl keycloakImpl;
    @Autowired
    TokenGenerator tokenGenerator;
    @Autowired
    TokenValidator tokenValidator;
    @Autowired
    TokenService customTokenServices;
    @Autowired
    OTPService oTPService;
    @Autowired
    UinService uinService;
    @Autowired
    MosipEnvironment mosipEnvironment;
    @Autowired
    ObjectMapper objectmapper;
    @Value(value="${mosip.iam.open-id-url}")
    private String openIdUrl;
    @Value(value="${mosip.admin.login_flow.name}")
    private String loginFlowName;
    @Value(value="${mosip.admin.clientid}")
    private String clientID;
    @Value(value="${mosip.admin.clientsecret}")
    private String clientSecret;
    @Value(value="${mosip.admin.redirecturi}")
    private String redirectURI;
    @Value(value="${mosip.admin.login_flow.scope}")
    private String scope;
    @Value(value="${mosip.admin.login_flow.response_type}")
    private String responseType;
    @Value(value="${mosip.iam.authorization_endpoint}")
    private String authorizationEndpoint;
    @Value(value="${mosip.iam.token_endpoint}")
    private String tokenEndpoint;
    @Value(value="${mosip.admin_realm_id}")
    private String realmID;
    @Value(value="${mosip.kernel.prereg.realm-id}")
    private String preRegRealmID;
    @Value(value="${mosip.iam.base-url}")
    private String keycloakBaseURL;
    @Autowired
    private AuthUtil authUtil;
    @Qualifier(value="authRestTemplate")
    @Autowired
    private RestTemplate authRestTemplate;

    public MosipUserTokenDto validateToken(String token) throws Exception {
        LOGGER.debug("invoked validate token");
        MosipUserTokenDto mosipUserDtoToken = this.tokenValidator.validateToken(token);
        AuthToken authToken = this.customTokenServices.getTokenDetails(token);
        if (authToken == null) {
            throw new AuthManagerException(AuthErrorCode.INVALID_TOKEN.getErrorCode(), AuthErrorCode.INVALID_TOKEN.getErrorMessage());
        }
        if (mosipUserDtoToken != null) {
            LOGGER.debug("token valid for user name " + mosipUserDtoToken.getMosipUserDto().getName());
            return mosipUserDtoToken;
        }
        throw new NonceExpiredException("Auth token expired ");
    }

    public AuthNResponseDto authenticateUser(LoginUser loginUser) throws Exception {
        AuthNResponseDto authNResponseDto = null;
        HttpHeaders headers = new HttpHeaders();
        String realmId = this.authUtil.getRealmIdFromAppId(loginUser.getAppId());
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap tokenRequestBody = null;
        ResponseEntity response = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        LOGGER.debug("invoke " + uriComponentsBuilder.toUriString() + " realm " + realmId + " username " + loginUser.getUserName() + "clientId " + this.clientID);
        tokenRequestBody = this.getPasswordValueMap(this.clientID, this.clientSecret, loginUser.getUserName(), loginUser.getPassword());
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        try {
            response = this.authRestTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            LOGGER.error("Exception >>>>>>>>>>>> ", ex);
            if (ex.getRawStatusCode() == 401) {
                throw new AuthManagerException(AuthErrorCode.INVALID_CREDENTIALS.getErrorCode(), AuthErrorCode.INVALID_CREDENTIALS.getErrorMessage());
            }
            if (ex.getRawStatusCode() == 400) {
                throw new AuthManagerException(AuthErrorCode.REQUEST_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.REQUEST_VALIDATION_ERROR.getErrorMessage());
            }
            throw new AuthManagerException(AuthErrorCode.SERVER_ERROR.getErrorCode(), AuthErrorCode.SERVER_ERROR.getErrorCode());
        }
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.getBody();
        authNResponseDto = new AuthNResponseDto();
        authNResponseDto.setToken(accessTokenResponse.getAccess_token());
        authNResponseDto.setRefreshToken(accessTokenResponse.getRefresh_token());
        authNResponseDto.setExpiryTime(Long.parseLong(accessTokenResponse.getExpires_in()));
        authNResponseDto.setStatus("success");
        authNResponseDto.setMessage("Username and password combination had been validated successfully");
        authNResponseDto.setRefreshExpiryTime(Long.parseLong(accessTokenResponse.getRefresh_expires_in()));
        return authNResponseDto;
    }

    public AuthNResponseDto authenticateWithOtp(OtpUser otpUser) throws Exception {
        AuthNResponseDto authNResponseDto = null;
        String realmId = this.authUtil.getRealmIdFromAppId(otpUser.getAppId());
        MosipUserDto mosipUser = null;
        otpUser.getOtpChannel().replaceAll(String::toLowerCase);
        otpUser.setAppId(otpUser.getAppId().toLowerCase());
        otpUser.setOtpChannel(otpUser.getOtpChannel());
        if ("UIN".equals(otpUser.getUseridtype())) {
            mosipUser = this.uinService.getDetailsFromUin(otpUser);
            LOGGER.debug("OTP, apptype uin with userid " + mosipUser.getUserId() + " realm " + realmId);
            authNResponseDto = this.oTPService.sendOTPForUin(mosipUser, otpUser, realmId);
            authNResponseDto.setStatus(authNResponseDto.getStatus());
            authNResponseDto.setMessage(authNResponseDto.getMessage());
        } else if ("USERID".equals(otpUser.getUseridtype())) {
            UserRegistrationRequestDto userCreationRequestDto = new UserRegistrationRequestDto();
            LOGGER.debug("OTP, apptype userid for userid " + otpUser.getUserId() + " realm " + realmId);
            userCreationRequestDto.setUserName(otpUser.getUserId());
            userCreationRequestDto.setAppId(otpUser.getAppId());
            mosipUser = this.registerUser(userCreationRequestDto);
            authNResponseDto = this.oTPService.sendOTP(mosipUser, otpUser, realmId);
            LOGGER.debug("otp request status " + otpUser.getUserId() + " realm " + realmId + " status " + authNResponseDto.getStatus());
            authNResponseDto.setStatus(authNResponseDto.getStatus());
            authNResponseDto.setMessage(authNResponseDto.getMessage());
        } else {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), "Invalid User Id type");
        }
        return authNResponseDto;
    }

    public AuthNResponseDto authenticateUserWithOtp(UserOtp userOtp) throws Exception {
        AuthNResponseDto authNResponseDto = new AuthNResponseDto();
        MosipUserTokenDto mosipToken = null;
        MosipUserDto mosipUser = null;
        String realm = this.authUtil.getRealmIdFromAppId(userOtp.getAppId());
        if (userOtp.getAppId().equalsIgnoreCase("preregistration")) {
            realm = userOtp.getAppId();
        }
        LOGGER.debug("otp request status " + userOtp.getUserId() + " realm " + realm);
        if (this.keycloakImpl.isUserAlreadyPresent(userOtp.getUserId(), realm)) {
            mosipUser = new MosipUserDto();
            mosipUser.setUserId(userOtp.getUserId());
            LOGGER.info("user already present " + userOtp.getUserId() + " realm " + realm);
        }
        if (mosipUser == null && "ida".toLowerCase().equals(userOtp.getAppId().toLowerCase())) {
            mosipUser = this.uinService.getDetailsForValidateOtp(userOtp.getUserId());
        }
        if (mosipUser == null) {
            throw new AuthManagerException(AuthErrorCode.USER_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.USER_VALIDATION_ERROR.getErrorMessage());
        }
        mosipToken = this.oTPService.validateOTP(mosipUser, userOtp.getOtp(), realm);
        LOGGER.info("Validate otp" + userOtp.getUserId() + " realm " + realm + " status " + mosipToken == null ? " No Response " : mosipToken.getStatus());
        if (mosipToken != null && mosipToken.getMosipUserDto() != null) {
            authNResponseDto.setMessage(mosipToken.getMessage());
            authNResponseDto.setStatus(mosipToken.getStatus());
            authNResponseDto.setToken(mosipToken.getToken());
            authNResponseDto.setExpiryTime(mosipToken.getExpTime());
            authNResponseDto.setRefreshToken(mosipToken.getRefreshToken());
            authNResponseDto.setUserId(mosipToken.getMosipUserDto().getUserId());
            authNResponseDto.setRefreshExpiryTime(mosipToken.getRefreshExpTime());
        } else {
            authNResponseDto.setMessage(mosipToken.getMessage());
            authNResponseDto.setStatus(mosipToken.getStatus());
        }
        return authNResponseDto;
    }

    public AuthNResponseDto authenticateWithSecretKey(ClientSecret clientSecret) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap tokenRequestBody = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        String realmId = this.authUtil.getRealmIdFromAppId(clientSecret.getAppId());
        pathParams.put("realmId", realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        LOGGER.info("invoke " + uriComponentsBuilder.toUriString() + " secret key based authentication " + clientSecret.getClientId() + " realm " + realmId);
        LOGGER.info("This should not be invoked often. If you see too many of this then we need to fix the bug.");
        tokenRequestBody = this.getClientSecretValueMap(clientSecret.getClientId(), clientSecret.getSecretKey());
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        ResponseEntity response = this.authRestTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.getBody();
        LOGGER.info("secret key based authentication " + clientSecret.getClientId() + " realm " + realmId + " accesstoken expires in " + accessTokenResponse.getExpires_in() + " refresh token expires in " + accessTokenResponse.getRefresh_expires_in());
        AuthNResponseDto authNResponseDto = new AuthNResponseDto();
        authNResponseDto.setToken(accessTokenResponse.getAccess_token());
        authNResponseDto.setRefreshToken(accessTokenResponse.getRefresh_token());
        authNResponseDto.setExpiryTime(Long.parseLong(accessTokenResponse.getExpires_in()));
        authNResponseDto.setStatus(SUCCESS);
        authNResponseDto.setMessage(CLIENTID_AND_TOKEN_COMBINATION_HAD_BEEN_VALIDATED_SUCCESSFULLY);
        return authNResponseDto;
    }

    public RefreshTokenResponse refreshToken(String appID, String refreshToken, RefreshTokenRequest refreshTokenRequest) throws Exception {
        LinkedMultiValueMap tokenRequestBody = new LinkedMultiValueMap();
        tokenRequestBody.add((Object)"grant_type", (Object)"refresh_token");
        tokenRequestBody.add((Object)"refresh_token", (Object)refreshToken);
        tokenRequestBody.add((Object)"client_id", (Object)refreshTokenRequest.getClientID());
        tokenRequestBody.add((Object)"client_secret", (Object)refreshTokenRequest.getClientSecret());
        String realmId = this.authUtil.getRealmIdFromAppId(appID);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        LOGGER.info("refresh token based authentication " + uriComponentsBuilder.toUriString() + " realm " + realmId + " client id " + refreshTokenRequest.getClientID());
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.authRestTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            LOGGER.error("refresh token based authentication " + uriComponentsBuilder.toUriString() + " realm " + realmId + " client id " + refreshTokenRequest.getClientID() + " failed with error ");
            LOGGER.error(ex.getMessage());
        }
        Objects.requireNonNull(response);
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.getBody();
        AuthNResponse authNResponse = new AuthNResponse("SUCCESS", "Access token refreshed");
        LOGGER.info("refresh token based authentication " + uriComponentsBuilder.toUriString() + " realm " + realmId + " client id " + refreshTokenRequest.getClientID() + ". Response status: " + authNResponse.getStatus());
        return new RefreshTokenResponse(authNResponse, accessTokenResponse.getAccess_token(), accessTokenResponse.getRefresh_token(), accessTokenResponse.getExpires_in(), accessTokenResponse.getExpires_in());
    }

    public AuthNResponse invalidateToken(String token) throws Exception {
        AuthNResponse authNResponse = null;
        this.customTokenServices.revokeToken(token);
        authNResponse = new AuthNResponse();
        authNResponse.setStatus("success");
        authNResponse.setMessage("Token has been invalidated successfully");
        return authNResponse;
    }

    public RolesListDto getAllRoles(String appId) {
        appId = this.authUtil.getRealmIdFromAppId(appId);
        RolesListDto rolesListDto = this.keycloakImpl.getAllRoles(appId);
        return rolesListDto;
    }

    public MosipUserListDto getListOfUsersDetails(List<String> userDetails, String appId) throws Exception {
        appId = this.authUtil.getRealmIdFromAppId(appId);
        MosipUserListDto mosipUserListDto = this.keycloakImpl.getListOfUsersDetails(userDetails, appId);
        return mosipUserListDto;
    }

    public MosipUserSaltListDto getAllUserDetailsWithSalt(List<String> userDetails, String appId) throws Exception {
        appId = this.authUtil.getRealmIdFromAppId(appId);
        return this.keycloakImpl.getAllUserDetailsWithSalt(userDetails, appId);
    }

    public RIdDto getRidBasedOnUid(String userId, String appId) throws Exception {
        appId = this.authUtil.getRealmIdFromAppId(appId);
        return this.keycloakImpl.getRidFromUserId(userId, appId);
    }

    @Deprecated
    public AuthZResponseDto unBlockUser(String userId, String appId) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).unBlockAccount(userId);
    }

    @Deprecated
    public AuthZResponseDto changePassword(String appId, PasswordDto passwordDto) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).changePassword(passwordDto);
    }

    @Deprecated
    public AuthZResponseDto resetPassword(String appId, PasswordDto passwordDto) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).resetPassword(passwordDto);
    }

    @Deprecated
    public UserNameDto getUserNameBasedOnMobileNumber(String appId, String mobileNumber) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp("registrationclient").getUserNameBasedOnMobileNumber(mobileNumber);
    }

    public MosipUserDto registerUser(UserRegistrationRequestDto userCreationRequestDto) {
        return this.keycloakImpl.registerUser(userCreationRequestDto);
    }

    @Deprecated
    public UserPasswordResponseDto addUserPassword(UserPasswordRequestDto userPasswordRequestDto) {
        return this.userStoreFactory.getDataStoreBasedOnApp(userPasswordRequestDto.getAppId()).addPassword(userPasswordRequestDto);
    }

    public UserRoleDto getUserRole(String appId, String userId) throws Exception {
        MosipUserDto mosipuser = null;
        mosipuser = this.userStoreFactory.getDataStoreBasedOnApp(appId).getUserRoleByUserId(userId);
        UserRoleDto userRole = new UserRoleDto();
        userRole.setUserId(mosipuser.getUserId());
        userRole.setRole(mosipuser.getRole());
        return userRole;
    }

    @Deprecated
    public MosipUserDto getUserDetailBasedonMobileNumber(String appId, String mobileNumber) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).getUserDetailBasedonMobileNumber(mobileNumber);
    }

    @Deprecated
    public ValidationResponseDto validateUserName(String appId, String userName) {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).validateUserName(userName);
    }

    public UserDetailsResponseDto getUserDetailBasedOnUserId(String appId, List<String> userIds) {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).getUserDetailBasedOnUid(userIds);
    }

    public MosipUserDto valdiateToken(String token) {
        HashMap pathparams = new HashMap();
        if (EmptyCheckUtils.isNullEmpty((String)token)) {
            throw new AuthenticationServiceException(AuthErrorCode.INVALID_TOKEN.getErrorMessage());
        }
        String realm = this.tokenValidator.getKeycloakRealm(token);
        ResponseEntity response = null;
        MosipUserDto mosipUserDto = null;
        StringBuilder urlBuilder = new StringBuilder().append(this.keycloakBaseURL).append("/auth/realms/").append(realm).append("/protocol/openid-connect/userinfo");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)urlBuilder.toString());
        LOGGER.info("validate token request to " + uriComponentsBuilder.toUriString());
        HttpHeaders headers = new HttpHeaders();
        String accessToken = "Bearer " + token;
        headers.add("Authorization", accessToken);
        HttpEntity httpRequest = new HttpEntity((MultiValueMap)headers);
        try {
            response = this.authRestTemplate.exchange(uriComponentsBuilder.buildAndExpand(pathparams).toUriString(), HttpMethod.GET, httpRequest, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            LOGGER.error("Token validation failed for accessToken {}", (Object)accessToken);
            KeycloakErrorResponseDto keycloakErrorResponseDto = this.parseKeyClockErrorResponse((HttpStatusCodeException)e);
            if (e.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthenticationServiceException(AuthErrorCode.INVALID_TOKEN.getErrorMessage() + keycloakErrorResponseDto.getError_description());
            }
            if (e.getStatusCode() == HttpStatus.FORBIDDEN) {
                throw new AccessDeniedException(AuthErrorCode.FORBIDDEN.getErrorMessage() + keycloakErrorResponseDto.getError_description());
            }
            throw new AuthManagerException(AuthErrorCode.REST_EXCEPTION.getErrorCode(), AuthErrorCode.REST_EXCEPTION.getErrorMessage() + " " + e.getResponseBodyAsString());
        }
        if (response.getStatusCode().is2xxSuccessful()) {
            mosipUserDto = this.getClaims(token);
            LOGGER.info("Response received for user id " + mosipUserDto.getUserId() + " is " + response.getStatusCode().toString());
        }
        return mosipUserDto;
    }

    public AuthResponseDto logoutUser(String token) {
        if (EmptyCheckUtils.isNullEmpty((String)token)) {
            throw new AuthenticationServiceException(AuthErrorCode.INVALID_TOKEN.getErrorMessage());
        }
        HashMap pathparams = new HashMap();
        String issuer = this.tokenValidator.getissuer(token);
        ResponseEntity response = null;
        AuthResponseDto authResponseDto = new AuthResponseDto();
        StringBuilder urlBuilder = new StringBuilder().append(issuer).append("/protocol/openid-connect/logout");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)urlBuilder.toString()).queryParam("id_token_hint", new Object[]{token});
        LOGGER.info("logout user {} uri: {}", (Object)token, (Object)uriComponentsBuilder.toUriString());
        try {
            response = this.authRestTemplate.getForEntity(uriComponentsBuilder.buildAndExpand(pathparams).toUriString(), String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            LOGGER.error("error occcur in logout : {}", (Object)e.getResponseBodyAsString());
            throw new AuthManagerException(AuthErrorCode.REST_EXCEPTION.getErrorCode(), AuthErrorCode.REST_EXCEPTION.getErrorMessage() + e.getResponseBodyAsString());
        }
        if (response.getStatusCode().is2xxSuccessful()) {
            authResponseDto.setMessage(SUCCESSFULLY_LOGGED_OUT);
            authResponseDto.setStatus(SUCCESS);
        } else {
            authResponseDto.setMessage(LOG_OUT_FAILED);
            authResponseDto.setStatus(FAILED);
        }
        LOGGER.info("logout status {} for token {}", (Object)authResponseDto.getStatus(), (Object)token);
        return authResponseDto;
    }

    private MosipUserDto getClaims(String cookie) {
        DecodedJWT decodedJWT = JWT.decode((String)cookie);
        Claim realmAccess = decodedJWT.getClaim("realm_access");
        RealmAccessDto access = (RealmAccessDto)realmAccess.as(RealmAccessDto.class);
        String[] roles = access.getRoles();
        StringBuilder builder = new StringBuilder();
        for (String r : roles) {
            builder.append(r);
            builder.append(",");
        }
        MosipUserDto dto = new MosipUserDto();
        dto.setUserId(decodedJWT.getClaim("preferred_username").asString());
        dto.setMail(decodedJWT.getClaim("email").asString());
        dto.setMobile(decodedJWT.getClaim("mobile").asString());
        dto.setName(decodedJWT.getClaim("preferred_username").asString());
        dto.setRId(decodedJWT.getClaim("rid").asString());
        dto.setToken(cookie);
        dto.setRole(builder.toString());
        return dto;
    }

    public AccessTokenResponseDTO loginRedirect(String state, String sessionState, String code, String stateCookie, String redirectURI) {
        if (!stateCookie.equals(state)) {
            throw new AuthManagerException(AuthErrorCode.KEYCLOAK_STATE_EXCEPTION.getErrorCode(), AuthErrorCode.KEYCLOAK_STATE_EXCEPTION.getErrorMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)this.loginFlowName);
        map.add((Object)"client_id", (Object)this.clientID);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"redirect_uri", (Object)(this.redirectURI + redirectURI));
        HashMap<String, String> pathParam = new HashMap<String, String>();
        pathParam.put("realmId", this.realmID);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.tokenEndpoint);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.authRestTemplate.exchange(uriBuilder.buildAndExpand(pathParam).toUriString(), HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            KeycloakErrorResponseDto keycloakErrorResponseDto = this.parseKeyClockErrorResponse((HttpStatusCodeException)e);
            throw new LoginException(AuthErrorCode.KEYCLOAK_ACESSTOKEN_EXCEPTION.getErrorCode(), AuthErrorCode.KEYCLOAK_ACESSTOKEN_EXCEPTION.getErrorMessage() + " " + keycloakErrorResponseDto.getError_description());
        }
        AccessTokenResponse accessTokenResponse = null;
        try {
            accessTokenResponse = (AccessTokenResponse)this.objectmapper.readValue((String)responseEntity.getBody(), AccessTokenResponse.class);
        }
        catch (IOException exception) {
            throw new LoginException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage() + " " + exception.getMessage());
        }
        AccessTokenResponseDTO accessTokenResponseDTO = new AccessTokenResponseDTO();
        accessTokenResponseDTO.setAccessToken(accessTokenResponse.getAccess_token());
        accessTokenResponseDTO.setExpiresIn(accessTokenResponse.getExpires_in());
        return accessTokenResponseDTO;
    }

    private KeycloakErrorResponseDto parseKeyClockErrorResponse(HttpStatusCodeException exception) {
        KeycloakErrorResponseDto keycloakErrorResponseDto = null;
        try {
            keycloakErrorResponseDto = (KeycloakErrorResponseDto)this.objectmapper.readValue(exception.getResponseBodyAsString(), KeycloakErrorResponseDto.class);
            LOGGER.error(keycloakErrorResponseDto.getError());
        }
        catch (IOException e) {
            throw new LoginException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage() + " " + e.getMessage());
        }
        return keycloakErrorResponseDto;
    }

    public String getKeycloakURI(String redirectURI, String state) {
        HashMap<String, String> pathParam = new HashMap<String, String>();
        pathParam.put("realmId", this.realmID);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)this.authorizationEndpoint);
        uriComponentsBuilder.queryParam("client_id", new Object[]{this.clientID});
        uriComponentsBuilder.queryParam("redirect_uri", new Object[]{this.redirectURI + redirectURI});
        uriComponentsBuilder.queryParam("state", new Object[]{state});
        uriComponentsBuilder.queryParam("response_type", new Object[]{this.responseType});
        uriComponentsBuilder.queryParam("scope", new Object[]{this.scope});
        return uriComponentsBuilder.buildAndExpand(pathParam).toString();
    }

    private MultiValueMap<String, String> getPasswordValueMap(String clientID, String clientSecret, String username, String password) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"username", (Object)username);
        map.add((Object)"password", (Object)password);
        map.add((Object)"client_id", (Object)clientID);
        map.add((Object)"client_secret", (Object)clientSecret);
        return map;
    }

    private MultiValueMap<String, String> getClientSecretValueMap(String clientID, String clientSecret) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"client_credentials");
        map.add((Object)"client_id", (Object)clientID);
        map.add((Object)"client_secret", (Object)clientSecret);
        return map;
    }

    public AuthNResponseDto authenticateUser(LoginUserWithClientId loginUser) throws Exception {
        AuthNResponseDto authNResponseDto = null;
        HttpHeaders headers = new HttpHeaders();
        String realmId = this.authUtil.getRealmIdFromAppId(loginUser.getAppId());
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap tokenRequestBody = null;
        ResponseEntity response = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        LOGGER.debug("invoke " + uriComponentsBuilder.toUriString() + " realm " + realmId + " username " + loginUser.getUserName() + "clientId " + loginUser.getClientId());
        tokenRequestBody = this.getPasswordValueMap(loginUser.getClientId(), loginUser.getClientSecret(), loginUser.getUserName(), loginUser.getPassword());
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        try {
            response = this.authRestTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            LOGGER.error("Exception >>>>>>>>>>>> ", ex);
            if (ex.getRawStatusCode() == 401) {
                throw new AuthManagerException(AuthErrorCode.INVALID_CREDENTIALS.getErrorCode(), AuthErrorCode.INVALID_CREDENTIALS.getErrorMessage());
            }
            if (ex.getRawStatusCode() == 400) {
                throw new AuthManagerException(AuthErrorCode.REQUEST_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.REQUEST_VALIDATION_ERROR.getErrorMessage());
            }
            throw new AuthManagerException(AuthErrorCode.SERVER_ERROR.getErrorCode(), AuthErrorCode.SERVER_ERROR.getErrorCode());
        }
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.getBody();
        authNResponseDto = new AuthNResponseDto();
        authNResponseDto.setToken(accessTokenResponse.getAccess_token());
        authNResponseDto.setRefreshToken(accessTokenResponse.getRefresh_token());
        authNResponseDto.setExpiryTime(Long.parseLong(accessTokenResponse.getExpires_in()));
        authNResponseDto.setStatus("success");
        authNResponseDto.setMessage("Username and password combination had been validated successfully");
        authNResponseDto.setRefreshExpiryTime(Long.parseLong(accessTokenResponse.getRefresh_expires_in()));
        return authNResponseDto;
    }

    public IndividualIdDto getIndividualIdBasedOnUserID(String userId, String appId) {
        return this.keycloakImpl.getIndividualIdFromUserId(userId, this.authUtil.getRealmIdFromAppId(appId));
    }

    public MosipUserListDto getListOfUsersDetails(String realmId, String roleName, int pageStart, int pageFetch, String email, String firstName, String lastName, String username) {
        return this.keycloakImpl.getListOfUsersDetails(this.authUtil.getRealmIdFromAppId(realmId), roleName, pageStart, pageFetch, email, firstName, lastName, username);
    }
}

