/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.repository.impl;

import io.mosip.kernel.auth.defaultimpl.config.MosipEnvironment;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.dto.DataBaseProps;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.repository.DataStore;
import io.mosip.kernel.auth.defaultimpl.repository.UserStoreFactory;
import io.mosip.kernel.auth.defaultimpl.repository.impl.LdapDataStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Deprecated(since="1.1.5", forRemoval=true)
public class UserStoreFactoryImpl
implements UserStoreFactory {
    @Autowired
    private MosipEnvironment mosipEnvironment;
    private Map<String, DataStore> dataStoreMap = null;
    @Value(value="${hikari.maximumPoolSize:25}")
    private int maximumPoolSize;
    @Value(value="${hikari.validationTimeout:3000}")
    private int validationTimeout;
    @Value(value="${hikari.connectionTimeout:60000}")
    private int connectionTimeout;
    @Value(value="${hikari.idleTimeout:200000}")
    private int idleTimeout;
    @Value(value="${hikari.minimumIdle:0}")
    private int minimumIdle;

    UserStoreFactoryImpl() {
    }

    @PostConstruct
    private void init() {
        this.buildDataStoreMap();
    }

    public Map<String, DataStore> getUserStores() {
        return this.dataStoreMap;
    }

    public void buildDataStoreMap() {
        this.dataStoreMap = new HashMap();
        String datasources = this.mosipEnvironment.getDataStores();
        List<String> dataStoreList = Arrays.asList(datasources.split("\\s*,\\s*"));
        for (String ds : dataStoreList) {
            if (this.dataStoreMap.get(ds) != null) continue;
            DataBaseProps dataBaseConfig = new DataBaseProps();
            dataBaseConfig.setUrl(this.mosipEnvironment.getUrl(ds));
            dataBaseConfig.setPort(this.mosipEnvironment.getPort(ds));
            dataBaseConfig.setUsername(this.mosipEnvironment.getUserName(ds));
            dataBaseConfig.setPassword(this.mosipEnvironment.getPassword(ds));
            dataBaseConfig.setDriverName(this.mosipEnvironment.getDriverName(ds));
            dataBaseConfig.setSchemas(ds);
            if (!ds.contains("ldap")) continue;
            LdapDataStore idatastore = new LdapDataStore(dataBaseConfig);
            this.dataStoreMap.put(ds, idatastore);
        }
    }

    public DataStore getDataStoreBasedOnApp(String appId) {
        String datasource = null;
        if (appId != null) {
            datasource = this.mosipEnvironment.getDataStore(appId.toLowerCase() + "_datasource");
        }
        if (datasource == null) {
            throw new AuthManagerException(AuthErrorCode.INVALID_DATASOURCE_ERROR.getErrorCode(), AuthErrorCode.INVALID_DATASOURCE_ERROR.getErrorMessage());
        }
        return (DataStore)this.dataStoreMap.get(datasource);
    }
}

