/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.repository.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.dto.KeycloakPasswordDTO;
import io.mosip.kernel.auth.defaultimpl.dto.KeycloakRequestDto;
import io.mosip.kernel.auth.defaultimpl.dto.Roles;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.repository.DataStore;
import io.mosip.kernel.auth.defaultimpl.util.AuthUtil;
import io.mosip.kernel.core.authmanager.exception.AuthNException;
import io.mosip.kernel.core.authmanager.exception.AuthZException;
import io.mosip.kernel.core.authmanager.model.AuthZResponseDto;
import io.mosip.kernel.core.authmanager.model.ClientSecret;
import io.mosip.kernel.core.authmanager.model.IndividualIdDto;
import io.mosip.kernel.core.authmanager.model.LoginUser;
import io.mosip.kernel.core.authmanager.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.model.MosipUserListDto;
import io.mosip.kernel.core.authmanager.model.MosipUserSaltListDto;
import io.mosip.kernel.core.authmanager.model.OtpUser;
import io.mosip.kernel.core.authmanager.model.PasswordDto;
import io.mosip.kernel.core.authmanager.model.RIdDto;
import io.mosip.kernel.core.authmanager.model.Role;
import io.mosip.kernel.core.authmanager.model.RolesListDto;
import io.mosip.kernel.core.authmanager.model.UserDetailsResponseDto;
import io.mosip.kernel.core.authmanager.model.UserNameDto;
import io.mosip.kernel.core.authmanager.model.UserOtp;
import io.mosip.kernel.core.authmanager.model.UserPasswordRequestDto;
import io.mosip.kernel.core.authmanager.model.UserPasswordResponseDto;
import io.mosip.kernel.core.authmanager.model.UserRegistrationRequestDto;
import io.mosip.kernel.core.authmanager.model.ValidationResponseDto;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.assertj.core.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class KeycloakImpl
implements DataStore {
    private static final String INDIVIDUAL = "INDIVIDUAL";
    @Value(value="${mosip.iam.realm.operations.base-url}")
    private String keycloakBaseUrl;
    @Value(value="${mosip.iam.admin-url}")
    private String keycloakAdminUrl;
    @Value(value="${mosip.iam.admin-realm-id}")
    private String adminRealmId;
    @Autowired
    private AuthUtil authUtil;
    @Value(value="${mosip.iam.roles-extn-url}")
    private String roles;
    @Value(value="${mosip.iam.users-extn-url}")
    private String users;
    @Value(value="${mosip.iam.role-user-mapping-url}")
    private String roleUserMappingurl;
    @Qualifier(value="keycloakRestTemplate")
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${db_3_DS.keycloak.ipaddress}")
    private String keycloakHost;
    @Value(value="${db_3_DS.keycloak.port}")
    private String keycloakPort;
    @Value(value="${db_3_DS.keycloak.username}")
    private String keycloakUsername;
    @Value(value="${db_3_DS.keycloak.password}")
    private String keycloakPassword;
    @Value(value="${db_3_DS.keycloak.driverClassName}")
    private String keycloakDriver;
    @Value(value="${mosip.iam.pre-reg_user_password}")
    private String preRegUserPassword;
    @Value(value="${mosip.iam.role-based-user-url}")
    private String roleBasedUsersurl;
    @Value(value="${hikari.maximumPoolSize:25}")
    private int maximumPoolSize;
    @Value(value="${hikari.validationTimeout:3000}")
    private int validationTimeout;
    @Value(value="${hikari.connectionTimeout:60000}")
    private int connectionTimeout;
    @Value(value="${hikari.idleTimeout:200000}")
    private int idleTimeout;
    @Value(value="${hikari.minimumIdle:0}")
    private int minimumIdle;
    @Value(value="${mosip.keycloak.max-no-of-users:100}")
    private String maxUsers;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private static final String FETCH_ALL_SALTS = "select ue.username,ua.value from public.user_entity ue, public.user_attribute ua where ue.id=ua.user_id and ua.name='userPassword' and ue.username IN(:username)";
    private static final String FETCH_PASSWORD = "select cr.value from public.credential cr, public.user_entity ue where cr.user_id=ue.id and ue.username=:username";
    @Autowired
    private ObjectMapper objectMapper;
    private String individualRoleID;
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakImpl.class);

    @PostConstruct
    private void setup() {
        this.setUpConnection();
    }

    private void setUpConnection() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(this.keycloakDriver);
        hikariConfig.setJdbcUrl(this.keycloakHost);
        hikariConfig.setUsername(this.keycloakUsername);
        hikariConfig.setPassword(this.keycloakPassword);
        hikariConfig.setMaximumPoolSize(this.maximumPoolSize);
        hikariConfig.setValidationTimeout((long)this.validationTimeout);
        hikariConfig.setConnectionTimeout((long)this.connectionTimeout);
        hikariConfig.setIdleTimeout((long)this.idleTimeout);
        hikariConfig.setMinimumIdle(this.minimumIdle);
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)dataSource);
    }

    public RolesListDto getAllRoles(String appId) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", appId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.roles));
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        ArrayList<Role> rolesList = new ArrayList<Role>();
        try {
            JsonNode node = this.objectMapper.readTree(response);
            for (JsonNode jsonNode : node) {
                Role role = new Role();
                String name = jsonNode.get("name").textValue();
                role.setRoleId(name);
                role.setRoleName(name);
                rolesList.add(role);
            }
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        RolesListDto rolesListDto = new RolesListDto();
        rolesListDto.setRoles(rolesList);
        return rolesListDto;
    }

    public MosipUserListDto getListOfUsersDetails(List<String> userDetails, String realmId) throws Exception {
        List mosipUserDtos = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)new HttpHeaders());
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users));
        uriComponentsBuilder.queryParam("max", new Object[]{this.maxUsers});
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        try {
            JsonNode node = this.objectMapper.readTree(response);
            mosipUserDtos = this.mapUsersToUserDetailDto(node, userDetails, realmId);
        }
        catch (IOException e) {
            LOGGER.error("Error in getListOfUsersDetails", (Throwable)e);
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        MosipUserListDto mosipUserListDto = new MosipUserListDto();
        mosipUserListDto.setMosipUserDtoList(mosipUserDtos);
        return mosipUserListDto;
    }

    public MosipUserSaltListDto getAllUserDetailsWithSalt(List<String> userDetails, String appId) throws Exception {
        return (MosipUserSaltListDto)this.jdbcTemplate.query(FETCH_ALL_SALTS, (SqlParameterSource)new MapSqlParameterSource("username", userDetails), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public RIdDto getRidFromUserId(String userId, String appId) throws Exception {
        RIdDto rIdDto = new RIdDto();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", appId);
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users + "?username=" + userId));
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        if (response == null || response.isEmpty()) {
            throw new AuthManagerException(AuthErrorCode.USER_NOT_FOUND.getErrorCode(), AuthErrorCode.USER_NOT_FOUND.getErrorMessage());
        }
        try {
            JsonNode node = this.objectMapper.readTree(response);
            for (JsonNode jsonNode : node) {
                if (!jsonNode.get("username").textValue().equals(userId)) continue;
                JsonNode attriNode = jsonNode.get("attributes");
                String rid = attriNode.get("rid").get(0).textValue();
                rIdDto.setRId(rid);
                break;
            }
            if (rIdDto.getRId() == null) {
                throw new AuthManagerException(AuthErrorCode.USER_NOT_FOUND.getErrorCode(), AuthErrorCode.USER_NOT_FOUND.getErrorMessage());
            }
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        return rIdDto;
    }

    public AuthZResponseDto unBlockAccount(String userId) throws Exception {
        return null;
    }

    public MosipUserDto registerUser(UserRegistrationRequestDto userId) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        KeycloakRequestDto keycloakRequestDto = this.mapUserRequestToKeycloakRequestDto(userId);
        String realm = this.authUtil.getRealmIdFromAppId(userId.getAppId());
        if (userId.getAppId().equalsIgnoreCase("preregistration")) {
            realm = userId.getAppId();
        }
        pathParams.put("realmId", realm);
        HttpEntity httpEntity = new HttpEntity((Object)keycloakRequestDto);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)this.keycloakBaseUrl.concat("/users"));
        if (!this.isUserAlreadyPresent(userId.getUserName(), realm)) {
            this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.POST, httpEntity);
            if (keycloakRequestDto.getRealmRoles().contains(INDIVIDUAL)) {
                String userID = this.getIDfromUserID(userId.getUserName(), realm);
                this.roleMapper(userID, realm);
            }
        }
        MosipUserDto mosipUserDTO = new MosipUserDto();
        mosipUserDTO.setUserId(userId.getUserName());
        return mosipUserDTO;
    }

    private void roleMapper(String userID, String realmId) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        pathParams.put("userID", userID);
        try {
            if (Strings.isNullOrEmpty((String)this.individualRoleID)) {
                this.individualRoleID = this.getRoleId(INDIVIDUAL, realmId);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Role INDIVIDUAL not found in " + realmId + " for user " + userID);
        }
        Roles role = new Roles(this.individualRoleID, INDIVIDUAL);
        ArrayList<Roles> roles = new ArrayList<Roles>();
        roles.add(role);
        pathParams.put("realmId", realmId);
        HttpEntity httpEntity = new HttpEntity(roles);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)this.keycloakBaseUrl.concat("/users/{userID}/role-mappings/realm"));
        this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.POST, httpEntity);
    }

    private String getIDfromUserID(String userName, String realmId) {
        JsonNode jsonNodes;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)this.keycloakBaseUrl.concat("/users?username=").concat(userName));
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, null);
        try {
            if (response == null) {
                return null;
            }
            jsonNodes = this.objectMapper.readTree(response);
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        if (jsonNodes.size() > 0) {
            for (JsonNode jsonNode : jsonNodes) {
                if (!userName.equals(jsonNode.get("username").asText())) continue;
                return jsonNode.get("id").asText();
            }
        }
        return null;
    }

    public boolean isUserAlreadyPresent(String userName, String realmId) {
        JsonNode jsonNodes;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)this.keycloakBaseUrl.concat("/users?username=").concat(userName));
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, null);
        try {
            if (response == null) {
                return false;
            }
            jsonNodes = this.objectMapper.readTree(response);
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        if (jsonNodes.size() > 0) {
            for (JsonNode jsonNode : jsonNodes) {
                if (!userName.equals(jsonNode.get("username").asText())) continue;
                return true;
            }
        }
        return false;
    }

    private KeycloakRequestDto mapUserRequestToKeycloakRequestDto(UserRegistrationRequestDto userRegDto) {
        KeycloakRequestDto keycloakRequestDto = new KeycloakRequestDto();
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<KeycloakPasswordDTO> credentialObject = null;
        KeycloakPasswordDTO dto = null;
        if (userRegDto.getAppId().equalsIgnoreCase("prereg")) {
            roles.add(INDIVIDUAL);
            credentialObject = new ArrayList<KeycloakPasswordDTO>();
            dto = new KeycloakPasswordDTO();
            dto.setType("password");
            dto.setValue(this.preRegUserPassword);
        } else if (userRegDto.getAppId().equalsIgnoreCase("registrationclient")) {
            credentialObject = new ArrayList();
            dto = new KeycloakPasswordDTO();
            dto.setType("password");
            dto.setValue(userRegDto.getUserPassword());
        }
        credentialObject.add(dto);
        ArrayList<String> contactNoList = new ArrayList<String>();
        ArrayList<String> genderList = new ArrayList<String>();
        genderList.add(userRegDto.getGender());
        contactNoList.add(userRegDto.getContactNo());
        HashMap<String, ArrayList<String>> attributes = new HashMap<String, ArrayList<String>>();
        attributes.put("mobile", contactNoList);
        attributes.put("gender", genderList);
        keycloakRequestDto.setUsername(userRegDto.getUserName());
        keycloakRequestDto.setFirstName(userRegDto.getFirstName());
        keycloakRequestDto.setEmail(userRegDto.getEmailID());
        keycloakRequestDto.setRealmRoles(roles);
        keycloakRequestDto.setAttributes(attributes);
        keycloakRequestDto.setEnabled(true);
        if (credentialObject != null) {
            keycloakRequestDto.setCredentials(credentialObject);
        }
        return keycloakRequestDto;
    }

    private void KeycloakRequestDtomapUserRequestToKeycloakRequestDto(UserRegistrationRequestDto userId) {
    }

    public UserPasswordResponseDto addPassword(UserPasswordRequestDto userPasswordRequestDto) {
        return null;
    }

    public AuthZResponseDto changePassword(PasswordDto passwordDto) throws Exception {
        return null;
    }

    public AuthZResponseDto resetPassword(PasswordDto passwordDto) throws Exception {
        return null;
    }

    public UserNameDto getUserNameBasedOnMobileNumber(String mobileNumber) throws Exception {
        return null;
    }

    public MosipUserDto authenticateUser(LoginUser loginUser) throws Exception {
        return null;
    }

    public MosipUserDto authenticateWithOtp(OtpUser otpUser) throws Exception {
        return null;
    }

    public MosipUserDto authenticateUserWithOtp(UserOtp loginUser) throws Exception {
        return null;
    }

    public MosipUserDto authenticateWithSecretKey(ClientSecret clientSecret) throws Exception {
        return null;
    }

    public MosipUserDto getUserRoleByUserId(String username) throws Exception {
        return null;
    }

    public MosipUserDto getUserDetailBasedonMobileNumber(String mobileNumber) throws Exception {
        return null;
    }

    public ValidationResponseDto validateUserName(String userId) {
        return null;
    }

    public UserDetailsResponseDto getUserDetailBasedOnUid(List<String> userIds) {
        return null;
    }

    private String callKeycloakService(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity) {
        ResponseEntity responseEntity = null;
        String response = null;
        try {
            responseEntity = this.restTemplate.exchange(url, httpMethod, requestEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
            if (ex.getRawStatusCode() == 401) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthNException(validationErrorsList);
                }
                throw new BadCredentialsException("Authentication failed from AuthManager");
            }
            if (ex.getRawStatusCode() == 403) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthZException(validationErrorsList);
                }
                throw new AccessDeniedException("Access denied from AuthManager");
            }
            throw new AuthManagerException(AuthErrorCode.SERVER_ERROR.getErrorCode(), AuthErrorCode.SERVER_ERROR.getErrorMessage());
        }
        if (responseEntity != null && responseEntity.hasBody() && responseEntity.getStatusCode() == HttpStatus.OK) {
            response = (String)responseEntity.getBody();
        }
        return response;
    }

    private List<MosipUserDto> mapUsersToUserDetailDto(JsonNode node, List<String> userDetails, String realmId) {
        ArrayList<MosipUserDto> mosipUserDtos = new ArrayList<MosipUserDto>();
        if (node == null) {
            LOGGER.error("response from openid is null >>");
            return mosipUserDtos;
        }
        for (JsonNode jsonNode : node) {
            MosipUserDto mosipUserDto = new MosipUserDto();
            String username = jsonNode.get("username").textValue();
            if (!userDetails.stream().anyMatch(user -> user.equalsIgnoreCase(username))) continue;
            mosipUserDto.setUserId(username);
            mosipUserDto.setMail(jsonNode.hasNonNull("email") ? jsonNode.get("email").textValue() : null);
            mosipUserDto.setName(String.format("%s %s", jsonNode.hasNonNull("firstName") ? jsonNode.get("firstName").textValue() : "", jsonNode.hasNonNull("lastName") ? jsonNode.get("lastName").textValue() : ""));
            try {
                String roles = this.getRolesAsString(jsonNode.get("id").textValue(), realmId);
                mosipUserDto.setRole(roles);
            }
            catch (IOException e) {
                LOGGER.error("getRolesAsString >>", (Throwable)e);
                throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
            }
            if (jsonNode.hasNonNull("attributes")) {
                JsonNode attributeNodes = jsonNode.get("attributes");
                if (attributeNodes.hasNonNull("mobile") && attributeNodes.get("mobile").hasNonNull(0)) {
                    mosipUserDto.setMobile(attributeNodes.get("mobile").get(0).textValue());
                }
                if (attributeNodes.hasNonNull("rid") && attributeNodes.get("rid").hasNonNull(0)) {
                    mosipUserDto.setRId(attributeNodes.get("rid").get(0).textValue());
                }
                if (attributeNodes.hasNonNull("name") && attributeNodes.get("name").hasNonNull(0)) {
                    mosipUserDto.setName(attributeNodes.get("name").get(0).textValue());
                }
            }
            mosipUserDto.setUserPassword(null);
            mosipUserDtos.add(mosipUserDto);
        }
        return mosipUserDtos;
    }

    private String getPasswordFromDatabase(String userName) {
        return (String)this.jdbcTemplate.query(FETCH_PASSWORD, (SqlParameterSource)new MapSqlParameterSource().addValue("username", (Object)userName), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getRolesAsString(String userId, String realmId) throws IOException {
        StringBuilder roleBuilder = new StringBuilder();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        pathParams.put("userId", userId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users + this.roleUserMappingurl));
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        JsonNode jsonNode = this.objectMapper.readTree(response);
        for (JsonNode node : jsonNode) {
            String role = node.get("name").textValue();
            Objects.nonNull(role);
            roleBuilder.append(role).append(",");
        }
        return roleBuilder.length() > 0 ? roleBuilder.substring(0, roleBuilder.length() - 1) : "";
    }

    private String getRoleId(String roleName, String realmId) throws IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmId);
        pathParams.put("roleName", roleName);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakBaseUrl + "/roles/" + roleName));
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        JsonNode jsonNode = this.objectMapper.readTree(response);
        String roleId = jsonNode.get("id").asText();
        return roleId;
    }

    public IndividualIdDto getIndividualIdFromUserId(String userId, String realmID) {
        IndividualIdDto individualIdDto = new IndividualIdDto();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", realmID);
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users + "?username=" + userId));
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        if (response == null || response.isEmpty()) {
            throw new AuthManagerException(AuthErrorCode.USER_NOT_FOUND.getErrorCode(), AuthErrorCode.USER_NOT_FOUND.getErrorMessage());
        }
        try {
            JsonNode node = this.objectMapper.readTree(response);
            for (JsonNode jsonNode : node) {
                if (!jsonNode.get("username").textValue().equals(userId)) continue;
                JsonNode attriNode = jsonNode.get("attributes");
                String individualId = attriNode.get("individualId").get(0).textValue();
                individualIdDto.setIndividualId(individualId);
                break;
            }
            if (individualIdDto.getIndividualId() == null) {
                throw new AuthManagerException(AuthErrorCode.INDIVIDUAL_ID_NOT_FOUND.getErrorCode(), AuthErrorCode.INDIVIDUAL_ID_NOT_FOUND.getErrorMessage());
            }
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        return individualIdDto;
    }

    public MosipUserListDto getListOfUsersDetails(String realmId, String roleName, int pageStart, int pageFetch, String email, String firstName, String lastName, String username, String search) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        UriComponentsBuilder uriComponentsBuilder = null;
        boolean isRoleBasedSearch = false;
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)new HttpHeaders());
        if (roleName != null && !roleName.isBlank() && !roleName.isEmpty()) {
            pathParams.put("role-name", roleName);
            pathParams.put("realm", realmId);
            uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.roleBasedUsersurl));
            isRoleBasedSearch = true;
        } else {
            pathParams.put("realmId", realmId);
            uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users));
            if (StringUtils.isNotBlank((CharSequence)email)) {
                uriComponentsBuilder.queryParam("email", new Object[]{email});
            }
            if (StringUtils.isNotBlank((CharSequence)firstName)) {
                uriComponentsBuilder.queryParam("firstName", new Object[]{firstName});
            }
            if (StringUtils.isNotBlank((CharSequence)lastName)) {
                uriComponentsBuilder.queryParam("lastName", new Object[]{lastName});
            }
            if (StringUtils.isNotBlank((CharSequence)username)) {
                uriComponentsBuilder.queryParam("username", new Object[]{username});
            }
            if (StringUtils.isNotBlank((CharSequence)search)) {
                uriComponentsBuilder.queryParam("search", new Object[]{search});
            }
        }
        uriComponentsBuilder.queryParam("first", new Object[]{pageStart});
        uriComponentsBuilder.queryParam("max", new Object[]{pageFetch == 0 ? this.maxUsers : Integer.valueOf(pageFetch)});
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        List mosipUserDtos = null;
        try {
            JsonNode node = this.objectMapper.readTree(response);
            mosipUserDtos = this.mapUsersToUserDetailDto(node, realmId, isRoleBasedSearch, roleName);
        }
        catch (IOException e) {
            LOGGER.error("Error in getListOfUsersDetails", (Throwable)e);
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        MosipUserListDto mosipUserListDto = new MosipUserListDto();
        mosipUserListDto.setMosipUserDtoList(mosipUserDtos);
        return mosipUserListDto;
    }

    private List<MosipUserDto> mapUsersToUserDetailDto(JsonNode node, String realmId, boolean isRoleBasedSearch, String roleName) {
        ArrayList<MosipUserDto> mosipUserDtos = new ArrayList<MosipUserDto>();
        if (node == null) {
            LOGGER.error("response from openid is null >>");
            return mosipUserDtos;
        }
        for (JsonNode jsonNode : node) {
            MosipUserDto mosipUserDto = new MosipUserDto();
            String username = jsonNode.get("username").textValue();
            mosipUserDto.setUserId(username);
            mosipUserDto.setMail(jsonNode.hasNonNull("email") ? jsonNode.get("email").textValue() : null);
            mosipUserDto.setName(String.format("%s %s", jsonNode.hasNonNull("firstName") ? jsonNode.get("firstName").textValue() : "", jsonNode.hasNonNull("lastName") ? jsonNode.get("lastName").textValue() : ""));
            mosipUserDto.setRole(roleName);
            if (!isRoleBasedSearch) {
                try {
                    String roles = this.getRolesAsString(jsonNode.get("id").textValue(), realmId);
                    mosipUserDto.setRole(roles);
                }
                catch (IOException e) {
                    LOGGER.error("getRolesAsString >>", (Throwable)e);
                    throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
                }
            }
            if (jsonNode.hasNonNull("attributes")) {
                JsonNode attributeNodes = jsonNode.get("attributes");
                if (attributeNodes.hasNonNull("mobile") && attributeNodes.get("mobile").hasNonNull(0)) {
                    mosipUserDto.setMobile(attributeNodes.get("mobile").get(0).textValue());
                }
                if (attributeNodes.hasNonNull("rid") && attributeNodes.get("rid").hasNonNull(0)) {
                    mosipUserDto.setRId(attributeNodes.get("rid").get(0).textValue());
                }
                if (attributeNodes.hasNonNull("name") && attributeNodes.get("name").hasNonNull(0)) {
                    mosipUserDto.setName(attributeNodes.get("name").get(0).textValue());
                }
            }
            mosipUserDto.setUserPassword(null);
            mosipUserDtos.add(mosipUserDto);
        }
        return mosipUserDtos;
    }
}

