/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.controller;

import io.mosip.kernel.auth.defaultimpl.config.MosipEnvironment;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.dto.UserDetailsRequestDto;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.core.authmanager.model.AccessTokenResponseDTO;
import io.mosip.kernel.core.authmanager.model.AuthNResponse;
import io.mosip.kernel.core.authmanager.model.AuthNResponseDto;
import io.mosip.kernel.core.authmanager.model.AuthResponseDto;
import io.mosip.kernel.core.authmanager.model.AuthZResponseDto;
import io.mosip.kernel.core.authmanager.model.ClientSecret;
import io.mosip.kernel.core.authmanager.model.IndividualIdDto;
import io.mosip.kernel.core.authmanager.model.LoginUser;
import io.mosip.kernel.core.authmanager.model.LoginUserWithClientId;
import io.mosip.kernel.core.authmanager.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.model.MosipUserListDto;
import io.mosip.kernel.core.authmanager.model.MosipUserSaltListDto;
import io.mosip.kernel.core.authmanager.model.MosipUserTokenDto;
import io.mosip.kernel.core.authmanager.model.OtpUser;
import io.mosip.kernel.core.authmanager.model.PasswordDto;
import io.mosip.kernel.core.authmanager.model.RIdDto;
import io.mosip.kernel.core.authmanager.model.RefreshTokenRequest;
import io.mosip.kernel.core.authmanager.model.RefreshTokenResponse;
import io.mosip.kernel.core.authmanager.model.RolesListDto;
import io.mosip.kernel.core.authmanager.model.UserDetailsResponseDto;
import io.mosip.kernel.core.authmanager.model.UserNameDto;
import io.mosip.kernel.core.authmanager.model.UserOtp;
import io.mosip.kernel.core.authmanager.model.UserPasswordRequestDto;
import io.mosip.kernel.core.authmanager.model.UserPasswordResponseDto;
import io.mosip.kernel.core.authmanager.model.UserRoleDto;
import io.mosip.kernel.core.authmanager.model.ValidationResponseDto;
import io.mosip.kernel.core.authmanager.spi.AuthService;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Tag(name="authmanager", description="Operation related to Authentication and Authorization")
public class AuthController {
    private static Logger LOGGER = LoggerFactory.getLogger(AuthController.class);
    @Value(value="${mosip.security.secure-cookie:false}")
    private boolean isSecureCookie;
    @Value(value="${mosip.kernel.auth-code-url-splitter:#URISPLITTER#}")
    private String urlSplitter;
    @Autowired
    private MosipEnvironment mosipEnvironment;
    @Autowired
    private AuthService authService;

    @Deprecated
    @ResponseFilter
    @PostMapping(value={"/authenticate/useridPwd"})
    @Operation(summary="Authenticate using username and password", description="Authenticate using username and password", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponse> authenticateUseridPwd(@RequestBody @Valid RequestWrapper<LoginUser> request, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponse authNResponse = null;
        AuthNResponseDto authResponseDto = this.authService.authenticateUser((LoginUser)request.getRequest());
        if (authResponseDto != null) {
            LOGGER.info("Authentication for " + ((LoginUser)request.getRequest()).getUserName() + " status " + authResponseDto.getStatus());
            Cookie cookie = this.createCookie(authResponseDto.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            authNResponse = new AuthNResponse();
            res.addHeader(this.mosipEnvironment.getAuthTokenHeader(), authResponseDto.getToken());
            res.addCookie(cookie);
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage());
        } else {
            LOGGER.info("Authentication failed for " + ((LoginUser)request.getRequest()).getUserName());
        }
        responseWrapper.setResponse(authNResponse);
        return responseWrapper;
    }

    private Cookie createCookie(String content, int expirationTimeSeconds) {
        Cookie cookie = new Cookie(this.mosipEnvironment.getAuthTokenHeader(), content);
        cookie.setMaxAge(expirationTimeSeconds);
        cookie.setHttpOnly(true);
        cookie.setSecure(this.isSecureCookie);
        cookie.setPath("/");
        return cookie;
    }

    @ResponseFilter
    @PostMapping(value={"/authenticate/sendotp"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Authenticate using OTP", description="Authenticate using OTP", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponse> sendOTP(@RequestBody @Valid RequestWrapper<OtpUser> otpUserDto) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponse authNResponse = null;
        AuthNResponseDto authResponseDto = this.authService.authenticateWithOtp((OtpUser)otpUserDto.getRequest());
        if (authResponseDto != null) {
            LOGGER.info("Send OTP for user " + ((OtpUser)otpUserDto.getRequest()).getUserId() + " status " + authResponseDto.getStatus());
            authNResponse = new AuthNResponse();
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage());
        } else {
            LOGGER.info("Send OTP failed for " + ((OtpUser)otpUserDto.getRequest()).getUserId());
        }
        responseWrapper.setResponse(authNResponse);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authenticate/useridOTP"})
    @Operation(summary="API to validate OTP with user Id", description="API to validate OTP with user Id", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponse> userIdOTP(@RequestBody @Valid RequestWrapper<UserOtp> userOtpDto, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponse authNResponse = null;
        AuthNResponseDto authResponseDto = this.authService.authenticateUserWithOtp((UserOtp)userOtpDto.getRequest());
        if (authResponseDto != null && authResponseDto.getToken() != null) {
            LOGGER.info("useridOTP for user " + ((UserOtp)userOtpDto.getRequest()).getUserId() + " status " + authResponseDto.getStatus());
            Cookie cookie = this.createCookie(authResponseDto.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            authNResponse = new AuthNResponse();
            res.addHeader(this.mosipEnvironment.getAuthTokenHeader(), authResponseDto.getToken());
            res.addCookie(cookie);
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage());
        } else if (authResponseDto != null) {
            LOGGER.info("useridOTP null for user " + ((UserOtp)userOtpDto.getRequest()).getUserId() + " status " + authResponseDto.getStatus());
            authNResponse = new AuthNResponse();
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage() != null ? authResponseDto.getMessage() : "Otp validation failed");
        } else {
            LOGGER.error("useridOTP auth response null for user " + ((UserOtp)userOtpDto.getRequest()).getUserId());
        }
        responseWrapper.setResponse(authNResponse);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authenticate/clientidsecretkey"})
    @Operation(summary="API to authenticate using clientId and secretKey", description="API to authenticate using clientId and secretKey", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponse> clientIdSecretKey(@RequestBody @Valid RequestWrapper<ClientSecret> clientSecretDto, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponse authNResponse = null;
        AuthNResponseDto authResponseDto = this.authService.authenticateWithSecretKey((ClientSecret)clientSecretDto.getRequest());
        if (authResponseDto != null) {
            LOGGER.info("clientidsecretkey for user " + ((ClientSecret)clientSecretDto.getRequest()).getClientId() + " status " + authResponseDto.getStatus());
            Cookie cookie = this.createCookie(authResponseDto.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            authNResponse = new AuthNResponse();
            res.addHeader(this.mosipEnvironment.getAuthTokenHeader(), authResponseDto.getToken());
            res.addCookie(cookie);
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage());
        } else {
            LOGGER.info("clientidsecretkey null for user " + ((ClientSecret)clientSecretDto.getRequest()).getClientId());
        }
        responseWrapper.setResponse(authNResponse);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authorize/validateToken"})
    @Operation(summary="API to validate token", description="API to validate token", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<MosipUserDto> validateToken(HttpServletRequest request, HttpServletResponse res) throws AuthManagerException, Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String authToken = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            throw new AuthManagerException(AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorMessage());
        }
        MosipUserTokenDto mosipUserDtoToken = null;
        try {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().contains("Authorization")) continue;
                authToken = cookie.getValue();
            }
            if (authToken == null) {
                throw new AuthManagerException(AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorMessage());
            }
            mosipUserDtoToken = this.authService.validateToken(authToken);
            if (mosipUserDtoToken != null) {
                LOGGER.info("token expiry time: " + mosipUserDtoToken.getExpTime() + " token payload: " + mosipUserDtoToken.getToken().split("\\.")[1]);
                mosipUserDtoToken.setMessage("Token had been validated successfully");
                Cookie cookie = this.createCookie(mosipUserDtoToken.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
                res.addCookie(cookie);
                responseWrapper.setResponse((Object)mosipUserDtoToken.getMosipUserDto());
            }
        }
        catch (NonceExpiredException exp) {
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), exp.getMessage());
        }
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/authorize/admin/validateToken"})
    @Operation(summary="API to validate token", description="API to validate token", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<MosipUserDto> validateAdminToken(HttpServletRequest request, HttpServletResponse res) {
        String authToken = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            throw new AuthManagerException(AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorMessage());
        }
        MosipUserDto mosipUserDto = null;
        try {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().contains("Authorization")) continue;
                authToken = cookie.getValue();
            }
            if (authToken == null) {
                throw new AuthManagerException(AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorMessage());
            }
            mosipUserDto = this.authService.valdiateToken(authToken);
            LOGGER.debug("validate admin token successful  token payload: " + mosipUserDto.getToken().split("\\.")[1]);
            Cookie cookie = this.createCookie(mosipUserDto.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            res.addCookie(cookie);
        }
        catch (NonceExpiredException exp) {
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), exp.getMessage());
        }
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authorize/refreshToken/{appid}"})
    @Operation(summary="API to retry token when access token expires", description="API to retry token when access token expires", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponse> refreshToken(@PathVariable(value="appid") String appId, @RequestBody RefreshTokenRequest refreshTokenRequest, HttpServletRequest request, HttpServletResponse res) throws Exception {
        Cookie[] cookies;
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String refreshToken = null;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!cookie.getName().contains("refresh_token")) continue;
            refreshToken = cookie.getValue();
            LOGGER.info("refresh token for app " + appId + " from cookie " + cookie.getName());
        }
        Objects.requireNonNull(refreshToken, "No refresh token cookie found");
        RefreshTokenResponse mosipUserDtoToken = this.authService.refreshToken(appId, refreshToken, refreshTokenRequest);
        LOGGER.info("New refresh token obtained for app " + appId + " expires (access token) by " + mosipUserDtoToken.getAccessTokenExpTime() + " refresh token expires in " + mosipUserDtoToken.getRefreshTokenExpTime());
        Cookie cookie = this.createCookie(mosipUserDtoToken.getAccesstoken(), this.mosipEnvironment.getTokenExpiry().intValue());
        res.addCookie(cookie);
        res.addCookie(new Cookie("refresh_token", mosipUserDtoToken.getRefreshToken()));
        responseWrapper.setResponse((Object)mosipUserDtoToken.getAuthNResponse());
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authorize/invalidateToken"})
    @Operation(summary="API to invalidate token when both refresh and auth token expires", description="API to invalidate token when both refresh and auth token expires", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponse> invalidateToken(HttpServletRequest request, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String authToken = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            throw new AuthManagerException(AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorMessage());
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().contains("Authorization")) continue;
            authToken = cookie.getValue();
            LOGGER.info("Attempt to invalidate the token from cookie  " + cookie.getName());
        }
        if (authToken == null) {
            throw new AuthManagerException(AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorMessage());
        }
        AuthNResponse authNResponse = this.authService.invalidateToken(authToken);
        LOGGER.info("Invalidated the token  " + authToken);
        responseWrapper.setResponse((Object)authNResponse);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/roles/{appid}"})
    @Operation(summary="API to get all roles", description="API to get all roles", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<RolesListDto> getAllRoles(@PathVariable(value="appid") String appId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        RolesListDto rolesListDto = this.authService.getAllRoles(appId);
        LOGGER.info("Get roles for " + appId + ". Total roles:  " + rolesListDto.getRoles().size());
        responseWrapper.setResponse((Object)rolesListDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/userdetails/{appid}"})
    @Operation(summary="API to get list of users for a module", description="API to get list of users for a module", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<MosipUserListDto> getListOfUsersDetails(@RequestBody RequestWrapper<UserDetailsRequestDto> userDetails, @PathVariable(value="appid") String appId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        MosipUserListDto mosipUsers = this.authService.getListOfUsersDetails(((UserDetailsRequestDto)userDetails.getRequest()).getUserDetails(), appId);
        LOGGER.info("Get userdetails for " + appId + ". Total users:  " + mosipUsers.getMosipUserDtoList().size());
        responseWrapper.setResponse((Object)mosipUsers);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/usersaltdetails/{appid}"})
    @Operation(summary="API to get list of users for a module with salt", description="API to get list of users for a module with salt", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<MosipUserSaltListDto> getUserDetailsWithSalt(@RequestBody RequestWrapper<UserDetailsRequestDto> userDetails, @PathVariable(value="appid") String appId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        MosipUserSaltListDto mosipUsers = this.authService.getAllUserDetailsWithSalt(((UserDetailsRequestDto)userDetails.getRequest()).getUserDetails(), appId);
        LOGGER.info("Get usersaltdetails for " + appId + ". Total user salts:  " + mosipUsers.getMosipUserSaltList().size());
        responseWrapper.setResponse((Object)mosipUsers);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"rid/{appid}/{userid}"})
    @Operation(summary="API to get rid", description="API to get rid from userid", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<RIdDto> getRId(@PathVariable(value="appid") String appId, @PathVariable(value="userid") String userId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        RIdDto rIdDto = this.authService.getRidBasedOnUid(userId, appId);
        LOGGER.info("Get rid for " + appId + ". Rid:  " + rIdDto.getRId());
        responseWrapper.setResponse((Object)rIdDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"unblock/{appid}/{userid}"})
    @Operation(summary="API to get username", description="API to get username from userid", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthZResponseDto> getUserName(@PathVariable(value="appid") String appId, @PathVariable(value="userid") String userId) throws Exception {
        AuthZResponseDto authZResponseDto = this.authService.unBlockUser(userId, appId);
        LOGGER.info("unblock user " + userId + " appid " + appId + ". Response  status " + authZResponseDto.getStatus());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)authZResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/changepassword/{appid}"})
    @Operation(summary="This API will change the password of the particular user", description="This API will change the password of the particular user", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthZResponseDto> changePassword(@PathVariable(value="appid") String appId, @RequestBody @Valid RequestWrapper<PasswordDto> passwordDto) throws Exception {
        AuthZResponseDto mosipUserDto = this.authService.changePassword(appId, (PasswordDto)passwordDto.getRequest());
        LOGGER.info("changepassword appid " + appId + ". Response  status " + mosipUserDto.getStatus());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/resetpassword/{appid}"})
    @Operation(summary="This API will reset the password of the particular user", description="This API will reset the password of the particular user", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthZResponseDto> resetPassword(@PathVariable(value="appid") String appId, @RequestBody @Valid RequestWrapper<PasswordDto> passwordDto) throws Exception {
        AuthZResponseDto mosipUserDto = this.authService.resetPassword(appId, (PasswordDto)passwordDto.getRequest());
        LOGGER.info("resetpassword appid " + appId + ". Response  status " + mosipUserDto.getStatus());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/username/{appid}/{mobilenumber}"})
    @Operation(summary="This API will get username", description="This API will get username based on mobileno", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<UserNameDto> getUsernameBasedOnMobileNumber(@PathVariable(value="mobilenumber") String mobile, @PathVariable(value="appid") String appId) throws Exception {
        UserNameDto userNameDto = this.authService.getUserNameBasedOnMobileNumber(appId, mobile);
        LOGGER.info("fetch username based on mobile number - appid " + appId + ". Response  status " + userNameDto.getUserName());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)userNameDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/user/addpassword"})
    @Deprecated(forRemoval=true, since="1.1.4")
    @Operation(summary="This API will add password to the user", description="This API will add password to the user", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<UserPasswordResponseDto> addPassword(@RequestBody @Valid RequestWrapper<UserPasswordRequestDto> userPasswordRequestDto) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        UserPasswordResponseDto userPasswordResponseDto = this.authService.addUserPassword((UserPasswordRequestDto)userPasswordRequestDto.getRequest());
        if (userPasswordResponseDto != null && userPasswordResponseDto.getUserName().equals(((UserPasswordRequestDto)userPasswordRequestDto.getRequest()).getUserName())) {
            LOGGER.info("add password " + ((UserPasswordRequestDto)userPasswordRequestDto.getRequest()).getUserName() + ". Response  status success");
        } else {
            LOGGER.info("add password " + ((UserPasswordRequestDto)userPasswordRequestDto.getRequest()).getUserName() + ". Response  status failed");
        }
        responseWrapper.setResponse((Object)userPasswordResponseDto);
        return responseWrapper;
    }

    @GetMapping(value={"/role/{appId}/{userId}"})
    @ResponseFilter
    @Operation(summary="This API will get user role", description="This API will get user role useing appid and userid", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<UserRoleDto> getUserRole(@PathVariable(value="appId") String appId, @PathVariable(value="userId") String userId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        UserRoleDto userRole = this.authService.getUserRole(appId, userId);
        LOGGER.info("role appid " + appId + " user " + userId + ". role " + userRole.getRole());
        responseWrapper.setResponse((Object)userRole);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/userdetail/{appid}/{mobilenumber}"})
    @Operation(summary="This API will get userdetails", description="This API will get userdetails based on mobileno", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<MosipUserDto> getUserDetailBasedOnMobileNumber(@PathVariable(value="mobilenumber") String mobile, @PathVariable(value="appid") String appId) throws Exception {
        MosipUserDto mosipUserDto = this.authService.getUserDetailBasedonMobileNumber(appId, mobile);
        LOGGER.info("userdetail with mobile number appid " + appId + " user " + mosipUserDto.getUserId());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/validate/{appid}/{userid}"})
    @Operation(summary="This API will validate username", description="This API will validate username based on userid", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<ValidationResponseDto> validateUserName(@PathVariable(value="userid") String userId, @PathVariable(value="appid") String appId) {
        ValidationResponseDto validationResponseDto = this.authService.validateUserName(appId, userId);
        LOGGER.info("validate with appid " + appId + " user " + userId + ". Response " + validationResponseDto.getStatus());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)validationResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/userdetail/regid/{appid}"})
    @Operation(summary="Gets the user detail based on user id", description="Gets the user detail based on user id", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<UserDetailsResponseDto> getUserDetailBasedOnUserId(@PathVariable(value="appid") String appId, @RequestBody RequestWrapper<UserDetailsRequestDto> userDetails) {
        UserDetailsResponseDto userDetailsDto = this.authService.getUserDetailBasedOnUserId(appId, ((UserDetailsRequestDto)userDetails.getRequest()).getUserDetails());
        LOGGER.info("userdetail regid with appid " + appId + " request user count " + ((UserDetailsRequestDto)userDetails.getRequest()).getUserDetails().size() + ". Response user count " + userDetailsDto.getUserDetails().size());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)userDetailsDto);
        return responseWrapper;
    }

    @ResponseFilter
    @DeleteMapping(value={"/logout/user"})
    @Operation(summary="Logout a user", description="ends users session", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthResponseDto> logoutUser(@CookieValue(value="Authorization", required=false) String token, HttpServletResponse res) {
        AuthResponseDto authResponseDto = this.authService.logoutUser(token);
        LOGGER.info("logout user " + token + ". Response " + authResponseDto.getStatus());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)authResponseDto);
        return responseWrapper;
    }

    @Deprecated
    @GetMapping(value={"/login/{redirectURI}"})
    @Operation(summary="Login a user", description="internal api for auth code flow", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public void login(@CookieValue(value="state") String state, @PathVariable(value="redirectURI") String redirectURI, HttpServletResponse res) throws IOException {
        String uri = this.authService.getKeycloakURI(redirectURI, state);
        LOGGER.info("redirect open id login uri " + uri);
        res.setStatus(302);
        res.sendRedirect(uri);
    }

    @Deprecated
    @GetMapping(value={"/login-redirect/{redirectURI}"})
    @Operation(summary="Login a user", description="internal api for auth code flow", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public void loginRedirect(@PathVariable(value="redirectURI") String redirectURI, @RequestParam(value="state") String state, @RequestParam(value="session_state") String sessionState, @RequestParam(value="code") String code, @CookieValue(value="state") String stateCookie, HttpServletResponse res) throws IOException {
        AccessTokenResponseDTO jwtResponseDTO = this.authService.loginRedirect(state, sessionState, code, stateCookie, redirectURI);
        Cookie cookie = this.createCookie(jwtResponseDTO.getAccessToken(), Integer.parseInt(jwtResponseDTO.getExpiresIn()));
        res.addCookie(cookie);
        res.setStatus(302);
        String uri = new String(Base64.decodeBase64((byte[])redirectURI.getBytes()));
        LOGGER.info("login-redirect open id login uri " + uri);
        res.sendRedirect(uri);
    }

    private void removeCookie(Cookie cookie) {
        cookie.setValue("");
        cookie.setPath("/");
        cookie.setMaxAge(0);
    }

    @ResponseFilter
    @PostMapping(value={"/authenticate/internal/useridPwd"})
    @Operation(summary="Internal API used by syncdata delegate API to authenticate", description="Internal API used by syncdata delegate API to authenticate", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponseDto> getAllAuthTokens(@RequestBody @Valid RequestWrapper<LoginUserWithClientId> request, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponseDto authResponseDto = this.authService.authenticateUser((LoginUserWithClientId)request.getRequest());
        responseWrapper.setResponse((Object)authResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authenticate/internal/userotp"})
    @Operation(summary="Internal API used by syncdata delegate API to authenticate using otp", description="Internal API used by syncdata delegate API to authenticate using otp", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponseDto> getAllAuthTokensForOTP(@RequestBody @Valid RequestWrapper<UserOtp> request, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponseDto authResponseDto = this.authService.authenticateUserWithOtp((UserOtp)request.getRequest());
        responseWrapper.setResponse((Object)authResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authorize/internal/refreshToken/{appid}"})
    @Operation(summary="Internal API used by syncdata delegate API to refreah token", description="Internal API used by syncdata delegate API to refresh token", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<AuthNResponseDto> refreshAuthToken(@PathVariable(value="appid") String appId, @RequestBody RefreshTokenRequest refreshTokenRequest, HttpServletRequest request, HttpServletResponse res) throws Exception {
        Cookie[] cookies;
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String refreshToken = null;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!cookie.getName().contains("refresh_token")) continue;
            refreshToken = cookie.getValue();
            LOGGER.info("refresh token for app " + appId + " from cookie " + cookie.getName());
        }
        Objects.requireNonNull(refreshToken, "No refresh token cookie found");
        RefreshTokenResponse mosipUserDtoToken = this.authService.refreshToken(appId, refreshToken, refreshTokenRequest);
        AuthNResponseDto authNResponseDto = new AuthNResponseDto();
        authNResponseDto.setToken(mosipUserDtoToken.getAccesstoken());
        authNResponseDto.setRefreshToken(mosipUserDtoToken.getRefreshToken());
        authNResponseDto.setExpiryTime(Long.parseLong(mosipUserDtoToken.getAccessTokenExpTime()));
        authNResponseDto.setRefreshExpiryTime(Long.parseLong(mosipUserDtoToken.getRefreshTokenExpTime()));
        responseWrapper.setResponse((Object)authNResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"individualId/{appid}/{userid}"})
    @Operation(summary="This API will fetch IndividualId based on appId and userId", description="This API will fetch IndividualId based on appId and userId", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<IndividualIdDto> getIndividualId(@PathVariable(value="appid") String appId, @PathVariable(value="userid") String userId) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        IndividualIdDto individualIdDto = this.authService.getIndividualIdBasedOnUserID(userId, appId);
        responseWrapper.setResponse((Object)individualIdDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/userdetails/{appid}"})
    @Operation(summary="This API will fetch all users based on appId and roles", description="This API will fetch all users based on appId and roles for role bases search only pagination will work,Without role can be searched by all,email,firstName,lastName and userName", tags={"authmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    public ResponseWrapper<MosipUserListDto> getUsersDetails(@PathVariable(value="appid") String appId, @RequestParam(required=false, name="roleName") String roleName, @RequestParam(defaultValue="0", required=false, name="pageStart") int pageStart, @RequestParam(defaultValue="0", required=false, name="pageFetch") int pageFetch, @RequestParam(required=false, name="email") String email, @RequestParam(required=false, name="firstName") String firstName, @RequestParam(required=false, name="lastName") String lastName, @RequestParam(required=false, name="userName") String userName, @RequestParam(required=false, name="search") String search) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        MosipUserListDto mosipUsers = this.authService.getListOfUsersDetails(appId, roleName, pageStart, pageFetch, email, firstName, lastName, userName, search);
        LOGGER.info("Get userdetails for " + appId + ". Total users:  " + mosipUsers.getMosipUserDtoList().size());
        responseWrapper.setResponse((Object)mosipUsers);
        return responseWrapper;
    }
}

