/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.auth.defaultimpl.config.MosipEnvironment;
import io.mosip.kernel.auth.defaultimpl.constant.AuthErrorCode;
import io.mosip.kernel.auth.defaultimpl.constant.OTPErrorCode;
import io.mosip.kernel.auth.defaultimpl.dto.otp.idrepo.ResponseDTO;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerException;
import io.mosip.kernel.auth.defaultimpl.exception.AuthManagerServiceException;
import io.mosip.kernel.auth.defaultimpl.service.TokenGenerationService;
import io.mosip.kernel.auth.defaultimpl.service.UinService;
import io.mosip.kernel.core.authmanager.exception.AuthNException;
import io.mosip.kernel.core.authmanager.exception.AuthZException;
import io.mosip.kernel.core.authmanager.model.MosipUserDto;
import io.mosip.kernel.core.authmanager.model.OtpUser;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class UinServiceImpl
implements UinService {
    @Qualifier(value="authRestTemplate")
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    MosipEnvironment env;
    @Autowired
    Environment en;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private TokenGenerationService tokenService;
    public static final String MOSIP_NOTIFICATIONTYPE = "mosip.notificationtype";

    public MosipUserDto getDetailsFromUin(OtpUser otpUser) throws Exception {
        String token = null;
        MosipUserDto mosipDto = null;
        ResponseDTO idResponse = null;
        HashMap<String, String> uriParams = new HashMap<String, String>();
        try {
            token = this.tokenService.getUINBasedToken();
        }
        catch (Exception e) {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cookie", "Authorization=" + token);
        uriParams.put("UIN".toLowerCase(), otpUser.getUserId());
        ResponseEntity response = null;
        String url = UriComponentsBuilder.fromHttpUrl((String)this.env.getUinGetDetailsUrl()).buildAndExpand(uriParams).toUriString();
        try {
            LinkedHashMap res;
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                String responseBody = (String)response.getBody();
                List validationErrorsList = null;
                validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthManagerServiceException(validationErrorsList);
                }
                try {
                    ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                    idResponse = (ResponseDTO)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), ResponseDTO.class);
                }
                catch (Exception e) {
                    throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
                }
            }
            if ((res = (LinkedHashMap)idResponse.getIdentity()) != null) {
                mosipDto = new MosipUserDto();
                mosipDto.setUserId(otpUser.getUserId());
                this.validate((Map)res, otpUser.getOtpChannel());
                if (res.get("phone") != null) {
                    mosipDto.setMobile((String)res.get("phone"));
                }
                if (res.get("email") != null) {
                    mosipDto.setMail((String)res.get("email"));
                }
            }
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
            if (ex.getRawStatusCode() == 401) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthNException(validationErrorsList);
                }
                throw new BadCredentialsException("Authentication failed from UIN services " + ex.getResponseBodyAsString());
            }
            if (ex.getRawStatusCode() == 403) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthZException(validationErrorsList);
                }
                throw new AccessDeniedException("Access denied from UIN services");
            }
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), AuthErrorCode.CLIENT_ERROR.getErrorMessage(), ex);
        }
        return mosipDto;
    }

    public MosipUserDto getDetailsForValidateOtp(String uin) throws Exception {
        String token = null;
        MosipUserDto mosipDto = null;
        ResponseDTO idResponse = null;
        HashMap<String, String> uriParams = new HashMap<String, String>();
        try {
            token = this.tokenService.getUINBasedToken();
        }
        catch (Exception e) {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cookie", "Authorization=" + token);
        uriParams.put("UIN".toLowerCase(), uin);
        ResponseEntity response = null;
        String url = UriComponentsBuilder.fromHttpUrl((String)this.env.getUinGetDetailsUrl()).buildAndExpand(uriParams).toUriString();
        try {
            LinkedHashMap res;
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                String responseBody = (String)response.getBody();
                List validationErrorsList = null;
                validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
                Optional<ServiceError> service = validationErrorsList.stream().filter(a -> a.getErrorCode().equals("IDR-IDC-002") || a.getErrorCode().equals("IDR-IDS-002")).findFirst();
                if (service.isPresent()) {
                    throw new AuthManagerException(AuthErrorCode.USER_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.USER_VALIDATION_ERROR.getErrorMessage());
                }
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthManagerServiceException(validationErrorsList);
                }
                try {
                    ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                    idResponse = (ResponseDTO)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), ResponseDTO.class);
                }
                catch (Exception e) {
                    throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), e.getMessage(), (Throwable)e);
                }
            }
            if ((res = (LinkedHashMap)idResponse.getIdentity()) != null) {
                mosipDto = new MosipUserDto();
                mosipDto.setUserId(uin);
                this.validate((Map)res, null);
                if (res.get("phone") != null) {
                    mosipDto.setMobile((String)res.get("phone"));
                }
                if (res.get("email") != null) {
                    mosipDto.setMail((String)res.get("email"));
                }
            }
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
            if (ex.getRawStatusCode() == 401) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthNException(validationErrorsList);
                }
                throw new BadCredentialsException("Authentication failed from UIN services " + ex.getResponseBodyAsString());
            }
            if (ex.getRawStatusCode() == 403) {
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthZException(validationErrorsList);
                }
                throw new AccessDeniedException("Access denied from UIN services");
            }
            if (!validationErrorsList.isEmpty()) {
                throw new AuthManagerServiceException(validationErrorsList);
            }
            throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), AuthErrorCode.CLIENT_ERROR.getErrorMessage() + ex.getMessage());
        }
        return mosipDto;
    }

    private void validate(Map<String, String> res, List<String> channelList) {
        String notficationType = this.en.getProperty(MOSIP_NOTIFICATIONTYPE);
        String[] notificationArray = notficationType.split("[\\|\\s]+");
        List<String> notifyList = Arrays.asList(notificationArray);
        String phone = res.get("phone");
        String email = res.get("email");
        this.validateConfigChannel(notifyList, channelList);
        if (StringUtils.isBlank((CharSequence)phone) && StringUtils.isBlank((CharSequence)email) && channelList.contains("phone") && channelList.contains("email")) {
            throw new AuthManagerException(OTPErrorCode.EMAILPHONENOTREGISTERED.getErrorCode(), OTPErrorCode.EMAILPHONENOTREGISTERED.getErrorMessage());
        }
        if (StringUtils.isBlank((CharSequence)phone) && channelList.contains("phone")) {
            throw new AuthManagerException(OTPErrorCode.PHONENOTREGISTERED.getErrorCode(), OTPErrorCode.PHONENOTREGISTERED.getErrorMessage());
        }
        if (StringUtils.isBlank((CharSequence)email) && channelList.contains("email")) {
            throw new AuthManagerException(OTPErrorCode.EMAILNOTREGISTERED.getErrorCode(), OTPErrorCode.EMAILNOTREGISTERED.getErrorMessage());
        }
    }

    private void validateConfigChannel(List<String> notifyList, List<String> channelList) {
        if (!notifyList.contains("SMS") && !notifyList.contains("EMAIL") && channelList.contains("phone") && channelList.contains("email")) {
            throw new AuthManagerException(OTPErrorCode.EMAILSMSNOTCONFIGURED.getErrorCode(), OTPErrorCode.EMAILSMSNOTCONFIGURED.getErrorMessage());
        }
        if (!notifyList.contains("SMS") && channelList.contains("phone")) {
            throw new AuthManagerException(OTPErrorCode.SMSNOTCONFIGURED.getErrorCode(), OTPErrorCode.SMSNOTCONFIGURED.getErrorMessage());
        }
        if (!notifyList.contains("EMAIL") && channelList.contains("email")) {
            throw new AuthManagerException(OTPErrorCode.SMSNOTCONFIGURED.getErrorCode(), OTPErrorCode.SMSNOTCONFIGURED.getErrorMessage());
        }
    }
}

