/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.defaultimpl.util;

import io.mosip.kernel.auth.defaultimpl.util.MemoryCache;
import org.apache.commons.collections.map.LRUMap;

public class MemoryCache<K, T> {
    private LRUMap cacheMap;

    public MemoryCache(int maxItems) {
        this.cacheMap = new LRUMap(maxItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, T value) {
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            this.cacheMap.put(key, (Object)new CacheObject(this, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(K key) {
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            CacheObject c = (CacheObject)this.cacheMap.get(key);
            if (c == null) {
                return null;
            }
            c.lastAccessed = System.currentTimeMillis();
            return (T)c.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            this.cacheMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            return this.cacheMap.size();
        }
    }
}

