/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.util;

import io.mosip.kernel.auth.adapter.exception.AuthManagerException;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AuthUtil {
    @Value(value="#{${mosip.kernel.auth.appid-realm-map}}")
    private Map<String, String> propertyname;

    public String getRealmIdFromAppId(String appId) {
        String realmId = null;
        if (this.propertyname.get(appId) == null) {
            throw new AuthManagerException(AuthErrorCode.REALM_NOT_FOUND.getErrorCode(), String.format(AuthErrorCode.REALM_NOT_FOUND.getErrorMessage(), appId));
        }
        realmId = ((String)this.propertyname.get(appId)).toLowerCase();
        return realmId;
    }
}

