/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.repository.impl;

import io.mosip.kernel.auth.config.MosipEnvironment;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.constant.LDAPErrorCode;
import io.mosip.kernel.auth.dto.AuthZResponseDto;
import io.mosip.kernel.auth.dto.ClientSecret;
import io.mosip.kernel.auth.dto.DataBaseProps;
import io.mosip.kernel.auth.dto.LdapControl;
import io.mosip.kernel.auth.dto.LoginUser;
import io.mosip.kernel.auth.dto.MosipUserDto;
import io.mosip.kernel.auth.dto.MosipUserListDto;
import io.mosip.kernel.auth.dto.MosipUserSalt;
import io.mosip.kernel.auth.dto.MosipUserSaltListDto;
import io.mosip.kernel.auth.dto.PasswordDto;
import io.mosip.kernel.auth.dto.RIdDto;
import io.mosip.kernel.auth.dto.Role;
import io.mosip.kernel.auth.dto.RolesListDto;
import io.mosip.kernel.auth.dto.UserDetailsDto;
import io.mosip.kernel.auth.dto.UserDetailsResponseDto;
import io.mosip.kernel.auth.dto.UserNameDto;
import io.mosip.kernel.auth.dto.UserOtp;
import io.mosip.kernel.auth.dto.UserPasswordRequestDto;
import io.mosip.kernel.auth.dto.UserPasswordResponseDto;
import io.mosip.kernel.auth.dto.UserRegistrationRequestDto;
import io.mosip.kernel.auth.dto.ValidationResponseDto;
import io.mosip.kernel.auth.dto.otp.OtpUser;
import io.mosip.kernel.auth.exception.AuthManagerException;
import io.mosip.kernel.auth.repository.DataStore;
import io.mosip.kernel.auth.util.TokenGenerator;
import io.mosip.kernel.auth.util.TokenValidator;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.HMACUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.password.PasswordDetails;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.assertj.core.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class LdapDataStore
implements DataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapDataStore.class);
    private DataBaseProps dataBaseConfig;
    @Autowired
    TokenGenerator tokenGenerator;
    @Autowired
    TokenValidator tokenValidator;
    @Autowired
    MosipEnvironment environment;
    @Value(value="${mosip.kernel.ldap-provider-url:ldap://localhost:389}")
    private String ldapProviderURL;
    @Value(value="${mosip.kernel.ldap-security-principal:uid=admin,ou=system}")
    private String ldapSecurityPrincipal;
    @Value(value="${mosip.kernel.ldap-security-credentials:#{null}}")
    private String ldapSecurityCredentials;

    public LdapDataStore() {
    }

    public LdapDataStore(DataBaseProps dataBaseConfig) {
        this.dataBaseConfig = dataBaseConfig;
    }

    private LdapConnection createAnonymousConnection() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection(this.dataBaseConfig.getUrl(), Integer.valueOf(this.dataBaseConfig.getPort()).intValue());
        return connection;
    }

    private LdapContext getContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (!env.containsKey("java.naming.factory.initial")) {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (Strings.isNullOrEmpty((String)this.ldapProviderURL) || Strings.isNullOrEmpty((String)this.ldapSecurityCredentials)) {
            LOGGER.error("Ldap url or credential properties empty or null ");
            throw new NamingException("Ldap url or credential properties empty or null");
        }
        env.put("java.naming.provider.url", this.ldapProviderURL);
        env.put("java.naming.security.principal", this.ldapSecurityPrincipal);
        env.put("java.naming.security.credentials", this.ldapSecurityCredentials);
        InitialLdapContext context = new InitialLdapContext(env, null);
        LdapControl ldapControl = new LdapControl();
        context.setRequestControls(ldapControl.getControls());
        return context;
    }

    public MosipUserDto authenticateUser(LoginUser loginUser) throws Exception {
        MosipUserDto mosipUser = this.getLoginDetails(loginUser);
        return mosipUser;
    }

    public MosipUserDto authenticateWithOtp(OtpUser otpUser) throws Exception {
        MosipUserDto mosipUser = this.getOtpDetails(otpUser);
        return mosipUser;
    }

    private MosipUserDto getOtpDetails(OtpUser otpUser) throws Exception {
        LdapConnection connection = this.createAnonymousConnection();
        MosipUserDto mosipUserDto = null;
        Dn userdn = null;
        try {
            userdn = this.createUserDn(otpUser.getUserId());
            mosipUserDto = this.lookupUserDetails(userdn, connection);
            if (!connection.exists(userdn)) {
                throw new AuthManagerException(AuthErrorCode.USER_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.USER_VALIDATION_ERROR.getErrorMessage());
            }
        }
        catch (Exception e) {
            throw new AuthManagerException(LDAPErrorCode.LDAP_CONNECTION_ERROR.getErrorCode(), LDAPErrorCode.LDAP_CONNECTION_ERROR.getErrorMessage(), (Throwable)e);
        }
        finally {
            connection.close();
        }
        return mosipUserDto;
    }

    public MosipUserDto authenticateUserWithOtp(UserOtp userOtp) throws Exception {
        MosipUserDto mosipUserDto = this.getMosipUser(userOtp.getUserId());
        return mosipUserDto;
    }

    private MosipUserDto getMosipUser(String userId) throws Exception {
        MosipUserDto mosipUserDto = null;
        try (LdapConnection connection = null;){
            connection = this.createAnonymousConnection();
            Dn userdn = this.createUserDn(userId);
            mosipUserDto = this.lookupUserDetails(userdn, connection);
        }
        return mosipUserDto;
    }

    public MosipUserDto authenticateWithSecretKey(ClientSecret clientSecret) throws Exception {
        MosipUserDto mosipUser = this.getClientSecretDetails(clientSecret);
        return mosipUser;
    }

    private MosipUserDto getClientSecretDetails(ClientSecret clientSecret) throws Exception {
        LdapConnection connection = null;
        try {
            connection = this.createAnonymousConnection();
            Dn userdn = this.createUserDn(clientSecret.getClientId());
            connection.bind(userdn, clientSecret.getSecretKey());
            if (connection.isAuthenticated()) {
                MosipUserDto mosipUserDto = this.lookupUserDetails(userdn, connection);
                return mosipUserDto;
            }
        }
        catch (Exception ex) {
            throw new AuthManagerException(LDAPErrorCode.LDAP_CONNECTION_ERROR.getErrorCode(), LDAPErrorCode.LDAP_CONNECTION_ERROR.getErrorMessage(), (Throwable)ex);
        }
        finally {
            connection.unBind();
            connection.close();
        }
        return null;
    }

    public MosipUserDto getLoginDetails(LoginUser loginUser) throws Exception {
        LdapConnection connection = null;
        try {
            connection = this.createAnonymousConnection();
            Dn userdn = this.createUserDn(loginUser.getUserName());
            connection.bind(userdn, loginUser.getPassword());
            if (connection.isAuthenticated()) {
                MosipUserDto mosipUserDto = this.lookupUserDetails(userdn, connection);
                return mosipUserDto;
            }
        }
        catch (Exception ex) {
            throw new AuthManagerException(LDAPErrorCode.LDAP_CONNECTION_ERROR.getErrorCode(), LDAPErrorCode.LDAP_CONNECTION_ERROR.getErrorMessage(), (Throwable)ex);
        }
        finally {
            connection.unBind();
            connection.close();
        }
        return null;
    }

    private MosipUserDto lookupUserDetails(Dn userdn, LdapConnection connection) throws Exception {
        try {
            Collection roles = this.getUserRoles(userdn, connection);
            String rolesString = this.convertRolesToString(roles);
            MosipUserDto mosipUserDto = null;
            Entry userLookup = connection.lookup(userdn);
            if (userLookup != null) {
                mosipUserDto = new MosipUserDto();
                mosipUserDto.setUserId(userLookup.get("uid").get().toString());
                mosipUserDto.setMobile(userLookup.get("mobile") != null ? userLookup.get("mobile").get().toString() : null);
                mosipUserDto.setMail(userLookup.get("mail") != null ? userLookup.get("mail").get().toString() : null);
                if (userLookup.get("userPassword") != null) {
                    PasswordDetails password = PasswordUtil.splitCredentials((byte[])userLookup.get("userPassword").get().getBytes());
                    mosipUserDto.setUserPassword(userLookup.get("userPassword") != null ? HMACUtils.digestAsPlainText((byte[])password.getPassword()) : null);
                }
                mosipUserDto.setName(userLookup.get("cn").get().toString());
                if (userLookup.get("rid") != null) {
                    mosipUserDto.setRId(userLookup.get("rid").get().toString());
                }
                mosipUserDto.setRole(rolesString);
            }
            return mosipUserDto;
        }
        catch (Exception ex) {
            throw new AuthManagerException(LDAPErrorCode.LDAP_PARSE_REQUEST_ERROR.getErrorCode(), LDAPErrorCode.LDAP_PARSE_REQUEST_ERROR.getErrorMessage(), (Throwable)ex);
        }
    }

    private Collection<String> getUserRoles(Dn userdn, LdapConnection connection) {
        try {
            Dn searchBase = new Dn(new String[]{"ou=roles,c=mycountry"});
            String searchFilter = "(&(objectClass=organizationalRole)(roleOccupant=" + userdn + "))";
            EntryCursor rolesData = connection.search(searchBase, searchFilter, SearchScope.ONELEVEL, new String[0]);
            HashSet<String> roles = new HashSet<String>();
            for (Entry entry : rolesData) {
                roles.add(entry.get("cn").getString());
            }
            rolesData.close();
            return roles;
        }
        catch (Exception ex) {
            throw new AuthManagerException(LDAPErrorCode.LDAP_ROLES_REQUEST_ERROR.getErrorCode(), LDAPErrorCode.LDAP_ROLES_REQUEST_ERROR.getErrorMessage(), (Throwable)ex);
        }
    }

    private String convertRolesToString(Collection<String> roles) throws Exception {
        StringBuilder rolesString = new StringBuilder();
        for (String role : roles) {
            rolesString.append(role);
            rolesString.append(",");
        }
        return rolesString.length() > 0 ? rolesString.substring(0, rolesString.length() - 1) : "";
    }

    private Dn createUserDn(String userName) throws LdapInvalidDnException {
        userName = this.escapeLDAPValue(userName);
        return new Dn(new String[]{"uid=" + userName + ",ou=people,c=mycountry"});
    }

    private Dn createRoleDn(String role) throws LdapInvalidDnException {
        role = this.escapeLDAPValue(role);
        return new Dn(new String[]{"cn=" + role + ",ou=roles,c=mycountry"});
    }

    public RolesListDto getAllRoles(String appId) {
        RolesListDto rolesListDto = new RolesListDto();
        EntryCursor rolesData = null;
        LdapConnection connection = null;
        try {
            connection = this.createAnonymousConnection();
            ArrayList<Role> roleDtos = new ArrayList<Role>();
            Dn searchBase = new Dn(new String[]{"ou=roles,c=mycountry"});
            String searchFilter = "(objectClass=organizationalRole)";
            rolesData = connection.search(searchBase, searchFilter, SearchScope.ONELEVEL, new String[0]);
            for (Entry entry : rolesData) {
                Role roleDto = new Role();
                roleDto.setRoleId(entry.get("cn").get().toString());
                roleDto.setRoleName(entry.get("cn").get().toString());
                roleDto.setRoleDescription(entry.get("description").get().toString());
                roleDtos.add(roleDto);
            }
            rolesListDto.setRoles(roleDtos);
            Iterator iterator = rolesListDto;
            return iterator;
        }
        catch (Exception e) {
            throw new AuthManagerException(LDAPErrorCode.LDAP_ROLES_REQUEST_ERROR.getErrorCode(), LDAPErrorCode.LDAP_ROLES_REQUEST_ERROR.getErrorMessage(), (Throwable)e);
        }
        finally {
            try {
                rolesData.close();
                connection.close();
            }
            catch (IOException e) {
                throw new AuthManagerException(LDAPErrorCode.LDAP_ROLES_REQUEST_ERROR.getErrorCode(), LDAPErrorCode.LDAP_ROLES_REQUEST_ERROR.getErrorMessage(), (Throwable)e);
            }
        }
    }

    public MosipUserListDto getListOfUsersDetails(List<String> users, String appId) throws Exception {
        try (LdapConnection connection = null;){
            MosipUserListDto userResponseDto = new MosipUserListDto();
            ArrayList<MosipUserDto> mosipUserDtos = new ArrayList<MosipUserDto>();
            connection = this.createAnonymousConnection();
            for (String user : users) {
                Dn userdn = this.createUserDn(user);
                MosipUserDto data = this.lookupUserDetails(userdn, connection);
                if (data == null) continue;
                mosipUserDtos.add(data);
            }
            userResponseDto.setMosipUserDtoList(mosipUserDtos);
            MosipUserListDto mosipUserListDto = userResponseDto;
            return mosipUserListDto;
        }
    }

    public MosipUserSaltListDto getAllUserDetailsWithSalt(List<String> userDetails, String appId) throws Exception {
        MosipUserSaltListDto mosipUserSaltList = new MosipUserSaltListDto();
        ArrayList<MosipUserSalt> mosipUserDtos = new ArrayList<MosipUserSalt>();
        try (LdapConnection connection = null;){
            connection = this.createAnonymousConnection();
            Dn searchBase = new Dn(new String[]{"ou=people,c=mycountry"});
            String searchFilter = "(&(objectClass=organizationalPerson)(objectClass=inetOrgPerson))";
            EntryCursor peoplesData = connection.search(searchBase, searchFilter, SearchScope.ONELEVEL, new String[0]);
            for (Entry entry : peoplesData) {
                PasswordDetails password;
                MosipUserSalt saltDetails = new MosipUserSalt();
                saltDetails.setUserId(entry.get("uid").get().toString());
                if (entry.get("userPassword") != null && (password = PasswordUtil.splitCredentials((byte[])entry.get("userPassword").get().getBytes())).getSalt() != null) {
                    saltDetails.setSalt(CryptoUtil.encodeBase64((byte[])password.getSalt()));
                }
                mosipUserDtos.add(saltDetails);
            }
        }
        mosipUserSaltList.setMosipUserSaltList(mosipUserDtos);
        return mosipUserSaltList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RIdDto getRidFromUserId(String userId, String appId) throws Exception {
        RIdDto ridDto = null;
        try (LdapConnection ldapConnection = null;){
            ldapConnection = this.createAnonymousConnection();
            Dn userdn = this.createUserDn(userId);
            MosipUserDto data = this.lookupUserDetails(userdn, ldapConnection);
            if (data == null) {
                throw new AuthManagerException(AuthErrorCode.USER_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.USER_VALIDATION_ERROR.getErrorMessage());
            }
            if (data.getRId() != null) {
                ridDto = new RIdDto();
                ridDto.setRId(data.getRId());
            }
        }
        return ridDto;
    }

    public AuthZResponseDto unBlockAccount(String userId) throws Exception {
        LdapContext context = null;
        AuthZResponseDto authZResponseDto = null;
        try {
            context = this.getContext();
            ModificationItem[] modItems = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("pwdAccountLockedTime")), new ModificationItem(3, new BasicAttribute("pwdFailureTime"))};
            userId = this.escapeLDAPValue(userId);
            context.modifyAttributes("uid=" + userId + ",ou=people,c=mycountry", modItems);
            authZResponseDto = new AuthZResponseDto();
            authZResponseDto.setMessage("Successfully Unblocked");
            authZResponseDto.setStatus("Success");
            this.closeContext(context);
        }
        catch (NamingException e) {
            this.closeContext(context);
            throw new AuthManagerException(AuthErrorCode.NAMING_EXCEPTION.getErrorCode(), AuthErrorCode.NAMING_EXCEPTION.getErrorMessage() + "" + e.getExplanation());
        }
        return authZResponseDto;
    }

    public AuthZResponseDto changePassword(PasswordDto passwordDto) {
        LdapContext ldapContext = null;
        AuthZResponseDto authZResponseDto = null;
        String mailId = null;
        String userId = null;
        try {
            ldapContext = this.getContext();
        }
        catch (NamingException e) {
            throw new AuthManagerException(AuthErrorCode.NAMING_EXCEPTION.getErrorCode(), AuthErrorCode.NAMING_EXCEPTION.getErrorMessage());
        }
        try {
            NamingEnumeration userDetailSearchResult = this.getUserDetailSearchResult(passwordDto.getUserId());
            while (userDetailSearchResult.hasMore()) {
                SearchResult searchObject = (SearchResult)userDetailSearchResult.next();
                mailId = (String)searchObject.getAttributes().get("mail").get();
                userId = (String)searchObject.getAttributes().get("uid").get();
            }
            String ldapPassword = this.getPassword(passwordDto.getUserId(), ldapContext);
            Objects.requireNonNull(ldapPassword);
            boolean isNotMatching = this.isNotAMatchWithUserOrEmail(userId, mailId, passwordDto.getNewPassword());
            this.validateOldPassword(passwordDto.getOldPassword(), ldapPassword);
            if (isNotMatching || passwordDto.getOldPassword().equals(passwordDto.getNewPassword())) {
                throw new AuthManagerException(AuthErrorCode.PASSWORD_POLICY_EXCEPTION.getErrorCode(), AuthErrorCode.PASSWORD_POLICY_EXCEPTION.getErrorMessage());
            }
            byte[] newUserPassword = PasswordUtil.createStoragePassword((byte[])passwordDto.getNewPassword().getBytes(), (LdapSecurityConstants)LdapSecurityConstants.getAlgorithm((String)passwordDto.getHashAlgo()));
            ModificationItem[] modItems = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("userPassword", newUserPassword))};
            String uid = this.escapeLDAPValue(passwordDto.getUserId());
            ldapContext.modifyAttributes("uid=" + uid + ",ou=people,c=mycountry", modItems);
            authZResponseDto = new AuthZResponseDto();
            authZResponseDto.setMessage("Successfully changed");
            authZResponseDto.setStatus("Success");
            this.closeContext(ldapContext);
        }
        catch (Exception e) {
            this.closeContext(ldapContext);
            throw new AuthManagerException(AuthErrorCode.SERVER_ERROR.getErrorCode(), AuthErrorCode.SERVER_ERROR.getErrorMessage() + " " + e.getCause());
        }
        return authZResponseDto;
    }

    public AuthZResponseDto resetPassword(PasswordDto passwordDto) {
        LdapContext ldapContext = null;
        AuthZResponseDto authZResponseDto = null;
        String mailId = null;
        String userId = null;
        try {
            ldapContext = this.getContext();
            NamingEnumeration userDetailSearchResult = this.getUserDetailSearchResult(passwordDto.getUserId());
            while (userDetailSearchResult.hasMore()) {
                SearchResult searchObject = (SearchResult)userDetailSearchResult.next();
                mailId = (String)searchObject.getAttributes().get("mail").get();
                userId = (String)searchObject.getAttributes().get("uid").get();
            }
            boolean isNotMatching = this.isNotAMatchWithUserOrEmail(userId, mailId, passwordDto.getNewPassword());
            if (isNotMatching) {
                throw new AuthManagerException(AuthErrorCode.PASSWORD_POLICY_EXCEPTION.getErrorCode(), AuthErrorCode.PASSWORD_POLICY_EXCEPTION.getErrorMessage());
            }
            byte[] newUserPassword = PasswordUtil.createStoragePassword((byte[])passwordDto.getNewPassword().getBytes(), (LdapSecurityConstants)LdapSecurityConstants.getAlgorithm((String)passwordDto.getHashAlgo()));
            ModificationItem[] modItems = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("userPassword", newUserPassword))};
            String uid = this.escapeLDAPValue(passwordDto.getUserId());
            ldapContext.modifyAttributes("uid=" + uid + ",ou=people,c=mycountry", modItems);
            authZResponseDto = new AuthZResponseDto();
            authZResponseDto.setMessage("Successfully the password has been reset");
            authZResponseDto.setStatus("Success");
            this.closeContext(ldapContext);
        }
        catch (LdapInvalidDnException ex) {
            this.closeContext(ldapContext);
            throw new AuthManagerException(AuthErrorCode.INVALID_DN.getErrorCode(), AuthErrorCode.INVALID_DN.getErrorMessage() + ex.getCause());
        }
        catch (NamingException ex) {
            this.closeContext(ldapContext);
            throw new AuthManagerException(AuthErrorCode.NAMING_EXCEPTION.getErrorCode(), AuthErrorCode.NAMING_EXCEPTION.getErrorMessage() + ex.getCause());
        }
        return authZResponseDto;
    }

    public UserNameDto getUserNameBasedOnMobileNumber(String mobileNumber) throws Exception {
        NamingEnumeration searchResult = this.getUserDetail(mobileNumber);
        UserNameDto userNameDto = new UserNameDto();
        if (!searchResult.hasMore()) {
            throw new AuthManagerException(AuthErrorCode.MOBILE_NOT_REGISTERED.getErrorCode(), AuthErrorCode.MOBILE_NOT_REGISTERED.getErrorMessage());
        }
        while (searchResult.hasMore()) {
            Attributes attributes = ((SearchResult)searchResult.next()).getAttributes();
            Attribute uid = attributes.get("uid");
            userNameDto.setUserName((String)uid.get());
        }
        return userNameDto;
    }

    private String getPassword(String userid, LdapContext ldapContext) throws Exception {
        String encryptedPassword = null;
        userid = this.escapeLDAPValue(userid);
        Dn searchBase = new Dn(new String[]{"uid=" + userid + ",ou=people,c=mycountry"});
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> searchResult = ldapContext.search(searchBase.getName(), "(&(objectClass=organizationalPerson)(objectClass=inetOrgPerson)(objectClass=person))", searchControls);
        while (searchResult.hasMore()) {
            SearchResult result = searchResult.next();
            byte[] encryptedPasswordBytes = (byte[])result.getAttributes().get("userPassword").get();
            encryptedPassword = new String(encryptedPasswordBytes);
        }
        return encryptedPassword;
    }

    private void validateOldPassword(String oldPassword, String hashedPassword) {
        boolean password = PasswordUtil.compareCredentials((byte[])oldPassword.getBytes(), (byte[])hashedPassword.getBytes());
        if (!password) {
            throw new AuthManagerException(AuthErrorCode.OLD_PASSWORD_NOT_MATCH.getErrorCode(), AuthErrorCode.OLD_PASSWORD_NOT_MATCH.getErrorMessage());
        }
    }

    private boolean isNotAMatchWithUserOrEmail(String userId, String email, String password) {
        return password.contains(userId) || password.contains(email);
    }

    public MosipUserDto registerUser(UserRegistrationRequestDto userCreationRequestDto) {
        Dn userDn = null;
        DirContext context = null;
        try {
            context = this.getDirContext();
            userDn = this.createUserDn(userCreationRequestDto.getUserName());
            ArrayList<BasicAttribute> attributes = new ArrayList<BasicAttribute>();
            attributes.add(new BasicAttribute("cn", this.escapeLDAPValue(userCreationRequestDto.getUserName())));
            attributes.add(new BasicAttribute("sn", this.escapeLDAPValue(userCreationRequestDto.getUserName())));
            attributes.add(new BasicAttribute("mail", this.escapeLDAPValue(userCreationRequestDto.getEmailID())));
            attributes.add(new BasicAttribute("mobile", this.escapeLDAPValue(userCreationRequestDto.getContactNo())));
            attributes.add(new BasicAttribute("dob", this.escapeLDAPValue(userCreationRequestDto.getDateOfBirth().toString())));
            attributes.add(new BasicAttribute("firstName", this.escapeLDAPValue(userCreationRequestDto.getFirstName())));
            attributes.add(new BasicAttribute("lastName", this.escapeLDAPValue(userCreationRequestDto.getLastName())));
            attributes.add(new BasicAttribute("genderCode", this.escapeLDAPValue(userCreationRequestDto.getGender())));
            attributes.add(new BasicAttribute("isActive", "false"));
            BasicAttribute oc = new BasicAttribute("objectClass");
            oc.add("inetOrgPerson");
            oc.add("organizationalPerson");
            oc.add("person");
            oc.add("top");
            oc.add("userDetails");
            attributes.add(oc);
            BasicAttributes entry = new BasicAttributes();
            attributes.parallelStream().forEach(entry::put);
            context.createSubcontext(userDn.getName(), (Attributes)entry);
        }
        catch (NameAlreadyBoundException exception) {
            throw new AuthManagerException(AuthErrorCode.USER_ALREADY_EXIST.getErrorCode(), AuthErrorCode.USER_ALREADY_EXIST.getErrorMessage());
        }
        catch (NameNotFoundException exception) {
            this.rollbackUser(userDn, context);
            throw new AuthManagerException(AuthErrorCode.ROLE_NOT_FOUND.getErrorCode(), AuthErrorCode.ROLE_NOT_FOUND.getErrorMessage() + exception.getMessage());
        }
        catch (NamingException exception) {
            throw new AuthManagerException(AuthErrorCode.USER_CREATE_EXCEPTION.getErrorCode(), AuthErrorCode.USER_CREATE_EXCEPTION.getErrorMessage() + exception.getMessage());
        }
        catch (LdapInvalidDnException exception) {
            throw new AuthManagerException(AuthErrorCode.INVALID_DN.getErrorCode(), AuthErrorCode.INVALID_DN.getErrorMessage() + exception.getMessage());
        }
        try {
            Dn roleOccupant = this.createRoleDn(userCreationRequestDto.getRole());
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("roleOccupant", userDn.getName()))};
            context.modifyAttributes(roleOccupant.getName(), mods);
        }
        catch (NameAlreadyBoundException exception) {
            this.rollbackUser(userDn, context);
            throw new AuthManagerException(AuthErrorCode.USER_ALREADY_EXIST.getErrorCode(), AuthErrorCode.USER_ALREADY_EXIST.getErrorMessage());
        }
        catch (NameNotFoundException exception) {
            this.rollbackUser(userDn, context);
            throw new AuthManagerException(AuthErrorCode.ROLE_NOT_FOUND.getErrorCode(), AuthErrorCode.ROLE_NOT_FOUND.getErrorMessage() + exception.getMessage());
        }
        catch (NamingException exception) {
            this.rollbackUser(userDn, context);
            throw new AuthManagerException(AuthErrorCode.USER_CREATE_EXCEPTION.getErrorCode(), AuthErrorCode.USER_CREATE_EXCEPTION.getErrorMessage() + exception.getMessage());
        }
        catch (LdapInvalidDnException exception) {
            this.rollbackUser(userDn, context);
            throw new AuthManagerException(AuthErrorCode.INVALID_DN.getErrorCode(), AuthErrorCode.INVALID_DN.getErrorMessage() + exception.getMessage());
        }
        MosipUserDto dto = new MosipUserDto();
        dto.setUserId(userCreationRequestDto.getUserName());
        return dto;
    }

    private DirContext getDirContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapProviderURL);
        env.put("java.naming.security.principal", this.ldapSecurityPrincipal);
        env.put("java.naming.security.credentials", this.ldapSecurityCredentials);
        return new InitialDirContext(env);
    }

    public UserPasswordResponseDto addPassword(UserPasswordRequestDto userPasswordRequestDto) {
        Dn userDn = null;
        InitialDirContext context = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapProviderURL);
        env.put("java.naming.security.principal", this.ldapSecurityPrincipal);
        env.put("java.naming.security.credentials", this.ldapSecurityCredentials);
        try {
            userDn = this.createUserDn(userPasswordRequestDto.getUserName());
            context = new InitialDirContext(env);
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("rid", userPasswordRequestDto.getRid())), new ModificationItem(1, new BasicAttribute("userPassword", userPasswordRequestDto.getPassword())), new ModificationItem(2, new BasicAttribute("isActive", "true"))};
            context.modifyAttributes(userDn.getName(), mods);
        }
        catch (NamingException exception) {
            throw new AuthManagerException(AuthErrorCode.USER_PASSWORD_EXCEPTION.getErrorCode(), AuthErrorCode.USER_PASSWORD_EXCEPTION.getErrorMessage() + exception.getMessage());
        }
        catch (LdapInvalidDnException exception) {
            throw new AuthManagerException(AuthErrorCode.INVALID_DN.getErrorCode(), AuthErrorCode.INVALID_DN.getErrorMessage() + exception.getMessage());
        }
        return new UserPasswordResponseDto(userPasswordRequestDto.getUserName());
    }

    private void rollbackUser(Dn userDn, DirContext context) {
        try {
            context.destroySubcontext(userDn.getName());
        }
        catch (NamingException exception) {
            throw new AuthManagerException(AuthErrorCode.ROLLBACK_USER_EXCEPTION.getErrorCode(), AuthErrorCode.ROLLBACK_USER_EXCEPTION.getErrorMessage());
        }
    }

    public MosipUserDto getUserRoleByUserId(String username) throws Exception {
        MosipUserDto data = null;
        try (LdapConnection ldapConnection = null;){
            ldapConnection = this.createAnonymousConnection();
            Dn userdn = this.createUserDn(username);
            data = this.lookupUserDetails(userdn, ldapConnection);
            if (data == null) {
                throw new AuthManagerException(AuthErrorCode.USER_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.USER_VALIDATION_ERROR.getErrorMessage());
            }
        }
        return data;
    }

    public MosipUserDto getUserDetailBasedonMobileNumber(String mobileNumber) throws Exception {
        MosipUserDto mosipUserDto = new MosipUserDto();
        try {
            if (!this.IsValidPhoneNumber(mobileNumber)) {
                throw new LdapInvalidDnException("Invalid phone number");
            }
            LdapContext context = this.getContext();
            NamingEnumeration searchResult = this.getUserDetail(mobileNumber);
            while (searchResult.hasMore()) {
                Attributes attributes = ((SearchResult)searchResult.next()).getAttributes();
                mosipUserDto.setUserId((String)attributes.get("uid").get());
                String rolesAsString = this.getRolesBasedOnUid((String)attributes.get("uid").get());
                mosipUserDto.setMail((String)attributes.get("mail").get());
                mosipUserDto.setMobile((String)attributes.get("mobile").get());
                mosipUserDto.setName((String)attributes.get("cn").get());
                mosipUserDto.setRole(rolesAsString);
                context.close();
            }
        }
        catch (NamingException e) {
            throw new AuthManagerException(AuthErrorCode.NAMING_EXCEPTION.getErrorCode(), AuthErrorCode.NAMING_EXCEPTION.getErrorMessage());
        }
        catch (LdapInvalidDnException e) {
            throw new AuthManagerException(AuthErrorCode.NAMING_EXCEPTION.getErrorCode(), AuthErrorCode.NAMING_EXCEPTION.getErrorMessage() + " " + e.getCause());
        }
        return mosipUserDto;
    }

    private NamingEnumeration<SearchResult> getUserDetail(String mobileNumber) throws LdapInvalidDnException, NamingException {
        if (!this.IsValidPhoneNumber(mobileNumber)) {
            throw new LdapInvalidDnException("Invalid phone number");
        }
        Dn searchBase = new Dn(new String[]{"ou=people,c=mycountry"});
        String searchFilter = "(&(objectClass=organizationalPerson)(objectClass=inetOrgPerson)(objectClass=person)(mobile=" + mobileNumber + "))";
        LdapContext context = this.getContext();
        NamingEnumeration<SearchResult> searchResult = context.search(searchBase.getName(), searchFilter, new SearchControls());
        if (!searchResult.hasMore()) {
            throw new AuthManagerException("ADMN-ACM-MOB-NOT-FOUND", "Mobile is registered/not present");
        }
        context.close();
        return searchResult;
    }

    public ValidationResponseDto validateUserName(String userId) {
        ValidationResponseDto validationResponseDto = new ValidationResponseDto();
        try {
            NamingEnumeration searchResult = this.getUserDetailSearchResult(userId);
            while (searchResult.hasMore()) {
                Attributes attributes = ((SearchResult)searchResult.next()).getAttributes();
                if (attributes.get("isActive") == null) {
                    throw new AuthManagerException(AuthErrorCode.IS_ACTIVE_FLAG_NOT_FOUND.getErrorCode(), AuthErrorCode.IS_ACTIVE_FLAG_NOT_FOUND.getErrorMessage());
                }
                String isActive = (String)attributes.get("isActive").get();
                if (isActive.equalsIgnoreCase("true")) {
                    validationResponseDto.setStatus("VALID");
                    continue;
                }
                validationResponseDto.setStatus("INVALID");
            }
        }
        catch (NamingException e) {
            throw new AuthManagerException(AuthErrorCode.NAMING_EXCEPTION.getErrorCode(), AuthErrorCode.NAMING_EXCEPTION.getErrorMessage());
        }
        catch (LdapInvalidDnException e) {
            throw new AuthManagerException(AuthErrorCode.INVALID_DN.getErrorCode(), AuthErrorCode.INVALID_DN.getErrorMessage());
        }
        return validationResponseDto;
    }

    private NamingEnumeration<SearchResult> getUserDetailSearchResult(String userId) throws NamingException, LdapInvalidDnException {
        LdapContext context = this.getContext();
        userId = this.escapeLDAPValue(userId);
        Dn searchBase = new Dn(new String[]{"uid=" + userId + ",ou=people,c=mycountry"});
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> searchResult = context.search(searchBase.getName(), "(&(objectClass=organizationalPerson)(objectClass=inetOrgPerson)(objectClass=person))", searchControls);
        if (!searchResult.hasMore()) {
            throw new AuthManagerException(AuthErrorCode.USER_NOT_FOUND.getErrorCode(), AuthErrorCode.USER_NOT_FOUND.getErrorMessage());
        }
        context.close();
        return searchResult;
    }

    private void closeContext(LdapContext context) {
        try {
            Objects.requireNonNull(context, "context not initialized");
            context.close();
        }
        catch (NamingException e) {
            throw new AuthManagerException(AuthErrorCode.NAMING_EXCEPTION.getErrorCode(), AuthErrorCode.NAMING_EXCEPTION.getErrorMessage());
        }
    }

    public UserDetailsResponseDto getUserDetailBasedOnUid(List<String> userIds) {
        UserDetailsDto userDetailsDto = null;
        ArrayList<UserDetailsDto> userDetails = new ArrayList<UserDetailsDto>();
        UserDetailsResponseDto userDetailsResponseDto = new UserDetailsResponseDto();
        try {
            for (String userId : userIds) {
                NamingEnumeration searchResult = this.getSearchResultBasedOnId(userId);
                if (!searchResult.hasMore()) continue;
                SearchResult result = (SearchResult)searchResult.next();
                userDetailsDto = this.setUserDetail(result);
                userDetailsDto.setUserId(userId);
                String rolesAsString = this.getRolesBasedOnUid(userId);
                userDetailsDto.setRole(rolesAsString);
                userDetails.add(userDetailsDto);
            }
        }
        catch (NamingException e) {
            throw new AuthManagerException(AuthErrorCode.NAMING_EXCEPTION.getErrorCode(), AuthErrorCode.NAMING_EXCEPTION.getErrorMessage() + "" + e.getCause());
        }
        catch (LdapInvalidDnException e) {
            throw new AuthManagerException(AuthErrorCode.INVALID_DN.getErrorCode(), AuthErrorCode.INVALID_DN.getErrorMessage() + " " + e.getCause());
        }
        userDetailsResponseDto.setUserDetails(userDetails);
        return userDetailsResponseDto;
    }

    private NamingEnumeration<SearchResult> getSearchResultBasedOnId(String userId) throws NamingException, LdapInvalidDnException {
        LdapContext context = this.getContext();
        userId = this.escapeLDAPValue(userId);
        Dn searchBase = new Dn(new String[]{"uid=" + userId + ",ou=people,c=mycountry"});
        SearchControls searchControls = new SearchControls();
        NamingEnumeration<SearchResult> searchResult = null;
        searchControls.setSearchScope(2);
        searchResult = context.search(searchBase.getName(), "(&(objectClass=organizationalPerson)(objectClass=inetOrgPerson)(objectClass=person))", searchControls);
        context.close();
        return searchResult;
    }

    private UserDetailsDto setUserDetail(SearchResult result) throws NamingException {
        UserDetailsDto userDetailsDto = new UserDetailsDto();
        if (result.getAttributes().get("userPassword") != null) {
            userDetailsDto.setUserPassword((byte[])result.getAttributes().get("userPassword").get());
        }
        userDetailsDto.setMobile((String)result.getAttributes().get("mobile").get());
        userDetailsDto.setMail((String)result.getAttributes().get("mail").get());
        userDetailsDto.setName((String)result.getAttributes().get("cn").get());
        if (result.getAttributes().get("firstName") != null) {
            userDetailsDto.setFirstName((String)result.getAttributes().get("firstName").get());
        }
        if (result.getAttributes().get("lastName") != null) {
            userDetailsDto.setLastName((String)result.getAttributes().get("firstName").get());
        }
        if (result.getAttributes().get("genderCode") != null) {
            userDetailsDto.setGender((String)result.getAttributes().get("genderCode").get());
        }
        if (result.getAttributes().get("isActive") != null) {
            userDetailsDto.setActive(Boolean.valueOf((String)result.getAttributes().get("isActive").get()).booleanValue());
        }
        if (result.getAttributes().get("dob") != null) {
            String dob = (String)result.getAttributes().get("dob").get();
            LocalDate dobInLocalDate = LocalDate.parse(dob);
            userDetailsDto.setDateOfBirth(dobInLocalDate);
        }
        if (result.getAttributes().get("rid") != null) {
            userDetailsDto.setRId((String)result.getAttributes().get("rid").get());
        }
        return userDetailsDto;
    }

    public Map<Object, Object> getPagenatedMap(List<UserDetailsDto> list, int pageSize) {
        return IntStream.iterate(0, i -> i + pageSize).limit((list.size() + pageSize - 1) / pageSize).boxed().collect(Collectors.toMap(i -> i / pageSize, i -> list.subList((int)i, Math.min(i + pageSize, list.size()))));
    }

    private String getRolesBasedOnUid(String uid) throws LdapInvalidDnException, NamingException {
        LdapContext context = this.getContext();
        Dn searchBase = new Dn(new String[]{"ou=roles,c=mycountry"});
        uid = this.escapeLDAPValue(uid);
        String searchFilter = "(&(objectClass=organizationalRole)(roleOccupant=uid=" + uid + ",ou=people,c=mycountry))";
        NamingEnumeration<SearchResult> searchResultRoles = context.search(searchBase.getName(), searchFilter, new SearchControls());
        HashSet<String> roles = new HashSet<String>();
        while (searchResultRoles.hasMore()) {
            Attributes attributeRoles = searchResultRoles.next().getAttributes();
            roles.add((String)attributeRoles.get("cn").get());
        }
        context.close();
        try {
            return this.convertRolesToString(roles);
        }
        catch (Exception e) {
            throw new AuthManagerException(AuthErrorCode.RUNTIME_EXCEPTION.getErrorCode(), AuthErrorCode.RUNTIME_EXCEPTION.getErrorMessage());
        }
    }

    private boolean IsValidPhoneNumber(String mobileNumber) {
        Pattern phonePattern = Pattern.compile("^\\+(?:[0-9] ?){6,14}[0-9]$");
        Matcher phoneMatcher = phonePattern.matcher(mobileNumber);
        return phoneMatcher.matches();
    }

    private String escapeLDAPValue(String ldapString) {
        if (null == ldapString) {
            return "";
        }
        try {
            StringBuilder finalLdapString = new StringBuilder(ldapString.length());
            for (byte ldapCharacter : ldapString.getBytes("UTF-8")) {
                if (ldapCharacter == 92) {
                    finalLdapString.append("\\5c");
                    continue;
                }
                if (ldapCharacter == 42) {
                    finalLdapString.append("\\2a");
                    continue;
                }
                if (ldapCharacter == 40) {
                    finalLdapString.append("\\28");
                    continue;
                }
                if (ldapCharacter == 41) {
                    finalLdapString.append("\\29");
                    continue;
                }
                if (ldapCharacter == 0) {
                    finalLdapString.append("\\00");
                    continue;
                }
                if ((ldapCharacter & 0xFF) > 127) {
                    finalLdapString.append("\\").append(this.to2CharHexString(ldapCharacter & 0xFF));
                    continue;
                }
                finalLdapString.append((char)ldapCharacter);
            }
            return finalLdapString.toString();
        }
        catch (Exception ex) {
            LOGGER.warn("Invalid ldap string " + ldapString + " so sending back empty string ");
            return "";
        }
    }

    private String to2CharHexString(int hexValue) {
        String hexCharacter = Integer.toHexString(hexValue & 0xFF);
        if (hexCharacter.length() == 1) {
            return "0" + hexCharacter;
        }
        return hexCharacter;
    }
}

