/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureException;
import io.mosip.kernel.auth.config.MosipEnvironment;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.dto.MosipUser;
import io.mosip.kernel.auth.dto.MosipUserDto;
import io.mosip.kernel.auth.dto.MosipUserToken;
import io.mosip.kernel.auth.dto.MosipUserTokenDto;
import io.mosip.kernel.auth.dto.RealmAccessDto;
import io.mosip.kernel.auth.exception.AuthManagerException;
import io.mosip.kernel.auth.service.TokenService;
import io.mosip.kernel.core.util.DateUtils;
import java.time.ZoneOffset;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.stereotype.Component;

@Component
public class TokenValidator {
    @Autowired
    MosipEnvironment mosipEnvironment;
    @Autowired
    TokenService customTokenServices;

    private Boolean validateOtpDetails(Claims claims) {
        if (claims.get((Object)"isOtpRequired") == null) {
            return true;
        }
        Boolean isOtpVerified = (Boolean)claims.get((Object)"isOtpVerified");
        Boolean isOtpRequired = (Boolean)claims.get((Object)"isOtpRequired");
        if (isOtpRequired.booleanValue() && !isOtpVerified.booleanValue()) {
            return false;
        }
        return true;
    }

    private MosipUser buildMosipUser(Claims claims) {
        return new MosipUser(claims.getSubject(), (String)claims.get((Object)"mobile"), (String)claims.get((Object)"mail"), (String)claims.get((Object)"role"));
    }

    public MosipUserDto getAdminClaims(String token) {
        DecodedJWT decodedJWT = JWT.decode((String)token);
        Claim realmAccess = decodedJWT.getClaim("realm_access");
        RealmAccessDto access = (RealmAccessDto)realmAccess.as(RealmAccessDto.class);
        String[] roles = access.getRoles();
        StringBuilder builder = new StringBuilder();
        for (String r : roles) {
            builder.append(r);
            builder.append(";");
        }
        MosipUserDto dto = new MosipUserDto();
        dto.setUserId(decodedJWT.getClaim("preferred_username").asString());
        dto.setMail(decodedJWT.getClaim("email").asString());
        dto.setMobile(decodedJWT.getClaim("contactno").asString());
        dto.setName(decodedJWT.getClaim("preferred_username").asString());
        dto.setRId(decodedJWT.getClaim("rid").asString());
        dto.setRole(builder.toString());
        return dto;
    }

    public boolean isExpired(String token) {
        DecodedJWT decodedJWT = JWT.decode((String)token);
        long expiryEpochTime = decodedJWT.getClaim("exp").asLong();
        long currentEpoch = DateUtils.getUTCCurrentDateTime().toEpochSecond(ZoneOffset.UTC);
        return currentEpoch > expiryEpochTime;
    }

    private Claims getClaims(String token) throws Exception {
        String token_base = this.mosipEnvironment.getTokenBase();
        String secret = this.mosipEnvironment.getJwtSecret();
        Claims claims = null;
        if (token == null || !token.startsWith(token_base)) {
            throw new NonceExpiredException("Invalid Token");
        }
        try {
            claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token.substring(token_base.length())).getBody();
        }
        catch (SignatureException e) {
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage());
        }
        catch (JwtException e) {
            if (e instanceof ExpiredJwtException) {
                System.out.println("Token expired message " + e.getMessage() + " Token " + token);
                throw new AuthManagerException(AuthErrorCode.TOKEN_EXPIRED.getErrorCode(), AuthErrorCode.TOKEN_EXPIRED.getErrorMessage());
            }
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage());
        }
        return claims;
    }

    public MosipUserToken validateForOtpVerification(String token) throws Exception {
        Claims claims = this.getClaims(token);
        Boolean isOtpRequired = (Boolean)claims.get((Object)"isOtpRequired");
        if (isOtpRequired.booleanValue()) {
            MosipUser mosipUser = this.buildMosipUser(claims);
            return new MosipUserToken(mosipUser, token);
        }
        throw new AuthManagerException(AuthErrorCode.INVALID_TOKEN.getErrorCode(), AuthErrorCode.INVALID_TOKEN.getErrorMessage());
    }

    public MosipUserToken basicValidate(String token) throws Exception {
        Claims claims = this.getClaims(token);
        Boolean isOtpValid = this.validateOtpDetails(claims);
        if (isOtpValid.booleanValue()) {
            MosipUser mosipUser = this.buildMosipUser(claims);
            return new MosipUserToken(mosipUser, token);
        }
        throw new AuthManagerException(AuthErrorCode.INVALID_TOKEN.getErrorCode(), AuthErrorCode.INVALID_TOKEN.getErrorMessage());
    }

    public MosipUserTokenDto validateToken(String token) throws Exception {
        Claims claims = this.getClaims(token);
        MosipUserDto mosipUserDto = this.buildDto(claims);
        return new MosipUserTokenDto(mosipUserDto, token, null, 0L, null, null);
    }

    private MosipUserDto buildDto(Claims claims) {
        MosipUserDto mosipUserDto = new MosipUserDto();
        mosipUserDto.setUserId(claims.getSubject());
        mosipUserDto.setName((String)claims.get((Object)"name"));
        mosipUserDto.setRole((String)claims.get((Object)"role"));
        mosipUserDto.setMail((String)claims.get((Object)"mail"));
        mosipUserDto.setMobile((String)claims.get((Object)"mobile"));
        mosipUserDto.setRId((String)claims.get((Object)"rId"));
        return mosipUserDto;
    }

    public MosipUserTokenDto validateOTP(String otp) throws Exception {
        Claims claims = this.getClaims(otp);
        Boolean isOtpRequired = (Boolean)claims.get((Object)"isOtpRequired");
        if (isOtpRequired.booleanValue()) {
            MosipUserDto mosipUserDto = this.buildDto(claims);
            return new MosipUserTokenDto(mosipUserDto, otp, null, 0L, null, null);
        }
        throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), AuthErrorCode.UNAUTHORIZED.getErrorMessage());
    }

    public boolean validateExpiry(String token) throws Exception {
        Claims claims = this.getClaims(token);
        if (claims != null) {
            Integer expTime = (Integer)claims.get((Object)"exp");
            long currentTime = new Date().getTime();
            long exp = expTime.longValue() * 1000L;
            if (expTime != 0 && currentTime < exp) {
                return true;
            }
        }
        return false;
    }
}

