/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.mosip.kernel.auth.config.MosipEnvironment;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.dto.BasicTokenDto;
import io.mosip.kernel.auth.dto.MosipUserDto;
import io.mosip.kernel.auth.dto.TimeToken;
import io.mosip.kernel.auth.exception.AuthManagerException;
import java.time.Instant;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenGenerator {
    @Autowired
    MosipEnvironment mosipEnvironment;

    private Claims getBasicClaims(MosipUserDto mosipUser) {
        Claims claims = Jwts.claims().setSubject(mosipUser.getUserId());
        claims.put((Object)"mobile", (Object)mosipUser.getMobile());
        claims.put((Object)"mail", (Object)mosipUser.getMail());
        claims.put((Object)"role", (Object)mosipUser.getRole());
        claims.put((Object)"name", (Object)mosipUser.getName());
        claims.put((Object)"rId", (Object)mosipUser.getRId());
        return claims;
    }

    private String buildToken(Claims claims) {
        String secret = this.mosipEnvironment.getJwtSecret();
        String token_base = this.mosipEnvironment.getTokenBase();
        int token_expiry = this.mosipEnvironment.getTokenExpiry();
        long currentTimeInMs = System.currentTimeMillis();
        Date currentDate = new Date(currentTimeInMs);
        JwtBuilder builder = Jwts.builder().setClaims(claims).setIssuedAt(currentDate).signWith(SignatureAlgorithm.HS512, secret);
        if (token_expiry >= 0) {
            long expTimeInMs = currentTimeInMs + (long)token_expiry;
            builder.setExpiration(new Date(expTimeInMs));
        }
        return token_base.concat(builder.compact());
    }

    public String generateForOtp(MosipUserDto mosipUser, Boolean isOtpVerifiedYet) {
        Claims claims = this.getBasicClaims(mosipUser);
        claims.put((Object)"isOtpRequired", (Object)true);
        claims.put((Object)"isOtpVerified", (Object)isOtpVerifiedYet);
        return this.buildToken(claims);
    }

    public String refreshTokenForOTP(MosipUserDto mosipUser) {
        Claims claims = this.getBasicClaims(mosipUser);
        claims.put((Object)"isOtpRequired", (Object)true);
        claims.put((Object)"isOtpVerified", (Object)true);
        return this.buildRefreshTokenOTP(claims);
    }

    private String buildRefreshTokenOTP(Claims claims) {
        String secret = this.mosipEnvironment.getJwtSecret();
        String token_base = this.mosipEnvironment.getTokenBase();
        long token_expiry = this.mosipEnvironment.getRefreshTokenExpiry();
        long currentTimeInMs = System.currentTimeMillis();
        Date currentDate = new Date(currentTimeInMs);
        JwtBuilder builder = Jwts.builder().setClaims(claims).setIssuedAt(currentDate).signWith(SignatureAlgorithm.HS512, secret);
        if (token_expiry >= 0L) {
            long expTimeInMs = currentTimeInMs + token_expiry;
            builder.setExpiration(new Date(expTimeInMs));
        }
        return token_base.concat(builder.compact());
    }

    public BasicTokenDto basicGenerate(MosipUserDto mosipUser) {
        BasicTokenDto basicTokenDto = new BasicTokenDto();
        Claims claims = Jwts.claims().setSubject(mosipUser.getUserId());
        claims.put((Object)"mobile", (Object)mosipUser.getMobile());
        claims.put((Object)"mail", (Object)mosipUser.getMail());
        claims.put((Object)"role", (Object)mosipUser.getRole());
        claims.put((Object)"lang", (Object)mosipUser.getLangCode());
        claims.put((Object)"name", (Object)mosipUser.getName());
        claims.put((Object)"rId", (Object)mosipUser.getRId());
        TimeToken token = this.getToken(claims);
        basicTokenDto.setAuthToken(token.getToken());
        basicTokenDto.setExpiryTime(token.getExpTime());
        return basicTokenDto;
    }

    public BasicTokenDto basicGenerateOTPToken(MosipUserDto mosipUser, boolean otpVerified) {
        BasicTokenDto basicTokenDto = new BasicTokenDto();
        Claims claims = Jwts.claims().setSubject(mosipUser.getUserId());
        claims.put((Object)"mobile", (Object)mosipUser.getMobile());
        claims.put((Object)"mail", (Object)mosipUser.getMail());
        claims.put((Object)"role", (Object)mosipUser.getRole());
        claims.put((Object)"lang", (Object)mosipUser.getLangCode());
        claims.put((Object)"name", (Object)mosipUser.getName());
        claims.put((Object)"rId", (Object)mosipUser.getRId());
        claims.put((Object)"isOtpRequired", (Object)true);
        claims.put((Object)"isOtpVerified", (Object)otpVerified);
        TimeToken token = this.getToken(claims);
        basicTokenDto.setAuthToken(token.getToken());
        basicTokenDto.setExpiryTime(token.getExpTime());
        return basicTokenDto;
    }

    private TimeToken getToken(Claims claims) {
        TimeToken timeToken = new TimeToken();
        long exptime = 0L;
        String secret = this.mosipEnvironment.getJwtSecret();
        String token_base = this.mosipEnvironment.getTokenBase();
        int token_expiry = this.mosipEnvironment.getTokenExpiry();
        long currentTimeInMs = Instant.now().toEpochMilli();
        Date currentDate = new Date(currentTimeInMs);
        JwtBuilder builder = Jwts.builder().setClaims(claims).setIssuedAt(currentDate).signWith(SignatureAlgorithm.HS512, secret);
        if (token_expiry >= 0) {
            exptime = currentTimeInMs + (long)token_expiry;
            builder.setExpiration(new Date(exptime));
        }
        timeToken.setToken(token_base.concat(builder.compact()));
        timeToken.setExpTime(exptime);
        return timeToken;
    }

    public String refreshToken(MosipUserDto mosipUser) {
        Claims claims = Jwts.claims().setSubject(mosipUser.getUserId());
        claims.put((Object)"mobile", (Object)mosipUser.getMobile());
        claims.put((Object)"mail", (Object)mosipUser.getMail());
        claims.put((Object)"role", (Object)mosipUser.getRole());
        claims.put((Object)"lang", (Object)mosipUser.getLangCode());
        claims.put((Object)"name", (Object)mosipUser.getName());
        return this.buildRefreshToken(claims);
    }

    private String buildRefreshToken(Claims claims) {
        String secret = this.mosipEnvironment.getJwtSecret();
        String token_base = this.mosipEnvironment.getTokenBase();
        long token_expiry = this.mosipEnvironment.getRefreshTokenExpiry();
        long currentTimeInMs = System.currentTimeMillis();
        Date currentDate = new Date(currentTimeInMs);
        JwtBuilder builder = Jwts.builder().setClaims(claims).setIssuedAt(currentDate).signWith(SignatureAlgorithm.HS512, secret);
        if (token_expiry >= 0L) {
            long expTimeInMs = currentTimeInMs + token_expiry;
            builder.setExpiration(new Date(expTimeInMs));
        }
        return token_base.concat(builder.compact());
    }

    public TimeToken generateNewToken(String existingToken) {
        Claims claims = this.getClaims(existingToken);
        return this.getToken(claims);
    }

    private Claims getClaims(String token) {
        String token_base = this.mosipEnvironment.getTokenBase();
        String secret = this.mosipEnvironment.getJwtSecret();
        if (token == null || !token.startsWith(token_base)) {
            throw new AuthManagerException(AuthErrorCode.INVALID_TOKEN.getErrorCode(), AuthErrorCode.INVALID_TOKEN.getErrorMessage());
        }
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token.substring(token_base.length())).getBody();
            return claims;
        }
        catch (Exception e) {
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), e.getMessage(), (Throwable)e);
        }
    }
}

