/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.auth.adapter.exception.AuthNException;
import io.mosip.kernel.auth.adapter.exception.AuthZException;
import io.mosip.kernel.auth.config.MosipEnvironment;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.constant.OTPErrorCode;
import io.mosip.kernel.auth.dto.otp.OtpTemplateDto;
import io.mosip.kernel.auth.dto.otp.OtpTemplateResponseDto;
import io.mosip.kernel.auth.dto.otp.OtpUser;
import io.mosip.kernel.auth.dto.otp.email.OTPEmailTemplate;
import io.mosip.kernel.auth.exception.AuthManagerException;
import io.mosip.kernel.auth.exception.AuthManagerServiceException;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.templatemanager.spi.TemplateManager;
import io.mosip.kernel.templatemanager.velocity.builder.TemplateManagerBuilderImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class TemplateUtil {
    private TemplateManager templateManager;
    @Autowired
    MosipEnvironment mosipEnvironment;
    @Autowired
    Environment environment;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private ObjectMapper mapper;
    private static final String MOSIP_NOTIFICATION_LANGUAGE_TYPE = "mosip.notification.language-type";
    public static final String MOSIP_NOTIFICATIONTYPE = "mosip.notificationtype";
    private static final String ENV_PRIMARY_LANGUAGE = "mosip.primary-language";
    private static final String ENV_SECONDARY_LANGUAGE = "mosip.secondary-language";
    private static final String BOTH = "BOTH";
    private static final String PRIMARY = "PRIMARY";
    private static final String SECONDARY = "SECONDARY";

    @PostConstruct
    private void loadTemplateManager() {
        this.templateManager = new TemplateManagerBuilderImpl().build();
    }

    public OTPEmailTemplate getEmailTemplate(String otp, OtpUser otpUser, String token) {
        OTPEmailTemplate otpEmailTemplate = null;
        String primaryLanguage = null;
        String secondaryLanguage = null;
        if (BOTH.equals(this.environment.getProperty(MOSIP_NOTIFICATION_LANGUAGE_TYPE))) {
            otpEmailTemplate = new OTPEmailTemplate();
            primaryLanguage = this.environment.getProperty(ENV_PRIMARY_LANGUAGE);
            if (primaryLanguage == null) {
                throw new AuthManagerException(OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorCode(), OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorMessage());
            }
            secondaryLanguage = this.environment.getProperty(ENV_SECONDARY_LANGUAGE);
            if (secondaryLanguage == null) {
                throw new AuthManagerException(OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorCode(), OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorMessage());
            }
            String emailSubject = this.getEmailData(otpUser, "email-subject-template", token, primaryLanguage, secondaryLanguage);
            String mergedEmailSubject = this.getMergedEmailContent(otp, emailSubject, otpUser.getTemplateVariables());
            String emailContent = this.getEmailData(otpUser, "email-content-template", token, primaryLanguage, secondaryLanguage);
            String mergedEmailContent = this.getMergedEmailContent(otp, emailContent, otpUser.getTemplateVariables());
            otpEmailTemplate.setEmailSubject(mergedEmailSubject);
            otpEmailTemplate.setEmailContent(mergedEmailContent);
            return otpEmailTemplate;
        }
        if (PRIMARY.equals(this.environment.getProperty(MOSIP_NOTIFICATION_LANGUAGE_TYPE))) {
            otpEmailTemplate = new OTPEmailTemplate();
            primaryLanguage = this.environment.getProperty(ENV_PRIMARY_LANGUAGE);
            if (primaryLanguage == null) {
                throw new AuthManagerException(OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorCode(), OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorMessage());
            }
            String emailSubject = this.getEmailData(otpUser, "email-subject-template", token, primaryLanguage, secondaryLanguage);
            String mergedEmailSubject = this.getMergedEmailContent(otp, emailSubject, otpUser.getTemplateVariables());
            String emailContent = this.getEmailData(otpUser, "email-content-template", token, primaryLanguage, secondaryLanguage);
            String mergedEmailContent = this.getMergedEmailContent(otp, emailContent, otpUser.getTemplateVariables());
            otpEmailTemplate.setEmailSubject(mergedEmailSubject);
            otpEmailTemplate.setEmailContent(mergedEmailContent);
            return otpEmailTemplate;
        }
        if (SECONDARY.equals(this.environment.getProperty(MOSIP_NOTIFICATION_LANGUAGE_TYPE))) {
            otpEmailTemplate = new OTPEmailTemplate();
            primaryLanguage = this.environment.getProperty(ENV_SECONDARY_LANGUAGE);
            if (primaryLanguage == null) {
                throw new AuthManagerException(OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorCode(), OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorMessage());
            }
            String emailSubject = this.getEmailData(otpUser, "email-subject-template", token, primaryLanguage, secondaryLanguage);
            String mergedEmailSubject = this.getMergedEmailContent(otp, emailSubject, otpUser.getTemplateVariables());
            String emailContent = this.getEmailData(otpUser, "email-content-template", token, primaryLanguage, secondaryLanguage);
            String mergedEmailContent = this.getMergedEmailContent(otp, emailContent, otpUser.getTemplateVariables());
            otpEmailTemplate.setEmailSubject(mergedEmailSubject);
            otpEmailTemplate.setEmailContent(mergedEmailContent);
            return otpEmailTemplate;
        }
        return otpEmailTemplate;
    }

    private String getMergedEmailContent(String otp, String emailContent, Map<String, Object> templateVariables) {
        String template = null;
        ByteArrayInputStream templateInputStream = new ByteArrayInputStream(emailContent.getBytes(Charset.forName("UTF-8")));
        InputStream resultedTemplate = null;
        try {
            if (templateVariables == null) {
                HashMap<String, String> templateVariable = new HashMap<String, String>();
                templateVariable.put("otp", otp);
                resultedTemplate = this.templateManager.merge((InputStream)templateInputStream, templateVariable);
                template = IOUtils.toString((InputStream)resultedTemplate, (String)StandardCharsets.UTF_8.name());
                return template;
            }
            templateVariables.put("otp", otp);
            resultedTemplate = this.templateManager.merge((InputStream)templateInputStream, templateVariables);
            template = IOUtils.toString((InputStream)resultedTemplate, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), e.getMessage());
        }
        return template;
    }

    private String getEmailData(OtpUser otpUser, String templateType, String token, String primaryLanguage, String secondaryLanguage) {
        String emailPrimaryData = null;
        String emailSecondaryData = null;
        String templateData = null;
        if (primaryLanguage != null) {
            emailPrimaryData = this.getMasterDataForLanguage(otpUser, templateType, token, primaryLanguage);
        }
        if (secondaryLanguage != null) {
            emailSecondaryData = this.getMasterDataForLanguage(otpUser, templateType, token, secondaryLanguage);
        }
        if (emailPrimaryData != null && emailSecondaryData != null) {
            templateData = !templateType.contains("subject") ? emailPrimaryData + "\n\n" + emailSecondaryData : emailPrimaryData;
        } else if (emailPrimaryData != null) {
            templateData = emailPrimaryData;
        } else if (emailSecondaryData != null) {
            templateData = emailSecondaryData;
        }
        return templateData;
    }

    public String getMasterDataForLanguage(OtpUser otpUser, String templateType, String token, String language) {
        OtpTemplateResponseDto otpTemplateResponseDto;
        block12: {
            otpTemplateResponseDto = null;
            ResponseEntity response = null;
            String url = templateType != null ? this.mosipEnvironment.getMasterDataTemplateApi() + "/" + language + "/" + otpUser.getContext() + "-" + templateType : this.mosipEnvironment.getMasterDataTemplateApi() + "/" + language + "/" + otpUser.getContext();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Cookie", "Authorization=" + token);
            try {
                response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
                if (!response.getStatusCode().equals((Object)HttpStatus.OK)) break block12;
                String responseBody = (String)response.getBody();
                List validationErrorsList = null;
                validationErrorsList = ExceptionUtils.getServiceErrorList((String)responseBody);
                Optional<ServiceError> service = validationErrorsList.stream().filter(a -> a.getErrorCode().equals("KER-MSD-046")).findFirst();
                if (service.isPresent()) {
                    throw new AuthManagerException(AuthErrorCode.TEMPLATE_ERROR.getErrorCode(), AuthErrorCode.TEMPLATE_ERROR.getErrorMessage() + language + "with context " + otpUser.getContext() + "-" + templateType);
                }
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthManagerServiceException(validationErrorsList);
                }
                try {
                    ResponseWrapper responseObject = (ResponseWrapper)this.mapper.readValue((String)response.getBody(), ResponseWrapper.class);
                    otpTemplateResponseDto = (OtpTemplateResponseDto)this.mapper.readValue(this.mapper.writeValueAsString(responseObject.getResponse()), OtpTemplateResponseDto.class);
                }
                catch (Exception e) {
                    throw new AuthManagerException(AuthErrorCode.SERVER_ERROR.getErrorCode(), e.getMessage(), (Throwable)e);
                }
            }
            catch (HttpClientErrorException | HttpServerErrorException ex) {
                List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
                if (ex.getRawStatusCode() == 401) {
                    if (!validationErrorsList.isEmpty()) {
                        throw new AuthNException(validationErrorsList);
                    }
                    throw new BadCredentialsException("Authentication failed from Internal token services");
                }
                if (ex.getRawStatusCode() == 403) {
                    if (!validationErrorsList.isEmpty()) {
                        throw new AuthZException(validationErrorsList);
                    }
                    throw new AccessDeniedException("Access denied from Internal token services");
                }
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthManagerServiceException(validationErrorsList);
                }
                throw new AuthManagerException(AuthErrorCode.CLIENT_ERROR.getErrorCode(), ex.getMessage(), ex);
            }
        }
        String templateText = null;
        OtpTemplateDto templateDto = null;
        ArrayList otpTemplateList = otpTemplateResponseDto.getTemplates();
        if (otpTemplateList != null && otpTemplateList.size() > 0) {
            templateDto = (OtpTemplateDto)otpTemplateList.get(0);
            templateText = templateDto.getFileText();
        }
        return templateText;
    }

    public String getOtpSmsMessage(String otp, OtpUser otpUser, String token) {
        String primaryLanguage = null;
        String secondaryLanguage = null;
        if (BOTH.equals(this.environment.getProperty(MOSIP_NOTIFICATION_LANGUAGE_TYPE))) {
            primaryLanguage = this.environment.getProperty(ENV_PRIMARY_LANGUAGE);
            if (primaryLanguage == null) {
                throw new AuthManagerException(OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorCode(), OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorMessage());
            }
            secondaryLanguage = this.environment.getProperty(ENV_SECONDARY_LANGUAGE);
            if (secondaryLanguage == null) {
                throw new AuthManagerException(OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorCode(), OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorMessage());
            }
            String smsMessage = this.getEmailData(otpUser, "sms-template", token, primaryLanguage, secondaryLanguage);
            String mergedMessage = this.getMergedEmailContent(otp, smsMessage, otpUser.getTemplateVariables());
            return mergedMessage;
        }
        if (PRIMARY.equals(this.environment.getProperty(MOSIP_NOTIFICATION_LANGUAGE_TYPE))) {
            primaryLanguage = this.environment.getProperty(ENV_PRIMARY_LANGUAGE);
            if (primaryLanguage == null) {
                throw new AuthManagerException(OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorCode(), OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorMessage());
            }
            String smsMessage = this.getEmailData(otpUser, "sms-template", token, primaryLanguage, secondaryLanguage);
            String mergedMessage = this.getMergedEmailContent(otp, smsMessage, otpUser.getTemplateVariables());
            return mergedMessage;
        }
        if (SECONDARY.equals(this.environment.getProperty(MOSIP_NOTIFICATION_LANGUAGE_TYPE))) {
            secondaryLanguage = this.environment.getProperty(ENV_SECONDARY_LANGUAGE);
            if (secondaryLanguage == null) {
                throw new AuthManagerException(OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorCode(), OTPErrorCode.LANGUAGENOTCONFIGURED.getErrorMessage());
            }
            String smsMessage = this.getEmailData(otpUser, "sms-template", token, primaryLanguage, secondaryLanguage);
            String mergedMessage = this.getMergedEmailContent(otp, smsMessage, otpUser.getTemplateVariables());
            return mergedMessage;
        }
        return null;
    }
}

