/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.service.impl;

import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.dto.AuthToken;
import io.mosip.kernel.auth.dto.TimeToken;
import io.mosip.kernel.auth.exception.AuthManagerException;
import io.mosip.kernel.auth.service.TokenService;
import java.util.Date;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class TokenServicesImpl
implements TokenService {
    public static final String INSERT_TOKEN = "insert into iam.oauth_access_token(user_id,auth_token,refresh_token,expiration_time,cr_dtimes,is_active,cr_by) values(:userName,:token,:refreshToken,:expTime,:crdTimes,true,'Admin')";
    public static final String SELECT_TOKEN = "select user_id,auth_token,refresh_token,expiration_time from iam.oauth_access_token where auth_token like :token ";
    public static final String UPDATE_TOKEN = "update iam.oauth_access_token set user_id=:userName,auth_token=:token,refresh_token=:refreshToken,expiration_time=:expTime,cr_dtimes=:crdTimes  where user_id = :userName";
    public static final String CHECK_USER = "select user_id from iam.oauth_access_token where user_id like :userName";
    public static final String UPDATE_NEW_TOKEN = "update iam.oauth_access_token set auth_token=:token,expiration_time=:expTime where user_id like :userName ";
    public static final String SELECT_TOKEN_NAME = "select user_id,auth_token,refresh_token,expiration_time from iam.oauth_access_token where user_id like :userName ";
    public static final String DELETE_ACCESS_TOKEN = "delete from iam.oauth_access_token where user_id like :userName";
    public static final String DELETE_REFRESH_TOKEN = "delete from iam.oauth_access_token where user_id like :userName";
    private final String insertTokenSQL = "insert into iam.oauth_access_token(user_id,auth_token,refresh_token,expiration_time,cr_dtimes,is_active,cr_by) values(:userName,:token,:refreshToken,:expTime,:crdTimes,true,'Admin')";
    private final String selectTokenSQL = "select user_id,auth_token,refresh_token,expiration_time from iam.oauth_access_token where auth_token like :token ";
    private final String updateTokenSQL = "update iam.oauth_access_token set user_id=:userName,auth_token=:token,refresh_token=:refreshToken,expiration_time=:expTime,cr_dtimes=:crdTimes  where user_id = :userName";
    private final String checkUserTokenSQL = "select user_id from iam.oauth_access_token where user_id like :userName";
    private final String updateNewTokenSQL = "update iam.oauth_access_token set auth_token=:token,expiration_time=:expTime where user_id like :userName ";
    private final String selectTokenFromName = "select user_id,auth_token,refresh_token,expiration_time from iam.oauth_access_token where user_id like :userName ";
    private final String deleteAccessToken = "delete from iam.oauth_access_token where user_id like :userName";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    @Autowired
    public TokenServicesImpl(DataSource datasource) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(datasource);
    }

    public void StoreToken(AuthToken token) {
        String userName = this.checkUser(token.getUserId());
        if (userName != null) {
            this.UpdateToken(token);
        } else {
            this.jdbcTemplate.update(INSERT_TOKEN, (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)token.getUserId()).addValue("token", (Object)token.getAccessToken()).addValue("refreshToken", (Object)token.getRefreshToken()).addValue("expTime", (Object)new Date(token.getExpirationTime())).addValue("crdTimes", (Object)new Date()));
        }
    }

    public void UpdateToken(AuthToken token) {
        String userName = this.checkUser(token.getUserId());
        if (userName != null) {
            this.jdbcTemplate.update(UPDATE_TOKEN, (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)token.getUserId()).addValue("token", (Object)token.getAccessToken()).addValue("refreshToken", (Object)token.getRefreshToken()).addValue("expTime", (Object)new Date(token.getExpirationTime())).addValue("crdTimes", (Object)new Date()));
        }
    }

    private String checkUser(String userId) {
        return (String)this.jdbcTemplate.query(CHECK_USER, (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)userId), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public AuthToken getTokenDetails(String token) {
        return (AuthToken)this.jdbcTemplate.query(SELECT_TOKEN, (SqlParameterSource)new MapSqlParameterSource().addValue("token", (Object)token.trim()), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public AuthToken getUpdatedAccessToken(String token, TimeToken newAccessToken, String userName) {
        this.jdbcTemplate.update(UPDATE_NEW_TOKEN, (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)userName).addValue("token", (Object)newAccessToken.getToken()).addValue("expTime", (Object)new Date(newAccessToken.getExpTime())));
        return this.getTokenBasedOnName(userName);
    }

    public AuthToken getTokenBasedOnName(String userName) {
        return (AuthToken)this.jdbcTemplate.query(SELECT_TOKEN_NAME, (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)userName.trim()), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void revokeToken(String token) {
        AuthToken authToken = this.getTokenDetails(token);
        if (authToken == null) {
            throw new AuthManagerException(AuthErrorCode.TOKEN_DATASTORE_ERROR.getErrorCode(), AuthErrorCode.TOKEN_DATASTORE_ERROR.getErrorMessage());
        }
        this.removeAccessToken(authToken.getUserId());
    }

    private void removeAccessToken(String userId) {
        this.jdbcTemplate.update("delete from iam.oauth_access_token where user_id like :userName", (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)userId));
    }
}

