/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.service.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.auth.config.MosipEnvironment;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.dto.AccessTokenResponse;
import io.mosip.kernel.auth.dto.AccessTokenResponseDTO;
import io.mosip.kernel.auth.dto.AuthNResponse;
import io.mosip.kernel.auth.dto.AuthNResponseDto;
import io.mosip.kernel.auth.dto.AuthResponseDto;
import io.mosip.kernel.auth.dto.AuthToken;
import io.mosip.kernel.auth.dto.AuthZResponseDto;
import io.mosip.kernel.auth.dto.ClientSecret;
import io.mosip.kernel.auth.dto.KeycloakErrorResponseDto;
import io.mosip.kernel.auth.dto.LoginUser;
import io.mosip.kernel.auth.dto.MosipUserDto;
import io.mosip.kernel.auth.dto.MosipUserListDto;
import io.mosip.kernel.auth.dto.MosipUserSaltListDto;
import io.mosip.kernel.auth.dto.MosipUserTokenDto;
import io.mosip.kernel.auth.dto.PasswordDto;
import io.mosip.kernel.auth.dto.RIdDto;
import io.mosip.kernel.auth.dto.RealmAccessDto;
import io.mosip.kernel.auth.dto.RolesListDto;
import io.mosip.kernel.auth.dto.TimeToken;
import io.mosip.kernel.auth.dto.UserDetailsResponseDto;
import io.mosip.kernel.auth.dto.UserNameDto;
import io.mosip.kernel.auth.dto.UserOtp;
import io.mosip.kernel.auth.dto.UserPasswordRequestDto;
import io.mosip.kernel.auth.dto.UserPasswordResponseDto;
import io.mosip.kernel.auth.dto.UserRegistrationRequestDto;
import io.mosip.kernel.auth.dto.UserRoleDto;
import io.mosip.kernel.auth.dto.ValidationResponseDto;
import io.mosip.kernel.auth.dto.otp.OtpUser;
import io.mosip.kernel.auth.exception.AuthManagerException;
import io.mosip.kernel.auth.exception.LoginException;
import io.mosip.kernel.auth.repository.UserStoreFactory;
import io.mosip.kernel.auth.repository.impl.KeycloakImpl;
import io.mosip.kernel.auth.service.AuthService;
import io.mosip.kernel.auth.service.OTPService;
import io.mosip.kernel.auth.service.TokenService;
import io.mosip.kernel.auth.service.UinService;
import io.mosip.kernel.auth.util.TokenGenerator;
import io.mosip.kernel.auth.util.TokenValidator;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class AuthServiceImpl
implements AuthService {
    private static final String CLIENTID_AND_TOKEN_COMBINATION_HAD_BEEN_VALIDATED_SUCCESSFULLY = "Clientid and Token combination had been validated successfully";
    private static final String LOG_OUT_FAILED = "log out failed";
    private static final String FAILED = "Failed";
    private static final String SUCCESS = "Success";
    private static final String SUCCESSFULLY_LOGGED_OUT = "successfully loggedout";
    @Value(value="${mosip.kernel.open-id-url}")
    private String keycloakOpenIdUrl;
    @Value(value="${mosip.admin_realm_id}")
    private String realmId;
    @Autowired
    UserStoreFactory userStoreFactory;
    @Autowired
    KeycloakImpl keycloakImpl;
    @Autowired
    TokenGenerator tokenGenerator;
    @Autowired
    TokenValidator tokenValidator;
    @Autowired
    TokenService customTokenServices;
    @Autowired
    OTPService oTPService;
    @Autowired
    UinService uinService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    MosipEnvironment mosipEnvironment;
    @Autowired
    ObjectMapper objectmapper;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${mosip.kernel.open-id-url}")
    private String openIdUrl;
    @Value(value="${mosip.admin.login_flow.name}")
    private String loginFlowName;
    @Value(value="${mosip.admin.clientid}")
    private String clientID;
    @Value(value="${mosip.admin.clientsecret}")
    private String clientSecret;
    @Value(value="${mosip.admin.redirecturi}")
    private String redirectURI;
    @Value(value="${mosip.admin.login_flow.scope}")
    private String scope;
    @Value(value="${mosip.admin.login_flow.response_type}")
    private String responseType;
    @Value(value="${mosip.keycloak.authorization_endpoint}")
    private String authorizationEndpoint;
    @Value(value="${mosip.keycloak.token_endpoint}")
    private String tokenEndpoint;
    @Value(value="${mosip.admin_realm_id}")
    private String realmID;
    @Qualifier(value="authRestTemplate")
    @Autowired
    private RestTemplate authRestTemplate;
    Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public MosipUserTokenDto validateToken(String token) throws Exception {
        MosipUserTokenDto mosipUserDtoToken = this.tokenValidator.validateToken(token);
        AuthToken authToken = this.customTokenServices.getTokenDetails(token);
        if (authToken == null) {
            throw new AuthManagerException(AuthErrorCode.INVALID_TOKEN.getErrorCode(), AuthErrorCode.INVALID_TOKEN.getErrorMessage());
        }
        if (mosipUserDtoToken != null) {
            return mosipUserDtoToken;
        }
        throw new NonceExpiredException("Auth token expired ");
    }

    private AuthToken getAuthToken(MosipUserTokenDto mosipUserDtoToken) {
        return new AuthToken(mosipUserDtoToken.getMosipUserDto().getUserId(), mosipUserDtoToken.getToken(), mosipUserDtoToken.getExpTime(), mosipUserDtoToken.getRefreshToken());
    }

    private long getExpiryTime(long expirationTime) {
        Instant ins = Instant.ofEpochMilli(expirationTime);
        ins = ins.plus((long)this.mosipEnvironment.getAuthSlidingWindowExp().intValue(), ChronoUnit.MINUTES);
        return ins.toEpochMilli();
    }

    public AuthNResponseDto authenticateUser(LoginUser loginUser) throws Exception {
        AuthNResponseDto authNResponseDto = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap tokenRequestBody = null;
        ResponseEntity response = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        tokenRequestBody = this.getPasswordValueMap(this.clientID, this.clientSecret, loginUser.getUserName(), loginUser.getPassword());
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        try {
            response = this.authRestTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            System.out.println(ex.getResponseBodyAsString());
        }
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.getBody();
        authNResponseDto = new AuthNResponseDto();
        authNResponseDto.setToken(accessTokenResponse.getAccess_token());
        authNResponseDto.setRefreshToken(accessTokenResponse.getRefresh_token());
        authNResponseDto.setExpiryTime(Long.parseLong(accessTokenResponse.getExpires_in()));
        authNResponseDto.setStatus("success");
        authNResponseDto.setMessage("Username and password combination had been validated successfully");
        return authNResponseDto;
    }

    public AuthNResponseDto authenticateWithOtp(OtpUser otpUser) throws Exception {
        AuthNResponseDto authNResponseDto = null;
        MosipUserDto mosipUser = null;
        otpUser.getOtpChannel().replaceAll(String::toLowerCase);
        otpUser.setOtpChannel(otpUser.getOtpChannel());
        if ("UIN".equals(otpUser.getUseridtype())) {
            mosipUser = this.uinService.getDetailsFromUin(otpUser);
            authNResponseDto = this.oTPService.sendOTPForUin(mosipUser, otpUser, "ida");
            authNResponseDto.setStatus(authNResponseDto.getStatus());
            authNResponseDto.setMessage(authNResponseDto.getMessage());
        } else if ("USERID".equals(otpUser.getUseridtype())) {
            UserRegistrationRequestDto userCreationRequestDto = new UserRegistrationRequestDto();
            userCreationRequestDto.setUserName(otpUser.getUserId());
            userCreationRequestDto.setAppId(otpUser.getAppId());
            mosipUser = this.registerUser(userCreationRequestDto);
            authNResponseDto = this.oTPService.sendOTP(mosipUser, otpUser);
            authNResponseDto.setStatus(authNResponseDto.getStatus());
            authNResponseDto.setMessage(authNResponseDto.getMessage());
        } else {
            throw new AuthManagerException(String.valueOf(HttpStatus.UNAUTHORIZED.value()), "Invalid User Id type");
        }
        return authNResponseDto;
    }

    public AuthNResponseDto authenticateUserWithOtp(UserOtp userOtp) throws Exception {
        AuthNResponseDto authNResponseDto = new AuthNResponseDto();
        MosipUserTokenDto mosipToken = null;
        MosipUserDto mosipUser = null;
        if (this.keycloakImpl.isUserAlreadyPresent(userOtp.getUserId())) {
            mosipUser = new MosipUserDto();
            mosipUser.setUserId(userOtp.getUserId());
        }
        if (mosipUser == null && "ida".toLowerCase().equals(userOtp.getAppId().toLowerCase())) {
            mosipUser = this.uinService.getDetailsForValidateOtp(userOtp.getUserId());
        }
        if (mosipUser == null) {
            throw new AuthManagerException(AuthErrorCode.USER_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.USER_VALIDATION_ERROR.getErrorMessage());
        }
        mosipToken = this.oTPService.validateOTP(mosipUser, userOtp.getOtp());
        if (mosipToken != null && mosipToken.getMosipUserDto() != null) {
            authNResponseDto.setMessage(mosipToken.getMessage());
            authNResponseDto.setStatus(mosipToken.getStatus());
            authNResponseDto.setToken(mosipToken.getToken());
            authNResponseDto.setExpiryTime(mosipToken.getExpTime());
            authNResponseDto.setRefreshToken(mosipToken.getRefreshToken());
            authNResponseDto.setUserId(mosipToken.getMosipUserDto().getUserId());
        } else {
            authNResponseDto.setMessage(mosipToken.getMessage());
            authNResponseDto.setStatus(mosipToken.getStatus());
        }
        return authNResponseDto;
    }

    public AuthNResponseDto authenticateWithSecretKey(ClientSecret clientSecret) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap tokenRequestBody = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        tokenRequestBody = this.getClientSecretValueMap(clientSecret.getClientId(), clientSecret.getSecretKey());
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        ResponseEntity response = this.authRestTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        AccessTokenResponse accessTokenResponse = (AccessTokenResponse)response.getBody();
        AuthNResponseDto authNResponseDto = new AuthNResponseDto();
        authNResponseDto.setToken(accessTokenResponse.getAccess_token());
        authNResponseDto.setRefreshToken(accessTokenResponse.getRefresh_token());
        authNResponseDto.setExpiryTime(Long.parseLong(accessTokenResponse.getExpires_in()));
        authNResponseDto.setStatus(SUCCESS);
        authNResponseDto.setMessage(CLIENTID_AND_TOKEN_COMBINATION_HAD_BEEN_VALIDATED_SUCCESSFULLY);
        return authNResponseDto;
    }

    public MosipUserTokenDto retryToken(String existingToken) throws Exception {
        MosipUserTokenDto mosipUserDtoToken = null;
        boolean checkRefreshToken = false;
        AuthToken accessToken = this.customTokenServices.getTokenDetails(existingToken);
        if (accessToken != null) {
            if (accessToken.getRefreshToken() != null) {
                checkRefreshToken = this.tokenValidator.validateExpiry(accessToken.getRefreshToken());
            }
            if (!checkRefreshToken) {
                throw new RuntimeException("Refresh Token Expired");
            }
        } else {
            throw new RuntimeException("Token doesn't exist");
        }
        TimeToken newAccessToken = this.tokenGenerator.generateNewToken(accessToken.getRefreshToken());
        AuthToken updatedAccessToken = this.customTokenServices.getUpdatedAccessToken(accessToken.getUserId(), newAccessToken, accessToken.getUserId());
        mosipUserDtoToken = this.tokenValidator.validateToken(updatedAccessToken.getAccessToken());
        return mosipUserDtoToken;
    }

    public AuthNResponse invalidateToken(String token) throws Exception {
        AuthNResponse authNResponse = null;
        this.customTokenServices.revokeToken(token);
        authNResponse = new AuthNResponse();
        authNResponse.setStatus("success");
        authNResponse.setMessage("Token has been invalidated successfully");
        return authNResponse;
    }

    public RolesListDto getAllRoles(String appId) {
        RolesListDto rolesListDto = this.keycloakImpl.getAllRoles();
        return rolesListDto;
    }

    public MosipUserListDto getListOfUsersDetails(List<String> userDetails, String appId) throws Exception {
        MosipUserListDto mosipUserListDto = this.keycloakImpl.getListOfUsersDetails(userDetails);
        return mosipUserListDto;
    }

    public MosipUserSaltListDto getAllUserDetailsWithSalt(String appId) throws Exception {
        return this.keycloakImpl.getAllUserDetailsWithSalt();
    }

    public RIdDto getRidBasedOnUid(String userId, String appId) throws Exception {
        return this.keycloakImpl.getRidFromUserId(userId);
    }

    public AuthZResponseDto unBlockUser(String userId, String appId) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).unBlockAccount(userId);
    }

    public AuthZResponseDto changePassword(String appId, PasswordDto passwordDto) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).changePassword(passwordDto);
    }

    public AuthZResponseDto resetPassword(String appId, PasswordDto passwordDto) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).resetPassword(passwordDto);
    }

    public UserNameDto getUserNameBasedOnMobileNumber(String appId, String mobileNumber) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp("registrationclient").getUserNameBasedOnMobileNumber(mobileNumber);
    }

    public MosipUserDto registerUser(UserRegistrationRequestDto userCreationRequestDto) {
        return this.keycloakImpl.registerUser(userCreationRequestDto);
    }

    public UserPasswordResponseDto addUserPassword(UserPasswordRequestDto userPasswordRequestDto) {
        return this.userStoreFactory.getDataStoreBasedOnApp(userPasswordRequestDto.getAppId()).addPassword(userPasswordRequestDto);
    }

    public UserRoleDto getUserRole(String appId, String userId) throws Exception {
        MosipUserDto mosipuser = null;
        mosipuser = this.userStoreFactory.getDataStoreBasedOnApp(appId).getUserRoleByUserId(userId);
        UserRoleDto userRole = new UserRoleDto();
        userRole.setUserId(mosipuser.getUserId());
        userRole.setRole(mosipuser.getRole());
        return userRole;
    }

    public MosipUserDto getUserDetailBasedonMobileNumber(String appId, String mobileNumber) throws Exception {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).getUserDetailBasedonMobileNumber(mobileNumber);
    }

    public ValidationResponseDto validateUserName(String appId, String userName) {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).validateUserName(userName);
    }

    public UserDetailsResponseDto getUserDetailBasedOnUserId(String appId, List<String> userIds) {
        return this.userStoreFactory.getDataStoreBasedOnApp(appId).getUserDetailBasedOnUid(userIds);
    }

    public MosipUserDto valdiateToken(String token) {
        HashMap<String, String> pathparams = new HashMap<String, String>();
        if (EmptyCheckUtils.isNullEmpty((String)token)) {
            throw new AuthenticationServiceException(AuthErrorCode.INVALID_TOKEN.getErrorMessage());
        }
        pathparams.put("realmId", "mosip");
        ResponseEntity response = null;
        MosipUserDto mosipUserDto = null;
        System.out.println("validate token url " + this.openIdUrl);
        StringBuilder urlBuilder = new StringBuilder().append(this.openIdUrl).append("userinfo");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)urlBuilder.toString());
        HttpHeaders headers = new HttpHeaders();
        System.out.println(token);
        String accessToken = "Bearer " + token;
        headers.add("Authorization", accessToken);
        HttpEntity httpRequest = new HttpEntity((MultiValueMap)headers);
        try {
            response = this.restTemplate.exchange(uriComponentsBuilder.buildAndExpand(pathparams).toUriString(), HttpMethod.GET, httpRequest, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            KeycloakErrorResponseDto keycloakErrorResponseDto = this.parseKeyClockErrorResponse((HttpStatusCodeException)e);
            if (e.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthenticationServiceException(AuthErrorCode.INVALID_TOKEN.getErrorMessage() + keycloakErrorResponseDto.getError_description());
            }
            if (e.getStatusCode() == HttpStatus.FORBIDDEN) {
                throw new AccessDeniedException(AuthErrorCode.FORBIDDEN.getErrorMessage() + keycloakErrorResponseDto.getError_description());
            }
            throw new AuthManagerException(AuthErrorCode.REST_EXCEPTION.getErrorCode(), AuthErrorCode.REST_EXCEPTION.getErrorMessage() + " " + e.getResponseBodyAsString());
        }
        if (response.getStatusCode().is2xxSuccessful()) {
            mosipUserDto = this.getClaims(token);
        }
        return mosipUserDto;
    }

    public AuthResponseDto logoutUser(String token) {
        if (EmptyCheckUtils.isNullEmpty((String)token)) {
            throw new AuthenticationServiceException(AuthErrorCode.INVALID_TOKEN.getErrorMessage());
        }
        HashMap<String, String> pathparams = new HashMap<String, String>();
        pathparams.put("realmId", this.realmID);
        ResponseEntity response = null;
        AuthResponseDto authResponseDto = new AuthResponseDto();
        StringBuilder urlBuilder = new StringBuilder().append(this.openIdUrl).append("logout");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)urlBuilder.toString()).queryParam("id_token_hint", new Object[]{token});
        try {
            response = this.restTemplate.getForEntity(uriComponentsBuilder.buildAndExpand(pathparams).toUriString(), String.class, new Object[0]);
            System.out.println((String)response.getBody());
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            throw new AuthManagerException(AuthErrorCode.REST_EXCEPTION.getErrorCode(), AuthErrorCode.REST_EXCEPTION.getErrorMessage() + e.getResponseBodyAsString());
        }
        if (response.getStatusCode().is2xxSuccessful()) {
            authResponseDto.setMessage(SUCCESSFULLY_LOGGED_OUT);
            authResponseDto.setStatus(SUCCESS);
        } else {
            authResponseDto.setMessage(LOG_OUT_FAILED);
            authResponseDto.setStatus(FAILED);
        }
        return authResponseDto;
    }

    private MosipUserDto getClaims(String cookie) {
        DecodedJWT decodedJWT = JWT.decode((String)cookie);
        Claim realmAccess = decodedJWT.getClaim("realm_access");
        RealmAccessDto access = (RealmAccessDto)realmAccess.as(RealmAccessDto.class);
        String[] roles = access.getRoles();
        StringBuilder builder = new StringBuilder();
        for (String r : roles) {
            builder.append(r);
            builder.append(",");
        }
        MosipUserDto dto = new MosipUserDto();
        dto.setUserId(decodedJWT.getClaim("preferred_username").asString());
        dto.setMail(decodedJWT.getClaim("email").asString());
        dto.setMobile(decodedJWT.getClaim("mobile").asString());
        dto.setName(decodedJWT.getClaim("preferred_username").asString());
        dto.setRId(decodedJWT.getClaim("rid").asString());
        dto.setToken(cookie);
        dto.setRole(builder.toString());
        return dto;
    }

    public AccessTokenResponseDTO loginRedirect(String state, String sessionState, String code, String stateCookie, String redirectURI) {
        if (!stateCookie.equals(state)) {
            throw new AuthManagerException(AuthErrorCode.KEYCLOAK_STATE_EXCEPTION.getErrorCode(), AuthErrorCode.KEYCLOAK_STATE_EXCEPTION.getErrorMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)this.loginFlowName);
        map.add((Object)"client_id", (Object)this.clientID);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"redirect_uri", (Object)(this.redirectURI + redirectURI));
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(this.tokenEndpoint, HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            KeycloakErrorResponseDto keycloakErrorResponseDto = this.parseKeyClockErrorResponse((HttpStatusCodeException)e);
            throw new LoginException(AuthErrorCode.KEYCLOAK_ACESSTOKEN_EXCEPTION.getErrorCode(), AuthErrorCode.KEYCLOAK_ACESSTOKEN_EXCEPTION.getErrorMessage() + " " + keycloakErrorResponseDto.getError_description());
        }
        AccessTokenResponse accessTokenResponse = null;
        try {
            accessTokenResponse = (AccessTokenResponse)this.objectmapper.readValue((String)responseEntity.getBody(), AccessTokenResponse.class);
        }
        catch (IOException exception) {
            throw new LoginException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage() + " " + exception.getMessage());
        }
        AccessTokenResponseDTO accessTokenResponseDTO = new AccessTokenResponseDTO();
        accessTokenResponseDTO.setAccessToken(accessTokenResponse.getAccess_token());
        accessTokenResponseDTO.setExpiresIn(accessTokenResponse.getExpires_in());
        return accessTokenResponseDTO;
    }

    private KeycloakErrorResponseDto parseKeyClockErrorResponse(HttpStatusCodeException exception) {
        KeycloakErrorResponseDto keycloakErrorResponseDto = null;
        try {
            keycloakErrorResponseDto = (KeycloakErrorResponseDto)this.objectmapper.readValue(exception.getResponseBodyAsString(), KeycloakErrorResponseDto.class);
        }
        catch (IOException e) {
            throw new LoginException(AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorCode(), AuthErrorCode.RESPONSE_PARSE_ERROR.getErrorMessage() + " " + e.getMessage());
        }
        return keycloakErrorResponseDto;
    }

    public String getKeycloakURI(String redirectURI, String state) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)this.authorizationEndpoint);
        uriComponentsBuilder.queryParam("client_id", new Object[]{this.clientID});
        uriComponentsBuilder.queryParam("redirect_uri", new Object[]{this.redirectURI + redirectURI});
        uriComponentsBuilder.queryParam("state", new Object[]{state});
        uriComponentsBuilder.queryParam("response_type", new Object[]{this.responseType});
        uriComponentsBuilder.queryParam("scope", new Object[]{this.scope});
        return uriComponentsBuilder.build().toString();
    }

    private MultiValueMap<String, String> getPasswordValueMap(String clientID, String clientSecret, String username, String password) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"username", (Object)username);
        map.add((Object)"password", (Object)password);
        map.add((Object)"client_id", (Object)clientID);
        map.add((Object)"client_secret", (Object)clientSecret);
        return map;
    }

    private MultiValueMap<String, String> getClientSecretValueMap(String clientID, String clientSecret) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"client_credentials");
        map.add((Object)"client_id", (Object)clientID);
        map.add((Object)"client_secret", (Object)clientSecret);
        return map;
    }
}

