/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.repository.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.mosip.kernel.auth.adapter.exception.AuthManagerException;
import io.mosip.kernel.auth.adapter.exception.AuthNException;
import io.mosip.kernel.auth.adapter.exception.AuthZException;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.dto.AuthZResponseDto;
import io.mosip.kernel.auth.dto.ClientSecret;
import io.mosip.kernel.auth.dto.KeycloakPasswordDTO;
import io.mosip.kernel.auth.dto.KeycloakRequestDto;
import io.mosip.kernel.auth.dto.LoginUser;
import io.mosip.kernel.auth.dto.MosipUserDto;
import io.mosip.kernel.auth.dto.MosipUserListDto;
import io.mosip.kernel.auth.dto.MosipUserSaltListDto;
import io.mosip.kernel.auth.dto.PasswordDto;
import io.mosip.kernel.auth.dto.RIdDto;
import io.mosip.kernel.auth.dto.Role;
import io.mosip.kernel.auth.dto.Roles;
import io.mosip.kernel.auth.dto.RolesListDto;
import io.mosip.kernel.auth.dto.UserDetailsResponseDto;
import io.mosip.kernel.auth.dto.UserNameDto;
import io.mosip.kernel.auth.dto.UserOtp;
import io.mosip.kernel.auth.dto.UserPasswordRequestDto;
import io.mosip.kernel.auth.dto.UserPasswordResponseDto;
import io.mosip.kernel.auth.dto.UserRegistrationRequestDto;
import io.mosip.kernel.auth.dto.ValidationResponseDto;
import io.mosip.kernel.auth.dto.otp.OtpUser;
import io.mosip.kernel.auth.repository.DataStore;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.util.CryptoUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import javax.xml.bind.DatatypeConverter;
import org.apache.directory.api.ldap.model.password.PasswordDetails;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class KeycloakImpl
implements DataStore {
    private static final String INDIVIDUAL = "INDIVIDUAL";
    @Value(value="${mosip.kernel.base-url}")
    private String keycloakBaseUrl;
    @Value(value="${mosip.kernel.admin-url}")
    private String keycloakAdminUrl;
    @Value(value="${mosip.kernel.admin-realm-id}")
    private String adminRealmId;
    @Value(value="${mosip.kernel.realm-id}")
    private String realmId;
    @Value(value="${mosip.kernel.roles-url}")
    private String roles;
    @Value(value="${mosip.kernel.users-url}")
    private String users;
    @Value(value="${mosip.kernel.role-user-mapping-url}")
    private String roleUserMappingurl;
    @Value(value="${mosip.admin.individual_role_id}")
    private String individualRoleID;
    @Qualifier(value="keycloakRestTemplate")
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${db_3_DS.keycloak.ipaddress}")
    private String keycloakHost;
    @Value(value="${db_3_DS.keycloak.port}")
    private String keycloakPort;
    @Value(value="${db_3_DS.keycloak.username}")
    private String keycloakUsername;
    @Value(value="${db_3_DS.keycloak.password}")
    private String keycloakPassword;
    @Value(value="${db_3_DS.keycloak.driverClassName}")
    private String keycloakDriver;
    @Value(value="${mosip.admin.pre-reg_user_password}")
    private String preRegUserPassword;
    @Value(value="${hikari.maximumPoolSize:25}")
    private int maximumPoolSize;
    @Value(value="${hikari.validationTimeout:3000}")
    private int validationTimeout;
    @Value(value="${hikari.connectionTimeout:60000}")
    private int connectionTimeout;
    @Value(value="${hikari.idleTimeout:200000}")
    private int idleTimeout;
    @Value(value="${hikari.minimumIdle:0}")
    private int minimumIdle;
    @Value(value="${mosip.keycloak.max-no-of-users:100}")
    private String maxUsers;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private static final String FETCH_ALL_SALTS = "select ue.username,ua.value from public.user_entity ue, public.user_attribute ua where ue.id=ua.user_id and ua.name='userPassword'";
    private static final String FETCH_PASSWORD = "select cr.value from public.credential cr, public.user_entity ue where cr.user_id=ue.id and ue.username=:username";
    @Autowired
    private ObjectMapper objectMapper;

    @PostConstruct
    private void setup() {
        this.setUpConnection();
    }

    private void setUpConnection() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(this.keycloakDriver);
        hikariConfig.setJdbcUrl(this.keycloakHost);
        hikariConfig.setUsername(this.keycloakUsername);
        hikariConfig.setPassword(this.keycloakPassword);
        hikariConfig.setMaximumPoolSize(this.maximumPoolSize);
        hikariConfig.setValidationTimeout((long)this.validationTimeout);
        hikariConfig.setConnectionTimeout((long)this.connectionTimeout);
        hikariConfig.setIdleTimeout((long)this.idleTimeout);
        hikariConfig.setMinimumIdle(this.minimumIdle);
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)dataSource);
    }

    public RolesListDto getAllRoles() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.roles));
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        ArrayList<Role> rolesList = new ArrayList<Role>();
        try {
            JsonNode node = this.objectMapper.readTree(response);
            for (JsonNode jsonNode : node) {
                Role role = new Role();
                String name = jsonNode.get("name").textValue();
                role.setRoleId(name);
                role.setRoleName(name);
                rolesList.add(role);
            }
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        RolesListDto rolesListDto = new RolesListDto();
        rolesListDto.setRoles(rolesList);
        return rolesListDto;
    }

    public MosipUserListDto getListOfUsersDetails(List<String> userDetails) throws Exception {
        List mosipUserDtos = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)new HttpHeaders());
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users));
        uriComponentsBuilder.queryParam("max", new Object[]{this.maxUsers});
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        try {
            JsonNode node = this.objectMapper.readTree(response);
            mosipUserDtos = this.mapUsersToUserDetailDto(node, userDetails);
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        MosipUserListDto mosipUserListDto = new MosipUserListDto();
        mosipUserListDto.setMosipUserDtoList(mosipUserDtos);
        return mosipUserListDto;
    }

    public MosipUserSaltListDto getAllUserDetailsWithSalt() throws Exception {
        return (MosipUserSaltListDto)this.jdbcTemplate.query(FETCH_ALL_SALTS, (SqlParameterSource)new MapSqlParameterSource(), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public RIdDto getRidFromUserId(String userId) throws Exception {
        RIdDto rIdDto = new RIdDto();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users));
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        try {
            JsonNode node = this.objectMapper.readTree(response);
            for (JsonNode jsonNode : node) {
                if (!jsonNode.get("username").textValue().equals(userId)) continue;
                JsonNode attriNode = jsonNode.get("attributes");
                String rid = attriNode.get("rid").get(0).textValue();
                rIdDto.setRId(rid);
                break;
            }
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        return rIdDto;
    }

    public AuthZResponseDto unBlockAccount(String userId) throws Exception {
        return null;
    }

    public MosipUserDto registerUser(UserRegistrationRequestDto userId) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        KeycloakRequestDto keycloakRequestDto = this.mapUserRequestToKeycloakRequestDto(userId);
        pathParams.put("realmId", this.realmId);
        HttpEntity httpEntity = new HttpEntity((Object)keycloakRequestDto);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users));
        if (!this.isUserAlreadyPresent(userId.getUserName())) {
            this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.POST, httpEntity);
            if (keycloakRequestDto.getRealmRoles().contains(INDIVIDUAL)) {
                String userID = this.getIDfromUserID(userId.getUserName());
                this.roleMapper(userID);
            }
        }
        MosipUserDto mosipUserDTO = new MosipUserDto();
        mosipUserDTO.setUserId(userId.getUserName());
        return mosipUserDTO;
    }

    private void roleMapper(String userID) {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        pathParams.put("userID", userID);
        Roles role = new Roles(this.individualRoleID, INDIVIDUAL);
        ArrayList<Roles> roles = new ArrayList<Roles>();
        roles.add(role);
        pathParams.put("realmId", this.realmId);
        HttpEntity httpEntity = new HttpEntity(roles);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users + "/{userID}/role-mappings/realm"));
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.POST, httpEntity);
    }

    private String getIDfromUserID(String userName) {
        JsonNode jsonNodes;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users + "?username=" + userName));
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, null);
        try {
            if (response == null) {
                return null;
            }
            jsonNodes = this.objectMapper.readTree(response);
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        if (jsonNodes.size() > 0) {
            for (JsonNode jsonNode : jsonNodes) {
                if (!userName.equals(jsonNode.get("username").asText())) continue;
                return jsonNode.get("id").asText();
            }
        }
        return null;
    }

    public boolean isUserAlreadyPresent(String userName) {
        JsonNode jsonNodes;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users + "?username=" + userName));
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, null);
        try {
            if (response == null) {
                return false;
            }
            jsonNodes = this.objectMapper.readTree(response);
        }
        catch (IOException e) {
            throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
        }
        if (jsonNodes.size() > 0) {
            for (JsonNode jsonNode : jsonNodes) {
                if (!userName.equals(jsonNode.get("username").asText())) continue;
                return true;
            }
        }
        return false;
    }

    private KeycloakRequestDto mapUserRequestToKeycloakRequestDto(UserRegistrationRequestDto userRegDto) {
        KeycloakRequestDto keycloakRequestDto = new KeycloakRequestDto();
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<KeycloakPasswordDTO> credentialObject = null;
        KeycloakPasswordDTO dto = null;
        if (userRegDto.getAppId().equalsIgnoreCase("preregistration")) {
            roles.add(INDIVIDUAL);
            credentialObject = new ArrayList<KeycloakPasswordDTO>();
            dto = new KeycloakPasswordDTO();
            dto.setType("password");
            dto.setValue(this.preRegUserPassword);
        } else if (userRegDto.getAppId().equalsIgnoreCase("registrationclient")) {
            credentialObject = new ArrayList();
            dto = new KeycloakPasswordDTO();
            dto.setType("password");
            dto.setValue(userRegDto.getUserPassword());
        }
        credentialObject.add(dto);
        ArrayList<String> contactNoList = new ArrayList<String>();
        ArrayList<String> genderList = new ArrayList<String>();
        genderList.add(userRegDto.getGender());
        contactNoList.add(userRegDto.getContactNo());
        HashMap<String, ArrayList<String>> attributes = new HashMap<String, ArrayList<String>>();
        attributes.put("mobile", contactNoList);
        attributes.put("gender", genderList);
        keycloakRequestDto.setUsername(userRegDto.getUserName());
        keycloakRequestDto.setFirstName(userRegDto.getFirstName());
        keycloakRequestDto.setEmail(userRegDto.getEmailID());
        keycloakRequestDto.setRealmRoles(roles);
        keycloakRequestDto.setAttributes(attributes);
        keycloakRequestDto.setEnabled(true);
        if (credentialObject != null) {
            keycloakRequestDto.setCredentials(credentialObject);
        }
        return keycloakRequestDto;
    }

    private void KeycloakRequestDtomapUserRequestToKeycloakRequestDto(UserRegistrationRequestDto userId) {
    }

    public UserPasswordResponseDto addPassword(UserPasswordRequestDto userPasswordRequestDto) {
        return null;
    }

    public AuthZResponseDto changePassword(PasswordDto passwordDto) throws Exception {
        return null;
    }

    public AuthZResponseDto resetPassword(PasswordDto passwordDto) throws Exception {
        return null;
    }

    public UserNameDto getUserNameBasedOnMobileNumber(String mobileNumber) throws Exception {
        return null;
    }

    public MosipUserDto authenticateUser(LoginUser loginUser) throws Exception {
        return null;
    }

    public MosipUserDto authenticateWithOtp(OtpUser otpUser) throws Exception {
        return null;
    }

    public MosipUserDto authenticateUserWithOtp(UserOtp loginUser) throws Exception {
        return null;
    }

    public MosipUserDto authenticateWithSecretKey(ClientSecret clientSecret) throws Exception {
        return null;
    }

    public MosipUserDto getUserRoleByUserId(String username) throws Exception {
        return null;
    }

    public MosipUserDto getUserDetailBasedonMobileNumber(String mobileNumber) throws Exception {
        return null;
    }

    public ValidationResponseDto validateUserName(String userId) {
        return null;
    }

    public UserDetailsResponseDto getUserDetailBasedOnUid(List<String> userIds) {
        return null;
    }

    private String callKeycloakService(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity) {
        String response;
        ResponseEntity responseEntity;
        block6: {
            responseEntity = null;
            response = null;
            try {
                responseEntity = this.restTemplate.exchange(url, httpMethod, requestEntity, String.class, new Object[0]);
            }
            catch (HttpClientErrorException | HttpServerErrorException ex) {
                List validationErrorsList = ExceptionUtils.getServiceErrorList((String)ex.getResponseBodyAsString());
                if (ex.getRawStatusCode() == 401) {
                    if (!validationErrorsList.isEmpty()) {
                        throw new AuthNException(validationErrorsList);
                    }
                    throw new BadCredentialsException("Authentication failed from AuthManager");
                }
                if (ex.getRawStatusCode() != 403) break block6;
                if (!validationErrorsList.isEmpty()) {
                    throw new AuthZException(validationErrorsList);
                }
                throw new AccessDeniedException("Access denied from AuthManager");
            }
        }
        if (responseEntity != null && responseEntity.hasBody() && responseEntity.getStatusCode() == HttpStatus.OK) {
            response = (String)responseEntity.getBody();
        }
        return response;
    }

    private List<MosipUserDto> mapUsersToUserDetailDto(JsonNode node, List<String> userDetails) {
        MosipUserDto mosipUserDto = null;
        ArrayList<MosipUserDto> mosipUserDtos = new ArrayList<MosipUserDto>();
        String roles = null;
        for (JsonNode jsonNode : node) {
            mosipUserDto = new MosipUserDto();
            String userName = jsonNode.get("username").textValue();
            System.out.println(userName);
            if (!userDetails.stream().anyMatch(user -> user.equals(userName))) continue;
            String email = jsonNode.get("email").textValue();
            JsonNode attributeNodes = jsonNode.get("attributes");
            String userPassword = attributeNodes.get("userPassword").get(0).asText();
            PasswordDetails password = PasswordUtil.splitCredentials((byte[])CryptoUtil.decodeBase64((String)userPassword));
            userPassword = DatatypeConverter.printHexBinary((byte[])password.getPassword());
            String mobile = null;
            String rid = null;
            String name = jsonNode.get("firstName").asText() + " " + jsonNode.get("lastName").asText();
            try {
                roles = this.getRolesAsString(jsonNode.get("id").textValue());
            }
            catch (IOException e) {
                throw new AuthManagerException(AuthErrorCode.IO_EXCEPTION.getErrorCode(), AuthErrorCode.IO_EXCEPTION.getErrorMessage());
            }
            if (attributeNodes.get("mobile") != null) {
                mobile = attributeNodes.get("mobile").get(0).textValue();
            }
            if (attributeNodes.get("name") != null) {
                name = jsonNode.get("firstName").asText() + " " + jsonNode.get("lastName").asText();
            }
            if (attributeNodes.get("rid") != null) {
                rid = attributeNodes.get("rid").get(0).textValue();
            }
            mosipUserDto.setMail(email);
            mosipUserDto.setMobile(mobile);
            mosipUserDto.setRId(rid);
            mosipUserDto.setUserId(userName);
            mosipUserDto.setName(name);
            mosipUserDto.setUserPassword(userPassword);
            mosipUserDto.setRole(roles);
            mosipUserDtos.add(mosipUserDto);
        }
        return mosipUserDtos;
    }

    private String getPasswordFromDatabase(String userName) {
        return (String)this.jdbcTemplate.query(FETCH_PASSWORD, (SqlParameterSource)new MapSqlParameterSource().addValue("username", (Object)userName), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getRolesAsString(String userId) throws IOException {
        StringBuilder roleBuilder = new StringBuilder();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        pathParams.put("userId", userId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakAdminUrl + this.users + this.roleUserMappingurl));
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        String response = this.callKeycloakService(uriComponentsBuilder.buildAndExpand(pathParams).toString(), HttpMethod.GET, httpEntity);
        JsonNode jsonNode = this.objectMapper.readTree(response);
        for (JsonNode node : jsonNode) {
            String role = node.get("name").textValue();
            Objects.nonNull(role);
            roleBuilder.append(role).append(",");
        }
        return roleBuilder.length() > 0 ? roleBuilder.substring(0, roleBuilder.length() - 1) : "";
    }
}

