/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.repository.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.dto.AuthZResponseDto;
import io.mosip.kernel.auth.dto.ClientSecret;
import io.mosip.kernel.auth.dto.DataBaseProps;
import io.mosip.kernel.auth.dto.LoginUser;
import io.mosip.kernel.auth.dto.MosipUserDto;
import io.mosip.kernel.auth.dto.MosipUserListDto;
import io.mosip.kernel.auth.dto.MosipUserSaltListDto;
import io.mosip.kernel.auth.dto.PasswordDto;
import io.mosip.kernel.auth.dto.RIdDto;
import io.mosip.kernel.auth.dto.RolesListDto;
import io.mosip.kernel.auth.dto.UserDetailsResponseDto;
import io.mosip.kernel.auth.dto.UserNameDto;
import io.mosip.kernel.auth.dto.UserOtp;
import io.mosip.kernel.auth.dto.UserPasswordRequestDto;
import io.mosip.kernel.auth.dto.UserPasswordResponseDto;
import io.mosip.kernel.auth.dto.UserRegistrationRequestDto;
import io.mosip.kernel.auth.dto.ValidationResponseDto;
import io.mosip.kernel.auth.dto.otp.OtpUser;
import io.mosip.kernel.auth.exception.AuthManagerException;
import io.mosip.kernel.auth.repository.DataStore;
import java.util.List;
import javax.sql.DataSource;
import org.bouncycastle.util.Arrays;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;

@Component
public class DBDataStore
implements DataStore {
    private int maximumPoolSize;
    private int validationTimeout;
    private int connectionTimeout;
    private int idleTimeout;
    private int minimumIdle;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private static final String NEW_USER_OTP = "INSERT INTO iam.user_detail(id,name,email,mobile,lang_code,cr_dtimes,is_active,status_code,cr_by)VALUES ( :userName,:name,:email,:phone,:langcode,NOW(),true,'ACT','Admin')";
    private static final String GET_USER = "select use.id,use.name,use.email,use.mobile,use.lang_code,role.code from iam.user_detail use left outer join iam.user_role userrole on use.id=userrole.usr_id left outer join iam.role_list role on role.code =userrole.role_code where use.id like :userName ";
    private static final String GET_PASSWORD = "select pwd from iam.user_pwd where usr_id like :userName ";
    private static final String GET_ROLE = "select code from iam.role_list where code like :role ";
    private static final String NEW_ROLE_OTP = "insert into iam.role_list(code,descr,lang_code,cr_dtimes,is_active,cr_by) values(:role,:description,:langCode,NOW(),true,'Admin')";
    private static final String USER_ROLE_MAPPING = "insert into iam.user_role(role_code,usr_id,lang_code,cr_dtimes,is_active,cr_by) values(:roleId,:userId,'eng',NOW(),true,'Admin');";

    public DBDataStore() {
    }

    public DBDataStore(DataBaseProps dataBaseConfig) {
        this.setUpConnection(dataBaseConfig);
    }

    public DBDataStore(DataBaseProps dataBaseConfig, int maximumPoolSize, int validationTimeout, int connectionTimeout, int idleTimeout, int minimumIdle) {
        this.maximumPoolSize = maximumPoolSize;
        this.validationTimeout = validationTimeout;
        this.connectionTimeout = connectionTimeout;
        this.idleTimeout = idleTimeout;
        this.minimumIdle = minimumIdle;
        this.setUpConnection(dataBaseConfig);
    }

    private void setUpConnection(DataBaseProps dataBaseConfig) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(dataBaseConfig.getDriverName());
        hikariConfig.setJdbcUrl(dataBaseConfig.getUrl());
        hikariConfig.setUsername(dataBaseConfig.getUsername());
        hikariConfig.setPassword(dataBaseConfig.getPassword());
        hikariConfig.setMaximumPoolSize(this.maximumPoolSize);
        hikariConfig.setValidationTimeout((long)this.validationTimeout);
        hikariConfig.setConnectionTimeout((long)this.connectionTimeout);
        hikariConfig.setIdleTimeout((long)this.idleTimeout);
        hikariConfig.setMinimumIdle(this.minimumIdle);
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)dataSource);
    }

    public MosipUserDto authenticateUser(LoginUser loginUser) throws Exception {
        MosipUserDto mosipUserDto = this.getUser(loginUser.getUserName());
        byte[] password = this.getPassword(loginUser.getUserName());
        byte[] test = loginUser.getPassword().getBytes();
        if (mosipUserDto != null && Arrays.areEqual((byte[])password, (byte[])test)) {
            return mosipUserDto;
        }
        throw new AuthManagerException(AuthErrorCode.PASSWORD_VALIDATION_ERROR.getErrorCode(), AuthErrorCode.PASSWORD_VALIDATION_ERROR.getErrorMessage());
    }

    private String getRole(String role) {
        return (String)this.jdbcTemplate.query(GET_ROLE, (SqlParameterSource)new MapSqlParameterSource().addValue("role", (Object)role), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    private byte[] getPassword(String userName) {
        return (byte[])this.jdbcTemplate.query(GET_PASSWORD, (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)userName), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    private MosipUserDto getUser(String userName) {
        return (MosipUserDto)this.jdbcTemplate.query(GET_USER, (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)userName), (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public MosipUserDto authenticateWithOtp(OtpUser otpUser) throws Exception {
        MosipUserDto mosipUserDto = this.getUser(otpUser.getUserId());
        String roleId = null;
        if (mosipUserDto == null) {
            String userId = this.createUser(otpUser);
            roleId = this.getRole("INDIVIDUAL");
            if (roleId == null) {
                roleId = this.createRole(userId, otpUser);
            }
            this.createMapping(userId, roleId);
        }
        return this.getUser(otpUser.getUserId());
    }

    private void createMapping(String userId, String roleId) {
        this.jdbcTemplate.update(USER_ROLE_MAPPING, (SqlParameterSource)new MapSqlParameterSource().addValue("userId", (Object)userId).addValue("roleId", (Object)roleId));
    }

    private String createRole(String userId, OtpUser otpUser) {
        this.jdbcTemplate.update(NEW_ROLE_OTP, (SqlParameterSource)new MapSqlParameterSource().addValue("role", (Object)"INDIVIDUAL").addValue("description", (Object)"Individual User").addValue("langCode", (Object)"eng"));
        return "INDIVIDUAL";
    }

    private String createUser(OtpUser otpUser) {
        this.jdbcTemplate.update(NEW_USER_OTP, (SqlParameterSource)new MapSqlParameterSource().addValue("userName", (Object)otpUser.getUserId()).addValue("name", (Object)otpUser.getUserId()).addValue("langcode", (Object)"eng").addValue("email", (Object)("email".equals(otpUser.getOtpChannel().get(0)) ? otpUser.getUserId() : "")).addValue("phone", (Object)("mobile".equals(otpUser.getOtpChannel().get(0)) ? otpUser.getUserId() : "")));
        return otpUser.getUserId();
    }

    public MosipUserDto authenticateUserWithOtp(UserOtp loginUser) throws Exception {
        MosipUserDto mosipUserDto = this.getUser(loginUser.getUserId());
        return mosipUserDto;
    }

    public MosipUserDto authenticateWithSecretKey(ClientSecret clientSecret) throws Exception {
        MosipUserDto mosipUserDto = this.getUser(clientSecret.getClientId());
        return mosipUserDto;
    }

    public RolesListDto getAllRoles() {
        return null;
    }

    public MosipUserListDto getListOfUsersDetails(List<String> userDetails) {
        return null;
    }

    public MosipUserSaltListDto getAllUserDetailsWithSalt() throws Exception {
        return null;
    }

    public RIdDto getRidFromUserId(String userId) throws Exception {
        return null;
    }

    public AuthZResponseDto unBlockAccount(String userId) throws Exception {
        return null;
    }

    public MosipUserDto registerUser(UserRegistrationRequestDto userId) {
        return null;
    }

    public UserPasswordResponseDto addPassword(UserPasswordRequestDto userPasswordRequestDto) {
        return null;
    }

    public AuthZResponseDto changePassword(PasswordDto passwordDto) throws Exception {
        return null;
    }

    public AuthZResponseDto resetPassword(PasswordDto passwordDto) throws Exception {
        return null;
    }

    public UserNameDto getUserNameBasedOnMobileNumber(String mobileNumber) throws Exception {
        return null;
    }

    public MosipUserDto getUserRoleByUserId(String username) {
        return null;
    }

    public MosipUserDto getUserDetailBasedonMobileNumber(String mobileNumber) throws Exception {
        return null;
    }

    public ValidationResponseDto validateUserName(String userId) {
        return null;
    }

    public UserDetailsResponseDto getUserDetailBasedOnUid(List<String> userId) {
        return null;
    }
}

