/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.controller;

import io.mosip.kernel.auth.config.MosipEnvironment;
import io.mosip.kernel.auth.constant.AuthErrorCode;
import io.mosip.kernel.auth.dto.AccessTokenResponseDTO;
import io.mosip.kernel.auth.dto.AuthNResponse;
import io.mosip.kernel.auth.dto.AuthNResponseDto;
import io.mosip.kernel.auth.dto.AuthResponseDto;
import io.mosip.kernel.auth.dto.AuthToken;
import io.mosip.kernel.auth.dto.AuthZResponseDto;
import io.mosip.kernel.auth.dto.ClientSecret;
import io.mosip.kernel.auth.dto.LoginUser;
import io.mosip.kernel.auth.dto.MosipUserDto;
import io.mosip.kernel.auth.dto.MosipUserListDto;
import io.mosip.kernel.auth.dto.MosipUserSaltListDto;
import io.mosip.kernel.auth.dto.MosipUserTokenDto;
import io.mosip.kernel.auth.dto.PasswordDto;
import io.mosip.kernel.auth.dto.RIdDto;
import io.mosip.kernel.auth.dto.RolesListDto;
import io.mosip.kernel.auth.dto.UserDetailsRequestDto;
import io.mosip.kernel.auth.dto.UserDetailsResponseDto;
import io.mosip.kernel.auth.dto.UserNameDto;
import io.mosip.kernel.auth.dto.UserOtp;
import io.mosip.kernel.auth.dto.UserPasswordRequestDto;
import io.mosip.kernel.auth.dto.UserPasswordResponseDto;
import io.mosip.kernel.auth.dto.UserRoleDto;
import io.mosip.kernel.auth.dto.ValidationResponseDto;
import io.mosip.kernel.auth.dto.otp.OtpUser;
import io.mosip.kernel.auth.exception.AuthManagerException;
import io.mosip.kernel.auth.service.AuthService;
import io.mosip.kernel.auth.service.TokenService;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.swagger.annotations.Api;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Api(value="Operation related to Authentication and Authorization", tags={"authmanager"})
public class AuthController {
    @Autowired
    private MosipEnvironment mosipEnvironment;
    @Autowired
    private AuthService authService;
    @Autowired
    private TokenService customTokenServices;

    @ResponseFilter
    @PostMapping(value={"/authenticate/useridPwd"})
    public ResponseWrapper<AuthNResponse> authenticateUseridPwd(@RequestBody @Valid RequestWrapper<LoginUser> request, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponse authNResponse = null;
        AuthNResponseDto authResponseDto = this.authService.authenticateUser((LoginUser)request.getRequest());
        if (authResponseDto != null) {
            Cookie cookie = this.createCookie(authResponseDto.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            authNResponse = new AuthNResponse();
            res.addHeader(this.mosipEnvironment.getAuthTokenHeader(), authResponseDto.getToken());
            res.addCookie(cookie);
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage());
        }
        responseWrapper.setResponse(authNResponse);
        return responseWrapper;
    }

    private AuthToken getAuthToken(AuthNResponseDto authResponseDto) {
        return new AuthToken(authResponseDto.getUserId(), authResponseDto.getToken(), authResponseDto.getExpiryTime(), authResponseDto.getRefreshToken());
    }

    private Cookie createCookie(String content, int expirationTimeSeconds) {
        Cookie cookie = new Cookie(this.mosipEnvironment.getAuthTokenHeader(), content);
        cookie.setMaxAge(expirationTimeSeconds);
        cookie.setHttpOnly(true);
        cookie.setSecure(false);
        cookie.setPath("/");
        return cookie;
    }

    @ResponseFilter
    @PostMapping(value={"/authenticate/sendotp"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseWrapper<AuthNResponse> sendOTP(@RequestBody @Valid RequestWrapper<OtpUser> otpUserDto) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponse authNResponse = null;
        AuthNResponseDto authResponseDto = this.authService.authenticateWithOtp((OtpUser)otpUserDto.getRequest());
        if (authResponseDto != null) {
            authNResponse = new AuthNResponse();
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage());
        }
        responseWrapper.setResponse(authNResponse);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authenticate/useridOTP"})
    public ResponseWrapper<AuthNResponse> userIdOTP(@RequestBody @Valid RequestWrapper<UserOtp> userOtpDto, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponse authNResponse = null;
        AuthNResponseDto authResponseDto = this.authService.authenticateUserWithOtp((UserOtp)userOtpDto.getRequest());
        if (authResponseDto != null && authResponseDto.getToken() != null) {
            Cookie cookie = this.createCookie(authResponseDto.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            authNResponse = new AuthNResponse();
            res.addHeader(this.mosipEnvironment.getAuthTokenHeader(), authResponseDto.getToken());
            res.addCookie(cookie);
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage());
        } else {
            authNResponse = new AuthNResponse();
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage() != null ? authResponseDto.getMessage() : "Otp validation failed");
        }
        responseWrapper.setResponse((Object)authNResponse);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authenticate/clientidsecretkey"})
    public ResponseWrapper<AuthNResponse> clientIdSecretKey(@RequestBody @Valid RequestWrapper<ClientSecret> clientSecretDto, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        AuthNResponse authNResponse = null;
        AuthNResponseDto authResponseDto = this.authService.authenticateWithSecretKey((ClientSecret)clientSecretDto.getRequest());
        if (authResponseDto != null) {
            Cookie cookie = this.createCookie(authResponseDto.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            authNResponse = new AuthNResponse();
            res.addHeader(this.mosipEnvironment.getAuthTokenHeader(), authResponseDto.getToken());
            res.addCookie(cookie);
            authNResponse.setStatus(authResponseDto.getStatus());
            authNResponse.setMessage(authResponseDto.getMessage());
            System.out.println("Token added in response " + authResponseDto.getToken());
        }
        System.out.println("Token in response header :::" + res.getHeader("Set-Cookie"));
        responseWrapper.setResponse((Object)authNResponse);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authorize/validateToken"})
    public ResponseWrapper<MosipUserDto> validateToken(HttpServletRequest request, HttpServletResponse res) throws AuthManagerException, Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String authToken = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            throw new AuthManagerException(AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorMessage());
        }
        MosipUserTokenDto mosipUserDtoToken = null;
        try {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().contains("Authorization")) continue;
                authToken = cookie.getValue();
            }
            if (authToken == null) {
                throw new AuthManagerException(AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorMessage());
            }
            mosipUserDtoToken = this.authService.validateToken(authToken);
            System.out.println("Token check after validate :::" + mosipUserDtoToken.getToken());
            if (mosipUserDtoToken != null) {
                mosipUserDtoToken.setMessage("Token had been validated successfully");
            }
            Cookie cookie = this.createCookie(mosipUserDtoToken.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            res.addCookie(cookie);
        }
        catch (NonceExpiredException exp) {
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), exp.getMessage());
        }
        responseWrapper.setResponse((Object)mosipUserDtoToken.getMosipUserDto());
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/authorize/admin/validateToken"})
    public ResponseWrapper<MosipUserDto> validateAdminToken(HttpServletRequest request, HttpServletResponse res) {
        String authToken = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            throw new AuthManagerException(AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorMessage());
        }
        MosipUserDto mosipUserDto = null;
        try {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().contains("Authorization")) continue;
                authToken = cookie.getValue();
            }
            if (authToken == null) {
                throw new AuthManagerException(AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorMessage());
            }
            mosipUserDto = this.authService.valdiateToken(authToken);
            Cookie cookie = this.createCookie(mosipUserDto.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
            res.addCookie(cookie);
        }
        catch (NonceExpiredException exp) {
            throw new AuthManagerException(AuthErrorCode.UNAUTHORIZED.getErrorCode(), exp.getMessage());
        }
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authorize/refreshToken"})
    public ResponseWrapper<MosipUserDto> retryToken(HttpServletRequest request, HttpServletResponse res) throws Exception {
        Cookie[] cookies;
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String authToken = null;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!cookie.getName().contains("Authorization")) continue;
            authToken = cookie.getValue();
        }
        MosipUserTokenDto mosipUserDtoToken = this.authService.retryToken(authToken);
        Cookie cookie = this.createCookie(mosipUserDtoToken.getToken(), this.mosipEnvironment.getTokenExpiry().intValue());
        res.addCookie(cookie);
        responseWrapper.setResponse((Object)mosipUserDtoToken.getMosipUserDto());
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/authorize/invalidateToken"})
    public ResponseWrapper<AuthNResponse> invalidateToken(HttpServletRequest request, HttpServletResponse res) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String authToken = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            throw new AuthManagerException(AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorMessage());
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().contains("Authorization")) continue;
            authToken = cookie.getValue();
        }
        if (authToken == null) {
            throw new AuthManagerException(AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorMessage());
        }
        AuthNResponse authNResponse = this.authService.invalidateToken(authToken);
        responseWrapper.setResponse((Object)authNResponse);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/roles/{appid}"})
    public ResponseWrapper<RolesListDto> getAllRoles(@PathVariable(value="appid") String appId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        RolesListDto rolesListDto = this.authService.getAllRoles(appId);
        responseWrapper.setResponse((Object)rolesListDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/userdetails/{appid}"})
    public ResponseWrapper<MosipUserListDto> getListOfUsersDetails(@RequestBody RequestWrapper<UserDetailsRequestDto> userDetails, @PathVariable(value="appid") String appId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        MosipUserListDto mosipUsers = this.authService.getListOfUsersDetails(((UserDetailsRequestDto)userDetails.getRequest()).getUserDetails(), appId);
        responseWrapper.setResponse((Object)mosipUsers);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/usersaltdetails/{appid}"})
    public ResponseWrapper<MosipUserSaltListDto> getUserDetailsWithSalt(@PathVariable(value="appid") String appId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        MosipUserSaltListDto mosipUsers = this.authService.getAllUserDetailsWithSalt(appId);
        responseWrapper.setResponse((Object)mosipUsers);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"rid/{appid}/{userid}"})
    public ResponseWrapper<RIdDto> getRId(@PathVariable(value="appid") String appId, @PathVariable(value="userid") String userId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        RIdDto rIdDto = this.authService.getRidBasedOnUid(userId, appId);
        responseWrapper.setResponse((Object)rIdDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"unblock/{appid}/{userid}"})
    public ResponseWrapper<AuthZResponseDto> getUserName(@PathVariable(value="appid") String appId, @PathVariable(value="userid") String userId) throws Exception {
        AuthZResponseDto authZResponseDto = this.authService.unBlockUser(userId, appId);
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)authZResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/changepassword/{appid}"})
    public ResponseWrapper<AuthZResponseDto> changePassword(@PathVariable(value="appid") String appId, @RequestBody @Valid RequestWrapper<PasswordDto> passwordDto) throws Exception {
        AuthZResponseDto mosipUserDto = this.authService.changePassword(appId, (PasswordDto)passwordDto.getRequest());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/resetpassword/{appid}"})
    public ResponseWrapper<AuthZResponseDto> resetPassword(@PathVariable(value="appid") String appId, @RequestBody @Valid RequestWrapper<PasswordDto> passwordDto) throws Exception {
        AuthZResponseDto mosipUserDto = this.authService.resetPassword(appId, (PasswordDto)passwordDto.getRequest());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/username/{appid}/{mobilenumber}"})
    public ResponseWrapper<UserNameDto> getUsernameBasedOnMobileNumber(@PathVariable(value="mobilenumber") String mobile, @PathVariable(value="appid") String appId) throws Exception {
        UserNameDto userNameDto = this.authService.getUserNameBasedOnMobileNumber(appId, mobile);
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)userNameDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/user/addpassword"})
    public ResponseWrapper<UserPasswordResponseDto> addPassword(@RequestBody @Valid RequestWrapper<UserPasswordRequestDto> userPasswordRequestDto) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)this.authService.addUserPassword((UserPasswordRequestDto)userPasswordRequestDto.getRequest()));
        return responseWrapper;
    }

    @GetMapping(value={"/role/{appId}/{userId}"})
    @ResponseFilter
    public ResponseWrapper<UserRoleDto> getUserRole(@PathVariable(value="appId") String appId, @PathVariable(value="userId") String userId) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        UserRoleDto userRole = this.authService.getUserRole(appId, userId);
        responseWrapper.setResponse((Object)userRole);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/userdetail/{appid}/{mobilenumber}"})
    public ResponseWrapper<MosipUserDto> getUserDetailBasedOnMobileNumber(@PathVariable(value="mobilenumber") String mobile, @PathVariable(value="appid") String appId) throws Exception {
        MosipUserDto mosipUserDto = this.authService.getUserDetailBasedonMobileNumber(appId, mobile);
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/validate/{appid}/{userid}"})
    public ResponseWrapper<ValidationResponseDto> validateUserName(@PathVariable(value="userid") String userId, @PathVariable(value="appid") String appId) {
        ValidationResponseDto validationResponseDto = this.authService.validateUserName(appId, userId);
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)validationResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/userdetail/regid/{appid}"})
    public ResponseWrapper<UserDetailsResponseDto> getUserDetailBasedOnUserId(@PathVariable(value="appid") String appId, @RequestBody RequestWrapper<UserDetailsRequestDto> userDetails) {
        UserDetailsResponseDto userDetailsDto = this.authService.getUserDetailBasedOnUserId(appId, ((UserDetailsRequestDto)userDetails.getRequest()).getUserDetails());
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)userDetailsDto);
        return responseWrapper;
    }

    @ResponseFilter
    @DeleteMapping(value={"/logout/user"})
    public ResponseWrapper<AuthResponseDto> logoutUser(@CookieValue(value="Authorization", required=false) String token, HttpServletResponse res) {
        AuthResponseDto authResponseDto = this.authService.logoutUser(token);
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)authResponseDto);
        return responseWrapper;
    }

    @GetMapping(value={"/login/{redirectURI}"})
    public void login(@CookieValue(value="state") String state, @PathVariable(value="redirectURI") String redirectURI, HttpServletResponse res) throws IOException {
        String uri = this.authService.getKeycloakURI(redirectURI, state);
        res.setStatus(302);
        res.sendRedirect(uri);
    }

    @GetMapping(value={"/login-redirect/{redirectURI}"})
    public void loginRedirect(@PathVariable(value="redirectURI") String redirectURI, @RequestParam(value="state") String state, @RequestParam(value="session_state") String sessionState, @RequestParam(value="code") String code, @CookieValue(value="state") String stateCookie, HttpServletResponse res) throws IOException {
        AccessTokenResponseDTO jwtResponseDTO = this.authService.loginRedirect(state, sessionState, code, stateCookie, redirectURI);
        String uri = new String(Base64.decodeBase64((byte[])redirectURI.getBytes()));
        Cookie cookie = this.createCookie(jwtResponseDTO.getAccessToken(), Integer.parseInt(jwtResponseDTO.getExpiresIn()));
        res.addCookie(cookie);
        res.setStatus(302);
        res.sendRedirect(uri);
    }

    private String getTokenFromCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        String token = null;
        if (cookies == null) {
            throw new AuthManagerException(AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.COOKIE_NOTPRESENT_ERROR.getErrorMessage());
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().contains("Authorization")) continue;
            token = cookie.getValue();
            this.removeCookie(cookie);
            break;
        }
        if (token == null) {
            throw new AuthManagerException(AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorCode(), AuthErrorCode.TOKEN_NOTPRESENT_ERROR.getErrorMessage());
        }
        return token;
    }

    private void removeCookie(Cookie cookie) {
        cookie.setValue("");
        cookie.setPath("/");
        cookie.setMaxAge(0);
    }
}

