/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SpringDataSourceConfig {
    @Autowired
    private Environment env;
    @Value(value="${hikari.maximumPoolSize:25}")
    private int maximumPoolSize;
    @Value(value="${hikari.validationTimeout:3000}")
    private int validationTimeout;
    @Value(value="${hikari.connectionTimeout:60000}")
    private int connectionTimeout;
    @Value(value="${hikari.idleTimeout:200000}")
    private int idleTimeout;
    @Value(value="${hikari.minimumIdle:0}")
    private int minimumIdle;

    @Bean
    public DataSource dataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(this.env.getProperty("iam.datasource.driverClassName"));
        hikariConfig.setJdbcUrl(this.env.getProperty("iam.datasource.url"));
        hikariConfig.setUsername(this.env.getProperty("iam.datasource.username"));
        hikariConfig.setPassword(this.env.getProperty("iam.datasource.password"));
        hikariConfig.setMaximumPoolSize(this.maximumPoolSize);
        hikariConfig.setValidationTimeout((long)this.validationTimeout);
        hikariConfig.setConnectionTimeout((long)this.connectionTimeout);
        hikariConfig.setIdleTimeout((long)this.idleTimeout);
        hikariConfig.setMinimumIdle(this.minimumIdle);
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        return dataSource;
    }
}

