/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.auth.config;

import io.mosip.kernel.auth.dto.AccessTokenResponse;
import io.mosip.kernel.auth.util.MemoryCache;
import io.mosip.kernel.auth.util.TokenValidator;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class RestInterceptor
implements ClientHttpRequestInterceptor {
    @Autowired
    private MemoryCache<String, AccessTokenResponse> memoryCache;
    @Autowired
    private TokenValidator tokenValidator;
    @Qualifier(value="authRestTemplate")
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${mosip.kernel.open-id-url}")
    private String keycloakOpenIdUrl;
    @Value(value="${mosip.master.realm-id}")
    private String realmId;
    @Value(value="${mosip.keycloak.admin.client.id}")
    private String adminClientID;
    @Value(value="${mosip.keycloak.admin.user.id}")
    private String adminUserName;
    @Value(value="${mosip.keycloak.admin.secret.key}")
    private String adminSecret;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        AccessTokenResponse accessTokenResponse = null;
        accessTokenResponse = (AccessTokenResponse)this.memoryCache.get((Object)"adminToken");
        if (accessTokenResponse != null) {
            boolean accessTokenExpired = this.tokenValidator.isExpired(accessTokenResponse.getAccess_token());
            boolean refreshTokenExpired = this.tokenValidator.isExpired(accessTokenResponse.getRefresh_token());
            System.out.println("access token " + accessTokenResponse.getAccess_token());
            System.out.println("refresh token " + accessTokenResponse.getRefresh_token());
            System.out.println(accessTokenExpired);
            System.out.println(refreshTokenExpired);
            if (accessTokenExpired && refreshTokenExpired) {
                accessTokenResponse = this.getAdminToken(false, null);
            } else if (accessTokenExpired) {
                accessTokenResponse = this.getAdminToken(true, accessTokenResponse.getRefresh_token());
            }
        } else {
            accessTokenResponse = this.getAdminToken(false, null);
        }
        this.memoryCache.put((Object)"adminToken", (Object)accessTokenResponse);
        request.getHeaders().add("Authorization", "Bearer " + accessTokenResponse.getAccess_token());
        return execution.execute(request, body);
    }

    private AccessTokenResponse getAdminToken(boolean isGetRefreshToken, String refreshToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap tokenRequestBody = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("realmId", this.realmId);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)(this.keycloakOpenIdUrl + "/token"));
        tokenRequestBody = isGetRefreshToken ? this.getAdminValueMap(refreshToken) : this.getAdminValueMap();
        HttpEntity request = new HttpEntity((Object)tokenRequestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(uriComponentsBuilder.buildAndExpand(pathParams).toUriString(), (Object)request, AccessTokenResponse.class, new Object[0]);
        return (AccessTokenResponse)response.getBody();
    }

    private MultiValueMap<String, String> getAdminValueMap() {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"password");
        map.add((Object)"username", (Object)this.adminUserName);
        map.add((Object)"password", (Object)this.adminSecret);
        map.add((Object)"client_id", (Object)this.adminClientID);
        return map;
    }

    private MultiValueMap<String, String> getAdminValueMap(String refreshToken) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"refresh_token", (Object)refreshToken);
        map.add((Object)"client_id", (Object)this.adminClientID);
        return map;
    }
}

