/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.udp;

import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.DatagramChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.udp.UdpInbound;
import reactor.ipc.netty.udp.UdpOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;

final class UdpOperations
extends ChannelOperations<UdpInbound, UdpOutbound>
implements UdpInbound,
UdpOutbound {
    final DatagramChannel datagramChannel;
    static final Logger log = Loggers.getLogger(UdpOperations.class);

    static UdpOperations bind(DatagramChannel channel, BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        return new UdpOperations(channel, handler, context);
    }

    UdpOperations(DatagramChannel channel, BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        super(channel, handler, context);
        this.datagramChannel = channel;
    }

    @Override
    public Mono<Void> join(InetAddress multicastAddress, NetworkInterface iface) {
        if (null == iface && null != this.datagramChannel.config().getNetworkInterface()) {
            iface = this.datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? this.datagramChannel.joinGroup(new InetSocketAddress(multicastAddress, this.datagramChannel.localAddress().getPort()), iface) : this.datagramChannel.joinGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> log.info("JOIN {}", multicastAddress));
    }

    @Override
    public Mono<Void> leave(InetAddress multicastAddress, NetworkInterface iface) {
        if (null == iface && null != this.datagramChannel.config().getNetworkInterface()) {
            iface = this.datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? this.datagramChannel.leaveGroup(new InetSocketAddress(multicastAddress, this.datagramChannel.localAddress().getPort()), iface) : this.datagramChannel.leaveGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> log.info("JOIN {}", multicastAddress));
    }
}

