/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel.data;

import io.netty.channel.ChannelHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.channel.data.FileChunkedStrategy;

public abstract class AbstractFileChunkedStrategy<T>
implements FileChunkedStrategy<T> {
    @Override
    public final void preparePipeline(NettyContext context) {
        if (!this.hasChunkedWriter(context)) {
            boolean hasReactiveBridge;
            boolean bl = hasReactiveBridge = context.channel().pipeline().get("reactor.right.reactiveBridge") != null;
            if (hasReactiveBridge) {
                context.channel().pipeline().addBefore("reactor.right.reactiveBridge", "reactor.left.chunkedWriter", new ChunkedWriteHandler());
            } else {
                context.channel().pipeline().addLast("reactor.left.chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
            }
        }
    }

    private boolean hasChunkedWriter(NettyContext context) {
        return context.channel().pipeline().get("reactor.left.chunkedWriter") != null;
    }

    @Override
    public final void cleanupPipeline(NettyContext context) {
        if (this.hasChunkedWriter(context)) {
            context.channel().pipeline().remove("reactor.left.chunkedWriter");
        }
        this.afterWrite(context);
    }

    protected void afterWrite(NettyContext context) {
    }
}

