/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.multipart.MultipartUtils;
import org.synchronoss.cloud.nio.multipart.PartBodyStreamStorageFactory;
import org.synchronoss.cloud.nio.stream.storage.FileStreamStorage;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;

public class DefaultPartBodyStreamStorageFactory
implements PartBodyStreamStorageFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultPartBodyStreamStorageFactory.class);
    public static final int DEFAULT_MAX_THRESHOLD = 10240;
    static final String DEFAULT_TEMP_FOLDER = System.getProperty("java.io.tmpdir") + "/nio-file-upload";
    final File tempFolder;
    final int maxSizeThreshold;

    public DefaultPartBodyStreamStorageFactory(String tempFolderPath, int maxSizeThreshold) {
        this.maxSizeThreshold = maxSizeThreshold > 0 ? maxSizeThreshold : 0;
        this.tempFolder = new File(tempFolderPath);
        if (!this.tempFolder.exists() && !this.tempFolder.mkdirs()) {
            throw new IllegalStateException("Unable to create the temporary folder: " + tempFolderPath);
        }
        if (log.isDebugEnabled()) {
            log.debug("Temporary folder: " + this.tempFolder.getAbsolutePath());
        }
    }

    public DefaultPartBodyStreamStorageFactory(String tempFolderPath) {
        this(tempFolderPath, 10240);
    }

    public DefaultPartBodyStreamStorageFactory(int maxSizeThreshold) {
        this(DEFAULT_TEMP_FOLDER, maxSizeThreshold);
    }

    public DefaultPartBodyStreamStorageFactory() {
        this(DEFAULT_TEMP_FOLDER, 10240);
    }

    @Override
    public StreamStorage newStreamStorageForPartBody(Map<String, List<String>> partHeaders, int partIndex) {
        return FileStreamStorage.deferred(this.getTempFile(partIndex), this.getThreshold(partHeaders)).deleteFilesOnClose().deleteFilesOnDispose();
    }

    protected int getThreshold(Map<String, List<String>> partHeaders) {
        long contentLength = MultipartUtils.getContentLength(partHeaders);
        return contentLength > (long)this.maxSizeThreshold ? 0 : this.maxSizeThreshold;
    }

    protected File getTempFile(int partIndex) {
        String tempFileName = String.format("nio-body-%d-%s.tmp", partIndex, UUID.randomUUID().toString());
        return new File(this.tempFolder, tempFileName);
    }
}

