/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.SpringObjenesis;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.CompositeUriComponentsContributor;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class MvcUriComponentsBuilder {
    public static final String MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME = "mvcUriComponentsContributor";
    private static final Log logger = LogFactory.getLog(MvcUriComponentsBuilder.class);
    private static final SpringObjenesis objenesis = new SpringObjenesis();
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private static final CompositeUriComponentsContributor defaultUriComponentsContributor = new CompositeUriComponentsContributor(new PathVariableMethodArgumentResolver(), new RequestParamMethodArgumentResolver(false));
    private final UriComponentsBuilder baseUrl;

    protected MvcUriComponentsBuilder(UriComponentsBuilder baseUrl) {
        Assert.notNull((Object)baseUrl, "'baseUrl' is required");
        this.baseUrl = baseUrl;
    }

    public static MvcUriComponentsBuilder relativeTo(UriComponentsBuilder baseUrl) {
        return new MvcUriComponentsBuilder(baseUrl);
    }

    public static UriComponentsBuilder fromController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(null, controllerType);
    }

    public static UriComponentsBuilder fromController(@Nullable UriComponentsBuilder builder, Class<?> controllerType) {
        builder = MvcUriComponentsBuilder.getBaseUrlToUse(builder);
        String mapping = MvcUriComponentsBuilder.getTypeRequestMapping(controllerType);
        return builder.path(mapping);
    }

    public static UriComponentsBuilder fromMethodName(Class<?> controllerType, String methodName, Object ... args) {
        Method method2 = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args);
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method2, args);
    }

    public static UriComponentsBuilder fromMethodName(UriComponentsBuilder builder, Class<?> controllerType, String methodName, Object ... args) {
        Method method2 = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args);
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method2, args);
    }

    public static UriComponentsBuilder fromMethodCall(Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, info, "MethodInvocationInfo required");
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method2 = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method2, arguments);
    }

    public static UriComponentsBuilder fromMethodCall(UriComponentsBuilder builder, Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, info, "MethodInvocationInfo required");
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method2 = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method2, arguments);
    }

    public static MethodArgumentBuilder fromMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(null, mappingName);
    }

    public static MethodArgumentBuilder fromMappingName(@Nullable UriComponentsBuilder builder, String name) {
        RequestMappingInfoHandlerMapping handlerMapping = MvcUriComponentsBuilder.getRequestMappingInfoHandlerMapping();
        List<HandlerMethod> handlerMethods = handlerMapping.getHandlerMethodsForMappingName(name);
        if (handlerMethods == null) {
            throw new IllegalArgumentException("Mapping mappingName not found: " + name);
        }
        if (handlerMethods.size() != 1) {
            throw new IllegalArgumentException("No unique match for mapping mappingName " + name + ": " + handlerMethods);
        }
        HandlerMethod handlerMethod = handlerMethods.get(0);
        Class<?> controllerType = handlerMethod.getBeanType();
        Method method2 = handlerMethod.getMethod();
        return new MethodArgumentBuilder(builder, controllerType, method2);
    }

    public static UriComponentsBuilder fromMethod(Class<?> controllerType, Method method2, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method2, args);
    }

    public static UriComponentsBuilder fromMethod(UriComponentsBuilder baseUrl, @Nullable Class<?> controllerType, Method method2, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(baseUrl, controllerType != null ? controllerType : method2.getDeclaringClass(), method2, args);
    }

    private static UriComponentsBuilder fromMethodInternal(@Nullable UriComponentsBuilder baseUrl, Class<?> controllerType, Method method2, Object ... args) {
        baseUrl = MvcUriComponentsBuilder.getBaseUrlToUse(baseUrl);
        String typePath = MvcUriComponentsBuilder.getTypeRequestMapping(controllerType);
        String methodPath = MvcUriComponentsBuilder.getMethodRequestMapping(method2);
        String path2 = pathMatcher.combine(typePath, methodPath);
        baseUrl.path(path2);
        UriComponents uriComponents = MvcUriComponentsBuilder.applyContributors(baseUrl, method2, args);
        return UriComponentsBuilder.newInstance().uriComponents(uriComponents);
    }

    private static UriComponentsBuilder getBaseUrlToUse(@Nullable UriComponentsBuilder baseUrl) {
        if (baseUrl != null) {
            return baseUrl.cloneBuilder();
        }
        return ServletUriComponentsBuilder.fromCurrentServletMapping();
    }

    private static String getTypeRequestMapping(Class<?> controllerType) {
        Assert.notNull(controllerType, "'controllerType' must not be null");
        RequestMapping requestMapping = AnnotatedElementUtils.findMergedAnnotation(controllerType, RequestMapping.class);
        if (requestMapping == null) {
            return "/";
        }
        Object[] paths = requestMapping.path();
        if (ObjectUtils.isEmpty(paths) || StringUtils.isEmpty(paths[0])) {
            return "/";
        }
        if (paths.length > 1 && logger.isWarnEnabled()) {
            logger.warn("Multiple paths on controller " + controllerType.getName() + ", using first one");
        }
        return paths[0];
    }

    private static String getMethodRequestMapping(Method method2) {
        Assert.notNull((Object)method2, "'method' must not be null");
        RequestMapping requestMapping = AnnotatedElementUtils.findMergedAnnotation(method2, RequestMapping.class);
        if (requestMapping == null) {
            throw new IllegalArgumentException("No @RequestMapping on: " + method2.toGenericString());
        }
        Object[] paths = requestMapping.path();
        if (ObjectUtils.isEmpty(paths) || StringUtils.isEmpty(paths[0])) {
            return "/";
        }
        if (paths.length > 1 && logger.isWarnEnabled()) {
            logger.warn("Multiple paths on method " + method2.toGenericString() + ", using first one");
        }
        return paths[0];
    }

    private static Method getMethod(Class<?> controllerType, String methodName, Object ... args) {
        ReflectionUtils.MethodFilter selector = method2 -> {
            String name = method2.getName();
            int argLength = method2.getParameterCount();
            return name.equals(methodName) && argLength == args.length;
        };
        Set<Method> methods = MethodIntrospector.selectMethods(controllerType, selector);
        if (methods.size() == 1) {
            return methods.iterator().next();
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(String.format("Found two methods named '%s' accepting arguments %s in controller %s: [%s]", methodName, Arrays.asList(args), controllerType.getName(), methods));
        }
        throw new IllegalArgumentException("No method named '" + methodName + "' with " + args.length + " arguments found in controller " + controllerType.getName());
    }

    private static UriComponents applyContributors(UriComponentsBuilder builder, Method method2, Object ... args) {
        int argCount;
        int paramCount;
        CompositeUriComponentsContributor contributor = MvcUriComponentsBuilder.getConfiguredUriComponentsContributor();
        if (contributor == null) {
            logger.debug("Using default CompositeUriComponentsContributor");
            contributor = defaultUriComponentsContributor;
        }
        if ((paramCount = method2.getParameterCount()) != (argCount = args.length)) {
            throw new IllegalArgumentException("Number of method parameters " + paramCount + " does not match number of argument values " + argCount);
        }
        HashMap<String, Object> uriVars = new HashMap<String, Object>();
        for (int i = 0; i < paramCount; ++i) {
            SynthesizingMethodParameter param = new SynthesizingMethodParameter(method2, i);
            param.initParameterNameDiscovery(parameterNameDiscoverer);
            contributor.contributeMethodArgument(param, args[i], builder, uriVars);
        }
        return builder.build().expand(name -> uriVars.getOrDefault(name, UriComponents.UriTemplateVariables.SKIP_VALUE));
    }

    @Nullable
    private static CompositeUriComponentsContributor getConfiguredUriComponentsContributor() {
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        if (wac == null) {
            return null;
        }
        try {
            return wac.getBean(MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME, CompositeUriComponentsContributor.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("No CompositeUriComponentsContributor bean with name 'mvcUriComponentsContributor'");
            }
            return null;
        }
    }

    private static RequestMappingInfoHandlerMapping getRequestMappingInfoHandlerMapping() {
        WebApplicationContext wac = MvcUriComponentsBuilder.getWebApplicationContext();
        Assert.notNull((Object)wac, "Cannot lookup handler method mappings without WebApplicationContext");
        try {
            return wac.getBean(RequestMappingInfoHandlerMapping.class);
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException("More than one RequestMappingInfoHandlerMapping beans found", ex);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new IllegalStateException("No RequestMappingInfoHandlerMapping bean", ex);
        }
    }

    @Nullable
    private static WebApplicationContext getWebApplicationContext() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            logger.debug("No request bound to the current thread: not in a DispatcherServlet request?");
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        WebApplicationContext wac = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (wac == null) {
            logger.debug("No WebApplicationContext found: not in a DispatcherServlet request?");
            return null;
        }
        return wac;
    }

    public static <T> T on(Class<T> controllerType) {
        return MvcUriComponentsBuilder.controller(controllerType);
    }

    public static <T> T controller(Class<T> controllerType) {
        Assert.notNull(controllerType, "'controllerType' must not be null");
        return MvcUriComponentsBuilder.initProxy(controllerType, new ControllerMethodInvocationInterceptor(controllerType));
    }

    private static <T> T initProxy(Class<?> type, ControllerMethodInvocationInterceptor interceptor) {
        if (type == Object.class) {
            return (T)interceptor;
        }
        if (type.isInterface()) {
            ProxyFactory factory = new ProxyFactory(EmptyTargetSource.INSTANCE);
            factory.addInterface(type);
            factory.addInterface(MethodInvocationInfo.class);
            factory.addAdvice(interceptor);
            return (T)factory.getProxy();
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setInterfaces(new Class[]{MethodInvocationInfo.class});
        enhancer.setNamingPolicy(SpringNamingPolicy.INSTANCE);
        enhancer.setCallbackType(MethodInterceptor.class);
        Class proxyClass = enhancer.createClass();
        T proxy = null;
        if (objenesis.isWorthTrying()) {
            try {
                proxy = objenesis.newInstance(proxyClass, enhancer.getUseCache());
            }
            catch (ObjenesisException ex) {
                logger.debug("Unable to instantiate controller proxy using Objenesis, falling back to regular construction", ex);
            }
        }
        if (proxy == null) {
            try {
                proxy = ReflectionUtils.accessibleConstructor(proxyClass, new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to instantiate controller proxy using Objenesis, and regular controller instantiation via default constructor fails as well", ex);
            }
        }
        ((Factory)proxy).setCallbacks(new Callback[]{interceptor});
        return proxy;
    }

    public UriComponentsBuilder withController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(this.baseUrl, controllerType);
    }

    public UriComponentsBuilder withMethodName(Class<?> controllerType, String methodName, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodName(this.baseUrl, controllerType, methodName, args);
    }

    public UriComponentsBuilder withMethodCall(Object invocationInfo) {
        return MvcUriComponentsBuilder.fromMethodCall(this.baseUrl, invocationInfo);
    }

    public MethodArgumentBuilder withMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(this.baseUrl, mappingName);
    }

    public UriComponentsBuilder withMethod(Class<?> controllerType, Method method2, Object ... args) {
        return MvcUriComponentsBuilder.fromMethod(this.baseUrl, controllerType, method2, args);
    }

    public static class MethodArgumentBuilder {
        private final Class<?> controllerType;
        private final Method method;
        private final Object[] argumentValues;
        private final UriComponentsBuilder baseUrl;

        public MethodArgumentBuilder(Class<?> controllerType, Method method2) {
            this(null, controllerType, method2);
        }

        public MethodArgumentBuilder(@Nullable UriComponentsBuilder baseUrl, Class<?> controllerType, Method method2) {
            Assert.notNull(controllerType, "'controllerType' is required");
            Assert.notNull((Object)method2, "'method' is required");
            this.baseUrl = baseUrl != null ? baseUrl : MethodArgumentBuilder.initBaseUrl();
            this.controllerType = controllerType;
            this.method = method2;
            this.argumentValues = new Object[method2.getParameterCount()];
            for (int i = 0; i < this.argumentValues.length; ++i) {
                this.argumentValues[i] = null;
            }
        }

        private static UriComponentsBuilder initBaseUrl() {
            ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentServletMapping();
            String path2 = builder.build().getPath();
            return path2 != null ? UriComponentsBuilder.fromPath(path2) : UriComponentsBuilder.newInstance();
        }

        public MethodArgumentBuilder arg(int index, Object value) {
            this.argumentValues[index] = value;
            return this;
        }

        public String build() {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).build(false).encode().toUriString();
        }

        public String buildAndExpand(Object ... uriVars) {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).build(false).expand(uriVars).encode().toString();
        }
    }

    private static class ControllerMethodInvocationInterceptor
    implements MethodInterceptor,
    org.aopalliance.intercept.MethodInterceptor,
    MethodInvocationInfo {
        private final Class<?> controllerType;
        @Nullable
        private Method controllerMethod;
        @Nullable
        private Object[] argumentValues;

        ControllerMethodInvocationInterceptor(Class<?> controllerType) {
            this.controllerType = controllerType;
        }

        @Override
        @Nullable
        public Object intercept(Object obj, Method method2, Object[] args, @Nullable MethodProxy proxy) {
            if (method2.getName().equals("getControllerType")) {
                return this.controllerType;
            }
            if (method2.getName().equals("getControllerMethod")) {
                return this.controllerMethod;
            }
            if (method2.getName().equals("getArgumentValues")) {
                return this.argumentValues;
            }
            if (ReflectionUtils.isObjectMethod(method2)) {
                return ReflectionUtils.invokeMethod(method2, obj, args);
            }
            this.controllerMethod = method2;
            this.argumentValues = args;
            Class<?> returnType = method2.getReturnType();
            try {
                return returnType == Void.TYPE ? null : returnType.cast(MvcUriComponentsBuilder.initProxy(returnType, this));
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to create proxy for controller method return type: " + method2, ex);
            }
        }

        @Override
        @Nullable
        public Object invoke(MethodInvocation inv) throws Throwable {
            return this.intercept(inv.getThis(), inv.getMethod(), inv.getArguments(), null);
        }

        @Override
        public Class<?> getControllerType() {
            return this.controllerType;
        }

        @Override
        public Method getControllerMethod() {
            Assert.state(this.controllerMethod != null, "Not initialized yet");
            return this.controllerMethod;
        }

        @Override
        public Object[] getArgumentValues() {
            Assert.state(this.argumentValues != null, "Not initialized yet");
            return this.argumentValues;
        }
    }

    public static interface MethodInvocationInfo {
        public Class<?> getControllerType();

        public Method getControllerMethod();

        public Object[] getArgumentValues();
    }
}

