/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.servlet.mvc.condition.AbstractNameValueExpression;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;

public final class HeadersRequestCondition
extends AbstractRequestCondition<HeadersRequestCondition> {
    private static final HeadersRequestCondition PRE_FLIGHT_MATCH = new HeadersRequestCondition(new String[0]);
    private final Set<HeaderExpression> expressions;

    public HeadersRequestCondition(String ... headers2) {
        this(HeadersRequestCondition.parseExpressions(headers2));
    }

    private HeadersRequestCondition(Collection<HeaderExpression> conditions) {
        this.expressions = Collections.unmodifiableSet(new LinkedHashSet<HeaderExpression>(conditions));
    }

    private static Collection<HeaderExpression> parseExpressions(String ... headers2) {
        LinkedHashSet<HeaderExpression> expressions = new LinkedHashSet<HeaderExpression>();
        for (String header : headers2) {
            HeaderExpression expr = new HeaderExpression(header);
            if ("Accept".equalsIgnoreCase(expr.name) || "Content-Type".equalsIgnoreCase(expr.name)) continue;
            expressions.add(expr);
        }
        return expressions;
    }

    public Set<NameValueExpression<String>> getExpressions() {
        return new LinkedHashSet<NameValueExpression<String>>(this.expressions);
    }

    @Override
    protected Collection<HeaderExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public HeadersRequestCondition combine(HeadersRequestCondition other) {
        LinkedHashSet<HeaderExpression> set = new LinkedHashSet<HeaderExpression>(this.expressions);
        set.addAll(other.expressions);
        return new HeadersRequestCondition(set);
    }

    @Override
    @Nullable
    public HeadersRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (CorsUtils.isPreFlightRequest(request)) {
            return PRE_FLIGHT_MATCH;
        }
        for (HeaderExpression expression : this.expressions) {
            if (expression.match(request)) continue;
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(HeadersRequestCondition other, HttpServletRequest request) {
        return other.expressions.size() - this.expressions.size();
    }

    static class HeaderExpression
    extends AbstractNameValueExpression<String> {
        public HeaderExpression(String expression) {
            super(expression);
        }

        @Override
        protected boolean isCaseSensitiveName() {
            return false;
        }

        @Override
        protected String parseValue(String valueExpression) {
            return valueExpression;
        }

        @Override
        protected boolean matchName(HttpServletRequest request) {
            return request.getHeader(this.name) != null;
        }

        @Override
        protected boolean matchValue(HttpServletRequest request) {
            return ObjectUtils.nullSafeEquals(this.value, request.getHeader(this.name));
        }
    }
}

