/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.support;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;

@Deprecated
public abstract class AbstractDispatcherHandlerInitializer
implements WebApplicationInitializer {
    public static final String DEFAULT_SERVLET_NAME = "dispatcher-handler";
    public static final String DEFAULT_SERVLET_MAPPING = "/";

    @Override
    public void onStartup(ServletContext servletContext) throws ServletException {
        this.registerDispatcherHandler(servletContext);
    }

    protected void registerDispatcherHandler(ServletContext servletContext) {
        String servletName = this.getServletName();
        Assert.hasLength(servletName, "getServletName() must not return null or empty");
        ApplicationContext applicationContext = this.createApplicationContext();
        Assert.notNull((Object)applicationContext, "createApplicationContext() must not return null");
        this.refreshApplicationContext(applicationContext);
        this.registerCloseListener(servletContext, applicationContext);
        WebHandler dispatcherHandler = this.createDispatcherHandler(applicationContext);
        Assert.notNull((Object)dispatcherHandler, "createDispatcherHandler(ApplicationContext) must not return null");
        ServletHttpHandlerAdapter handlerAdapter = this.createHandlerAdapter(dispatcherHandler);
        Assert.notNull((Object)handlerAdapter, "createHandlerAdapter(WebHandler) must not return null");
        ServletRegistration.Dynamic registration = servletContext.addServlet(servletName, handlerAdapter);
        if (registration == null) {
            throw new IllegalStateException("Failed to register servlet with name '" + servletName + "'. Check if there is another servlet registered under the same name.");
        }
        registration.setLoadOnStartup(1);
        registration.addMapping(this.getServletMapping());
        registration.setAsyncSupported(true);
        this.customizeRegistration(registration);
    }

    protected String getServletName() {
        return DEFAULT_SERVLET_NAME;
    }

    protected abstract ApplicationContext createApplicationContext();

    protected void refreshApplicationContext(ApplicationContext context) {
        ConfigurableApplicationContext cac;
        if (context instanceof ConfigurableApplicationContext && !(cac = (ConfigurableApplicationContext)context).isActive()) {
            cac.refresh();
        }
    }

    protected WebHandler createDispatcherHandler(ApplicationContext applicationContext) {
        return new DispatcherHandler(applicationContext);
    }

    protected ServletHttpHandlerAdapter createHandlerAdapter(WebHandler webHandler) {
        HttpWebHandlerAdapter httpHandler = new HttpWebHandlerAdapter(webHandler);
        return new ServletHttpHandlerAdapter(httpHandler);
    }

    protected String getServletMapping() {
        return DEFAULT_SERVLET_MAPPING;
    }

    protected void customizeRegistration(ServletRegistration.Dynamic registration) {
    }

    protected void registerCloseListener(ServletContext servletContext, ApplicationContext applicationContext) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)applicationContext;
            ServletContextDestroyedListener listener = new ServletContextDestroyedListener(context);
            servletContext.addListener(listener);
        }
    }

    private static class ServletContextDestroyedListener
    implements ServletContextListener {
        private final ConfigurableApplicationContext applicationContext;

        public ServletContextDestroyedListener(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Override
        public void contextInitialized(ServletContextEvent sce) {
        }

        @Override
        public void contextDestroyed(ServletContextEvent sce) {
            this.applicationContext.close();
        }
    }
}

