/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.security.Principal;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.server.HttpServerResponse;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol) {
        ServerHttpResponse response = exchange2.getResponse();
        HttpServerResponse nativeResponse = (HttpServerResponse)((AbstractServerHttpResponse)response).getNativeResponse();
        HandshakeInfo info = this.getHandshakeInfo(exchange2, subProtocol);
        NettyDataBufferFactory bufferFactory = (NettyDataBufferFactory)response.bufferFactory();
        return nativeResponse.sendWebsocket(subProtocol, (in, out) -> handler.handle(new ReactorNettyWebSocketSession((WebsocketInbound)in, (WebsocketOutbound)out, info, bufferFactory)));
    }

    private HandshakeInfo getHandshakeInfo(ServerWebExchange exchange2, @Nullable String protocol) {
        ServerHttpRequest request = exchange2.getRequest();
        Mono<Principal> principal = exchange2.getPrincipal();
        return new HandshakeInfo(request.getURI(), request.getHeaders(), principal, protocol);
    }
}

