/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class ExpressionValueMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public ExpressionValueMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        return this.checkAnnotatedParamNoReactiveWrapper(param, Value.class, (ann, type) -> true);
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        Value ann = parameter.getParameterAnnotation(Value.class);
        Assert.state(ann != null, "No Value annotation");
        return new ExpressionValueNamedValueInfo(ann);
    }

    @Override
    protected Object resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange2) {
        return null;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new UnsupportedOperationException("@Value is never required: " + parameter.getMethod());
    }

    private static class ExpressionValueNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        private ExpressionValueNamedValueInfo(Value annotation) {
            super("@Value", false, annotation.value());
        }
    }
}

