/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class DefaultResourceResolverChain
implements ResourceResolverChain {
    private final List<ResourceResolver> resolvers = new ArrayList<ResourceResolver>();
    private int index = -1;

    public DefaultResourceResolverChain(@Nullable List<? extends ResourceResolver> resolvers) {
        if (resolvers != null) {
            this.resolvers.addAll(resolvers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<Resource> resolveResource(@Nullable ServerWebExchange exchange2, String requestPath, List<? extends Resource> locations) {
        ResourceResolver resolver = this.getNext();
        if (resolver == null) {
            return Mono.empty();
        }
        try {
            Mono<Resource> mono = resolver.resolveResource(exchange2, requestPath, locations, this);
            return mono;
        }
        finally {
            --this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<String> resolveUrlPath(String resourcePath, List<? extends Resource> locations) {
        ResourceResolver resolver = this.getNext();
        if (resolver == null) {
            return Mono.empty();
        }
        try {
            Mono<String> mono = resolver.resolveUrlPath(resourcePath, locations, this);
            return mono;
        }
        finally {
            --this.index;
        }
    }

    @Nullable
    private ResourceResolver getNext() {
        Assert.state(this.index <= this.resolvers.size(), "Current index exceeds the number of configured ResourceResolvers");
        if (this.index == this.resolvers.size() - 1) {
            return null;
        }
        ++this.index;
        return this.resolvers.get(this.index);
    }
}

