/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private boolean lazyInitHandlers = false;
    private final Map<PathPattern, Object> handlerMap = new LinkedHashMap<PathPattern, Object>();

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    public final Map<PathPattern, Object> getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }

    public Mono<Object> getHandlerInternal(ServerWebExchange exchange2) {
        Object handler;
        PathContainer lookupPath = exchange2.getRequest().getPath().pathWithinApplication();
        try {
            handler = this.lookupHandler(lookupPath, exchange2);
        }
        catch (Exception ex) {
            return Mono.error(ex);
        }
        if (handler != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Mapping [" + lookupPath + "] to " + handler);
        } else if (handler == null && this.logger.isTraceEnabled()) {
            this.logger.trace("No handler mapping found for [" + lookupPath + "]");
        }
        return Mono.justOrEmpty(handler);
    }

    @Nullable
    protected Object lookupHandler(PathContainer lookupPath, ServerWebExchange exchange2) throws Exception {
        return this.handlerMap.entrySet().stream().filter(entry -> ((PathPattern)entry.getKey()).matches(lookupPath)).sorted((entry1, entry2) -> PathPattern.SPECIFICITY_COMPARATOR.compare((PathPattern)entry1.getKey(), (PathPattern)entry2.getKey())).findFirst().map(entry -> {
            PathPattern pattern = (PathPattern)entry.getKey();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Matching pattern for request [" + lookupPath + "] is " + pattern);
            }
            PathContainer pathWithinMapping = pattern.extractPathWithinPattern(lookupPath);
            return this.handleMatch(entry.getValue(), pattern, pathWithinMapping, exchange2);
        }).orElse(null);
    }

    private Object handleMatch(Object handler, PathPattern bestMatch, PathContainer pathWithinMapping, ServerWebExchange exchange2) {
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.obtainApplicationContext().getBean(handlerName);
        }
        this.validateHandler(handler, exchange2);
        exchange2.getAttributes().put(BEST_MATCHING_HANDLER_ATTRIBUTE, handler);
        exchange2.getAttributes().put(BEST_MATCHING_PATTERN_ATTRIBUTE, bestMatch);
        exchange2.getAttributes().put(PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, pathWithinMapping);
        return handler;
    }

    protected void validateHandler(Object handler, ServerWebExchange exchange2) {
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, "URL path array must not be null");
        for (String urlPath : urlPaths) {
            this.registerHandler(urlPath, (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Object existingHandler;
        Assert.notNull((Object)urlPath, "URL path must not be null");
        Assert.notNull(handler, "Handler object must not be null");
        Object resolvedHandler = handler;
        urlPath = AbstractUrlHandlerMapping.prependLeadingSlash(urlPath);
        PathPattern pattern = this.getPathPatternParser().parse(urlPath);
        if (this.handlerMap.containsKey(pattern) && (existingHandler = this.handlerMap.get(pattern)) != null && existingHandler != resolvedHandler) {
            throw new IllegalStateException("Cannot map " + this.getHandlerDescription(handler) + " to [" + urlPath + "]: there is already " + this.getHandlerDescription(existingHandler) + " mapped.");
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.obtainApplicationContext().isSingleton(handlerName)) {
                resolvedHandler = this.obtainApplicationContext().getBean(handlerName);
            }
        }
        this.handlerMap.put(pattern, resolvedHandler);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Mapped URL path [" + urlPath + "] onto " + this.getHandlerDescription(handler));
        }
    }

    private String getHandlerDescription(Object handler) {
        return "handler " + (handler instanceof String ? "'" + handler + "'" : "of type [" + handler.getClass() + "]");
    }

    private static String prependLeadingSlash(String pattern) {
        if (StringUtils.hasLength(pattern) && !pattern.startsWith("/")) {
            return "/" + pattern;
        }
        return pattern;
    }
}

