/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.DefaultEntityResponseBuilder;
import org.springframework.web.reactive.function.server.DefaultRenderingResponseBuilder;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class DefaultServerResponseBuilder
implements ServerResponse.BodyBuilder {
    private final int statusCode;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap<String, ResponseCookie>();
    private final Map<String, Object> hints = new HashMap<String, Object>();

    public DefaultServerResponseBuilder(ServerResponse other) {
        Assert.notNull((Object)other, "ServerResponse must not be null");
        this.statusCode = other instanceof AbstractServerResponse ? ((AbstractServerResponse)other).statusCode : other.statusCode().value();
        this.headers.addAll(other.headers());
    }

    public DefaultServerResponseBuilder(HttpStatus status) {
        Assert.notNull((Object)status, "HttpStatus must not be null");
        this.statusCode = status.value();
    }

    public DefaultServerResponseBuilder(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public ServerResponse.BodyBuilder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookie(ResponseCookie cookie) {
        Assert.notNull((Object)cookie, "ResponseCookie must not be null");
        this.cookies.add(cookie.getName(), cookie);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookies(Consumer<MultiValueMap<String, ResponseCookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentType(MediaType contentType2) {
        this.headers.setContentType(contentType2);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder eTag(String etag) {
        if (!etag.startsWith("\"") && !etag.startsWith("W/\"")) {
            etag = "\"" + etag;
        }
        if (!etag.endsWith("\"")) {
            etag = etag + "\"";
        }
        this.headers.setETag(etag);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder hint(String key, Object value) {
        this.hints.put(key, value);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder lastModified(ZonedDateTime lastModified) {
        this.headers.setZonedDateTime("Last-Modified", lastModified);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cacheControl(CacheControl cacheControl) {
        String ccValue = cacheControl.getHeaderValue();
        if (ccValue != null) {
            this.headers.setCacheControl(cacheControl.getHeaderValue());
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public Mono<ServerResponse> build() {
        return this.build((ServerWebExchange exchange2, ServerResponse.Context handlerStrategies) -> exchange2.getResponse().setComplete());
    }

    @Override
    public Mono<ServerResponse> build(Publisher<Void> voidPublisher) {
        Assert.notNull(voidPublisher, "Publisher must not be null");
        return this.build((ServerWebExchange exchange2, ServerResponse.Context handlerStrategies) -> Mono.from(voidPublisher).then(exchange2.getResponse().setComplete()));
    }

    @Override
    public Mono<ServerResponse> build(BiFunction<ServerWebExchange, ServerResponse.Context, Mono<Void>> writeFunction) {
        return Mono.just(new WriterFunctionResponse(this.statusCode, this.headers, this.cookies, writeFunction));
    }

    @Override
    public <T, P extends Publisher<T>> Mono<ServerResponse> body(P publisher, Class<T> elementClass) {
        Assert.notNull(publisher, "Publisher must not be null");
        Assert.notNull(elementClass, "Element Class must not be null");
        return new DefaultEntityResponseBuilder<P>(publisher, BodyInserters.fromPublisher(publisher, elementClass)).headers(this.headers).status(this.statusCode).build().map(entityResponse -> entityResponse);
    }

    @Override
    public <T, P extends Publisher<T>> Mono<ServerResponse> body(P publisher, ParameterizedTypeReference<T> typeReference) {
        Assert.notNull(publisher, "Publisher must not be null");
        Assert.notNull(typeReference, "ParameterizedTypeReference must not be null");
        return new DefaultEntityResponseBuilder<P>(publisher, BodyInserters.fromPublisher(publisher, typeReference)).headers(this.headers).status(this.statusCode).build().map(entityResponse -> entityResponse);
    }

    @Override
    public Mono<ServerResponse> syncBody(Object body2) {
        Assert.notNull(body2, "Body must not be null");
        Assert.isTrue(!(body2 instanceof Publisher), "Please specify the element class by using body(Publisher, Class)");
        return new DefaultEntityResponseBuilder<Object>(body2, BodyInserters.fromObject(body2)).headers(this.headers).status(this.statusCode).build().map(entityResponse -> entityResponse);
    }

    @Override
    public Mono<ServerResponse> body(BodyInserter<?, ? super ServerHttpResponse> inserter) {
        return Mono.just(new BodyInserterResponse(this.statusCode, this.headers, this.cookies, inserter, this.hints));
    }

    @Override
    public Mono<ServerResponse> render(String name, Object ... modelAttributes) {
        return new DefaultRenderingResponseBuilder(name).headers(this.headers).status(this.statusCode).modelAttributes(modelAttributes).build().map(renderingResponse -> renderingResponse);
    }

    @Override
    public Mono<ServerResponse> render(String name, Map<String, ?> model) {
        return new DefaultRenderingResponseBuilder(name).headers(this.headers).status(this.statusCode).modelAttributes(model).build().map(renderingResponse -> renderingResponse);
    }

    private static final class BodyInserterResponse<T>
    extends AbstractServerResponse {
        private final BodyInserter<T, ? super ServerHttpResponse> inserter;
        private final Map<String, Object> hints;

        public BodyInserterResponse(int statusCode, HttpHeaders headers2, MultiValueMap<String, ResponseCookie> cookies, BodyInserter<T, ? super ServerHttpResponse> body2, Map<String, Object> hints) {
            super(statusCode, headers2, cookies);
            Assert.notNull(body2, "BodyInserter must not be null");
            this.inserter = body2;
            this.hints = hints;
        }

        @Override
        protected Mono<Void> writeToInternal(final ServerWebExchange exchange2, final ServerResponse.Context context) {
            return this.inserter.insert(exchange2.getResponse(), new BodyInserter.Context(){

                @Override
                public List<HttpMessageWriter<?>> messageWriters() {
                    return context.messageWriters();
                }

                @Override
                public Optional<ServerHttpRequest> serverRequest() {
                    return Optional.of(exchange2.getRequest());
                }

                @Override
                public Map<String, Object> hints() {
                    return hints;
                }
            });
        }
    }

    private static final class WriterFunctionResponse
    extends AbstractServerResponse {
        private final BiFunction<ServerWebExchange, ServerResponse.Context, Mono<Void>> writeFunction;

        public WriterFunctionResponse(int statusCode, HttpHeaders headers2, MultiValueMap<String, ResponseCookie> cookies, BiFunction<ServerWebExchange, ServerResponse.Context, Mono<Void>> writeFunction) {
            super(statusCode, headers2, cookies);
            Assert.notNull(writeFunction, "BiFunction must not be null");
            this.writeFunction = writeFunction;
        }

        @Override
        protected Mono<Void> writeToInternal(ServerWebExchange exchange2, ServerResponse.Context context) {
            return this.writeFunction.apply(exchange2, context);
        }
    }

    static abstract class AbstractServerResponse
    implements ServerResponse {
        private static final Set<HttpMethod> SAFE_METHODS = EnumSet.of(HttpMethod.GET, HttpMethod.HEAD);
        final int statusCode;
        private final HttpHeaders headers;
        private final MultiValueMap<String, ResponseCookie> cookies;

        protected AbstractServerResponse(int statusCode, HttpHeaders headers2, MultiValueMap<String, ResponseCookie> cookies) {
            this.statusCode = statusCode;
            this.headers = HttpHeaders.readOnlyHttpHeaders(headers2);
            this.cookies = CollectionUtils.unmodifiableMultiValueMap(new LinkedMultiValueMap(cookies));
        }

        @Override
        public final HttpStatus statusCode() {
            return HttpStatus.valueOf(this.statusCode);
        }

        @Override
        public final HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public MultiValueMap<String, ResponseCookie> cookies() {
            return this.cookies;
        }

        @Override
        public final Mono<Void> writeTo(ServerWebExchange exchange2, ServerResponse.Context context) {
            this.writeStatusAndHeaders(exchange2.getResponse());
            Instant lastModified = Instant.ofEpochMilli(this.headers().getLastModified());
            HttpMethod httpMethod = exchange2.getRequest().getMethod();
            if (SAFE_METHODS.contains((Object)httpMethod) && exchange2.checkNotModified(this.headers().getETag(), lastModified)) {
                return exchange2.getResponse().setComplete();
            }
            return this.writeToInternal(exchange2, context);
        }

        private void writeStatusAndHeaders(ServerHttpResponse response) {
            if (response instanceof AbstractServerHttpResponse) {
                ((AbstractServerHttpResponse)response).setStatusCodeValue(this.statusCode);
            } else {
                HttpStatus status = HttpStatus.resolve(this.statusCode);
                if (status == null) {
                    throw new IllegalStateException("Unresolvable HttpStatus for general ServerHttpResponse: " + this.statusCode);
                }
                response.setStatusCode(status);
            }
            AbstractServerResponse.copy(this.headers, response.getHeaders());
            AbstractServerResponse.copy(this.cookies, response.getCookies());
        }

        protected abstract Mono<Void> writeToInternal(ServerWebExchange var1, ServerResponse.Context var2);

        private static <K, V> void copy(MultiValueMap<K, V> src, MultiValueMap<K, V> dst) {
            if (!src.isEmpty()) {
                src.entrySet().stream().filter(entry -> !dst.containsKey(entry.getKey())).forEach(entry -> {
                    List cfr_ignored_0 = (List)dst.put(entry.getKey(), entry.getValue());
                });
            }
        }
    }
}

