/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cache.Cache;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.CacheControl;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.config.ResourceChainRegistration;
import org.springframework.web.reactive.resource.ResourceWebHandler;

public class ResourceHandlerRegistration {
    private final ResourceLoader resourceLoader;
    private final String[] pathPatterns;
    private final List<Resource> locations = new ArrayList<Resource>();
    @Nullable
    private CacheControl cacheControl;
    @Nullable
    private ResourceChainRegistration resourceChainRegistration;

    public ResourceHandlerRegistration(ResourceLoader resourceLoader, String ... pathPatterns) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader is required");
        Assert.notEmpty((Object[])pathPatterns, "At least one path pattern is required for resource handling");
        this.resourceLoader = resourceLoader;
        this.pathPatterns = pathPatterns;
    }

    public ResourceHandlerRegistration addResourceLocations(String ... resourceLocations) {
        for (String location : resourceLocations) {
            this.locations.add(this.resourceLoader.getResource(location));
        }
        return this;
    }

    public ResourceHandlerRegistration setCacheControl(CacheControl cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public ResourceChainRegistration resourceChain(boolean cacheResources) {
        this.resourceChainRegistration = new ResourceChainRegistration(cacheResources);
        return this.resourceChainRegistration;
    }

    public ResourceChainRegistration resourceChain(boolean cacheResources, Cache cache) {
        this.resourceChainRegistration = new ResourceChainRegistration(cacheResources, cache);
        return this.resourceChainRegistration;
    }

    protected String[] getPathPatterns() {
        return this.pathPatterns;
    }

    protected ResourceWebHandler getRequestHandler() {
        ResourceWebHandler handler = new ResourceWebHandler();
        if (this.resourceChainRegistration != null) {
            handler.setResourceResolvers(this.resourceChainRegistration.getResourceResolvers());
            handler.setResourceTransformers(this.resourceChainRegistration.getResourceTransformers());
        }
        handler.setLocations(this.locations);
        if (this.cacheControl != null) {
            handler.setCacheControl(this.cacheControl);
        }
        return handler;
    }
}

