/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.DefaultDataBinderFactory;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.InvocableHandlerMethod;

public class InitBinderDataBinderFactory
extends DefaultDataBinderFactory {
    private final List<InvocableHandlerMethod> binderMethods;

    public InitBinderDataBinderFactory(@Nullable List<InvocableHandlerMethod> binderMethods, @Nullable WebBindingInitializer initializer) {
        super(initializer);
        this.binderMethods = binderMethods != null ? binderMethods : Collections.emptyList();
    }

    @Override
    public void initBinder(WebDataBinder binder, NativeWebRequest request) throws Exception {
        for (InvocableHandlerMethod binderMethod : this.binderMethods) {
            Object returnValue;
            if (!this.isBinderMethodApplicable(binderMethod, binder) || (returnValue = binderMethod.invokeForRequest(request, null, binder)) == null) continue;
            throw new IllegalStateException("@InitBinder methods should return void: " + binderMethod);
        }
    }

    protected boolean isBinderMethodApplicable(HandlerMethod binderMethod, WebDataBinder binder) {
        InitBinder ann = binderMethod.getMethodAnnotation(InitBinder.class);
        Assert.state(ann != null, "No InitBinder annotation");
        List<String> names = Arrays.asList(ann.value());
        return names.isEmpty() || names.contains(binder.getObjectName());
    }
}

