/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class StatusResultMatchers {
    protected StatusResultMatchers() {
    }

    public ResultMatcher is(Matcher<Integer> matcher) {
        return result -> MatcherAssert.assertThat((String)"Response status", (Object)result.getResponse().getStatus(), (Matcher)matcher);
    }

    public ResultMatcher is(int status) {
        return result -> AssertionErrors.assertEquals("Response status", status, result.getResponse().getStatus());
    }

    public ResultMatcher is1xxInformational() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), (Object)HttpStatus.Series.INFORMATIONAL, (Object)this.getHttpStatusSeries(result));
    }

    public ResultMatcher is2xxSuccessful() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), (Object)HttpStatus.Series.SUCCESSFUL, (Object)this.getHttpStatusSeries(result));
    }

    public ResultMatcher is3xxRedirection() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), (Object)HttpStatus.Series.REDIRECTION, (Object)this.getHttpStatusSeries(result));
    }

    public ResultMatcher is4xxClientError() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), (Object)HttpStatus.Series.CLIENT_ERROR, (Object)this.getHttpStatusSeries(result));
    }

    public ResultMatcher is5xxServerError() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), (Object)HttpStatus.Series.SERVER_ERROR, (Object)this.getHttpStatusSeries(result));
    }

    private HttpStatus.Series getHttpStatusSeries(MvcResult result) {
        int statusValue = result.getResponse().getStatus();
        HttpStatus status = HttpStatus.valueOf(statusValue);
        return status.series();
    }

    public ResultMatcher reason(Matcher<? super String> matcher) {
        return result -> MatcherAssert.assertThat((String)"Response status reason", (Object)result.getResponse().getErrorMessage(), (Matcher)matcher);
    }

    public ResultMatcher reason(String reason) {
        return result -> AssertionErrors.assertEquals("Response status reason", reason, result.getResponse().getErrorMessage());
    }

    public ResultMatcher isContinue() {
        return this.matcher(HttpStatus.CONTINUE);
    }

    public ResultMatcher isSwitchingProtocols() {
        return this.matcher(HttpStatus.SWITCHING_PROTOCOLS);
    }

    public ResultMatcher isProcessing() {
        return this.matcher(HttpStatus.PROCESSING);
    }

    public ResultMatcher isCheckpoint() {
        return this.matcher(HttpStatus.valueOf(103));
    }

    public ResultMatcher isOk() {
        return this.matcher(HttpStatus.OK);
    }

    public ResultMatcher isCreated() {
        return this.matcher(HttpStatus.CREATED);
    }

    public ResultMatcher isAccepted() {
        return this.matcher(HttpStatus.ACCEPTED);
    }

    public ResultMatcher isNonAuthoritativeInformation() {
        return this.matcher(HttpStatus.NON_AUTHORITATIVE_INFORMATION);
    }

    public ResultMatcher isNoContent() {
        return this.matcher(HttpStatus.NO_CONTENT);
    }

    public ResultMatcher isResetContent() {
        return this.matcher(HttpStatus.RESET_CONTENT);
    }

    public ResultMatcher isPartialContent() {
        return this.matcher(HttpStatus.PARTIAL_CONTENT);
    }

    public ResultMatcher isMultiStatus() {
        return this.matcher(HttpStatus.MULTI_STATUS);
    }

    public ResultMatcher isAlreadyReported() {
        return this.matcher(HttpStatus.ALREADY_REPORTED);
    }

    public ResultMatcher isImUsed() {
        return this.matcher(HttpStatus.IM_USED);
    }

    public ResultMatcher isMultipleChoices() {
        return this.matcher(HttpStatus.MULTIPLE_CHOICES);
    }

    public ResultMatcher isMovedPermanently() {
        return this.matcher(HttpStatus.MOVED_PERMANENTLY);
    }

    public ResultMatcher isFound() {
        return this.matcher(HttpStatus.FOUND);
    }

    @Deprecated
    public ResultMatcher isMovedTemporarily() {
        return this.matcher(HttpStatus.MOVED_TEMPORARILY);
    }

    public ResultMatcher isSeeOther() {
        return this.matcher(HttpStatus.SEE_OTHER);
    }

    public ResultMatcher isNotModified() {
        return this.matcher(HttpStatus.NOT_MODIFIED);
    }

    @Deprecated
    public ResultMatcher isUseProxy() {
        return this.matcher(HttpStatus.USE_PROXY);
    }

    public ResultMatcher isTemporaryRedirect() {
        return this.matcher(HttpStatus.TEMPORARY_REDIRECT);
    }

    public ResultMatcher isPermanentRedirect() {
        return this.matcher(HttpStatus.valueOf(308));
    }

    public ResultMatcher isBadRequest() {
        return this.matcher(HttpStatus.BAD_REQUEST);
    }

    public ResultMatcher isUnauthorized() {
        return this.matcher(HttpStatus.UNAUTHORIZED);
    }

    public ResultMatcher isPaymentRequired() {
        return this.matcher(HttpStatus.PAYMENT_REQUIRED);
    }

    public ResultMatcher isForbidden() {
        return this.matcher(HttpStatus.FORBIDDEN);
    }

    public ResultMatcher isNotFound() {
        return this.matcher(HttpStatus.NOT_FOUND);
    }

    public ResultMatcher isMethodNotAllowed() {
        return this.matcher(HttpStatus.METHOD_NOT_ALLOWED);
    }

    public ResultMatcher isNotAcceptable() {
        return this.matcher(HttpStatus.NOT_ACCEPTABLE);
    }

    public ResultMatcher isProxyAuthenticationRequired() {
        return this.matcher(HttpStatus.PROXY_AUTHENTICATION_REQUIRED);
    }

    public ResultMatcher isRequestTimeout() {
        return this.matcher(HttpStatus.REQUEST_TIMEOUT);
    }

    public ResultMatcher isConflict() {
        return this.matcher(HttpStatus.CONFLICT);
    }

    public ResultMatcher isGone() {
        return this.matcher(HttpStatus.GONE);
    }

    public ResultMatcher isLengthRequired() {
        return this.matcher(HttpStatus.LENGTH_REQUIRED);
    }

    public ResultMatcher isPreconditionFailed() {
        return this.matcher(HttpStatus.PRECONDITION_FAILED);
    }

    public ResultMatcher isPayloadTooLarge() {
        return this.matcher(HttpStatus.PAYLOAD_TOO_LARGE);
    }

    @Deprecated
    public ResultMatcher isRequestEntityTooLarge() {
        return this.matcher(HttpStatus.REQUEST_ENTITY_TOO_LARGE);
    }

    public ResultMatcher isUriTooLong() {
        return this.matcher(HttpStatus.URI_TOO_LONG);
    }

    @Deprecated
    public ResultMatcher isRequestUriTooLong() {
        return this.matcher(HttpStatus.REQUEST_URI_TOO_LONG);
    }

    public ResultMatcher isUnsupportedMediaType() {
        return this.matcher(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    public ResultMatcher isRequestedRangeNotSatisfiable() {
        return this.matcher(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
    }

    public ResultMatcher isExpectationFailed() {
        return this.matcher(HttpStatus.EXPECTATION_FAILED);
    }

    public ResultMatcher isIAmATeapot() {
        return this.matcher(HttpStatus.valueOf(418));
    }

    @Deprecated
    public ResultMatcher isInsufficientSpaceOnResource() {
        return this.matcher(HttpStatus.INSUFFICIENT_SPACE_ON_RESOURCE);
    }

    @Deprecated
    public ResultMatcher isMethodFailure() {
        return this.matcher(HttpStatus.METHOD_FAILURE);
    }

    @Deprecated
    public ResultMatcher isDestinationLocked() {
        return this.matcher(HttpStatus.DESTINATION_LOCKED);
    }

    public ResultMatcher isUnprocessableEntity() {
        return this.matcher(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public ResultMatcher isLocked() {
        return this.matcher(HttpStatus.LOCKED);
    }

    public ResultMatcher isFailedDependency() {
        return this.matcher(HttpStatus.FAILED_DEPENDENCY);
    }

    public ResultMatcher isUpgradeRequired() {
        return this.matcher(HttpStatus.UPGRADE_REQUIRED);
    }

    public ResultMatcher isPreconditionRequired() {
        return this.matcher(HttpStatus.valueOf(428));
    }

    public ResultMatcher isTooManyRequests() {
        return this.matcher(HttpStatus.valueOf(429));
    }

    public ResultMatcher isRequestHeaderFieldsTooLarge() {
        return this.matcher(HttpStatus.valueOf(431));
    }

    public ResultMatcher isUnavailableForLegalReasons() {
        return this.matcher(HttpStatus.valueOf(451));
    }

    public ResultMatcher isInternalServerError() {
        return this.matcher(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public ResultMatcher isNotImplemented() {
        return this.matcher(HttpStatus.NOT_IMPLEMENTED);
    }

    public ResultMatcher isBadGateway() {
        return this.matcher(HttpStatus.BAD_GATEWAY);
    }

    public ResultMatcher isServiceUnavailable() {
        return this.matcher(HttpStatus.SERVICE_UNAVAILABLE);
    }

    public ResultMatcher isGatewayTimeout() {
        return this.matcher(HttpStatus.GATEWAY_TIMEOUT);
    }

    public ResultMatcher isHttpVersionNotSupported() {
        return this.matcher(HttpStatus.HTTP_VERSION_NOT_SUPPORTED);
    }

    public ResultMatcher isVariantAlsoNegotiates() {
        return this.matcher(HttpStatus.VARIANT_ALSO_NEGOTIATES);
    }

    public ResultMatcher isInsufficientStorage() {
        return this.matcher(HttpStatus.INSUFFICIENT_STORAGE);
    }

    public ResultMatcher isLoopDetected() {
        return this.matcher(HttpStatus.LOOP_DETECTED);
    }

    public ResultMatcher isBandwidthLimitExceeded() {
        return this.matcher(HttpStatus.valueOf(509));
    }

    public ResultMatcher isNotExtended() {
        return this.matcher(HttpStatus.NOT_EXTENDED);
    }

    public ResultMatcher isNetworkAuthenticationRequired() {
        return this.matcher(HttpStatus.valueOf(511));
    }

    private ResultMatcher matcher(HttpStatus status) {
        return result -> AssertionErrors.assertEquals("Status", status.value(), result.getResponse().getStatus());
    }
}

