/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.ui;

import java.nio.charset.Charset;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LogoutPageGeneratingWebFilter
implements WebFilter {
    private ServerWebExchangeMatcher matcher = ServerWebExchangeMatchers.pathMatchers(HttpMethod.GET, "/logout");

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return this.matcher.matches(exchange2).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange2).then(Mono.empty())).flatMap(matchResult -> this.render(exchange2));
    }

    private Mono<Void> render(ServerWebExchange exchange2) {
        ServerHttpResponse result = exchange2.getResponse();
        result.setStatusCode(HttpStatus.OK);
        result.getHeaders().setContentType(MediaType.TEXT_HTML);
        return result.writeWith(this.createBuffer(exchange2));
    }

    private Mono<DataBuffer> createBuffer(ServerWebExchange exchange2) {
        Mono<CsrfToken> token = exchange2.getAttributeOrDefault(CsrfToken.class.getName(), Mono.empty());
        return token.map(LogoutPageGeneratingWebFilter::csrfToken).defaultIfEmpty("").map(csrfTokenHtmlInput -> {
            byte[] bytes = LogoutPageGeneratingWebFilter.createPage(csrfTokenHtmlInput);
            DataBufferFactory bufferFactory = exchange2.getResponse().bufferFactory();
            return bufferFactory.wrap(bytes);
        });
    }

    private static byte[] createPage(String csrfTokenHtmlInput) {
        String page = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n    <title>Confirm Log Out?</title>\n    <link href=\"https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/css/bootstrap.min.css\" rel=\"stylesheet\" integrity=\"sha384-/Y6pD6FV/Vv2HJnA6t+vslU6fwYXjCFtcEpHbNJ0lyAFsXTsjBbfaDjzALeQsN6M\" crossorigin=\"anonymous\">\n    <link href=\"http://getbootstrap.com/docs/4.0/examples/signin/signin.css\" rel=\"stylesheet\" crossorigin=\"anonymous\"/>\n  </head>\n  <body>\n     <div class=\"container\">\n      <form class=\"form-signin\" method=\"post\" action=\"/logout\">\n        <h2 class=\"form-signin-heading\">Are you sure you want to log out?</h2>\n" + csrfTokenHtmlInput + "        <button class=\"btn btn-lg btn-primary btn-block\" type=\"submit\">Log Out</button>\n      </form>\n    </div>\n  </body>\n</html>";
        return page.getBytes(Charset.defaultCharset());
    }

    private static String csrfToken(CsrfToken token) {
        return "          <input type=\"hidden\" name=\"" + token.getParameterName() + "\" value=\"" + token.getToken() + "\">\n";
    }
}

